/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumStringFormatStyle;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.ccstudio.debug.memoryserver.target.UnimplementedDebugServerMethods;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;

public class DataValueFormatter {
    private IDspUser refDspUser = null;
    private IDspValue refDspValue = null;
    private IDspValue myDspValue = null;
    protected short errorCode = 0;
    private String errorString = "";
    protected String originalCExpression = "";
    private int floatingPointQ = 15;

    public DataValueFormatter(TargetHandler targetHdlr) {
        this.refDspUser = targetHdlr.getDspUser();
    }

    public IDspValue getDspValue() {
        IDspValue result = this.myDspValue;
        if (result == null) {
            result = this.refDspValue;
        }
        return result;
    }

    public void setDspValue(IDspValue value) {
        this.refDspValue = value;
        if (this.myDspValue != null) {
            if (!this.myDspValue.isDisposed()) {
                this.myDspValue.dispose();
            }
            this.myDspValue = null;
        }
    }

    public short getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(short value) {
        this.errorCode = value;
        this.errorString = this.errorCode == 0 ? "" : this.doDspUserGetCExprEvalErrorInfo(this.errorCode);
    }

    public String getErrorString() {
        return this.errorString;
    }

    public void setErrorString(String value) {
        this.errorString = value;
    }

    public String getOriginalCExpression() {
        return this.originalCExpression;
    }

    public int getFloatingPointQ() {
        return this.floatingPointQ;
    }

    public void setFloatingPointQ(int value) {
        this.floatingPointQ = value;
    }

    public void storeEvaluationResult(short errCode, IDspValue dspValueObj) {
        this.setDspValue(dspValueObj);
        this.errorCode = errCode;
    }

    public void storeEvalutationResult(short errCode, int data) {
        if (this.refDspValue == null) {
            this.myDspValue = this.refDspUser.createDspValue(EnumDspValueType.DSP_LONG.getInt(), data);
        } else {
            this.refDspValue.assignLong(data);
        }
    }

    public void release() {
        this.releaseReferencesOnly();
        if (this.myDspValue != null && !this.myDspValue.isDisposed()) {
            this.myDspValue.dispose();
        }
    }

    public void releaseReferencesOnly() {
        this.refDspValue = null;
        this.refDspUser = null;
    }

    public long getLong() {
        EnumDspValueType valueType = EnumDspValueType.fromInt(this.refDspValue.getType());
        return this.getLong(valueType, 0);
    }

    public long getLong(EnumDspValueType dspValueType, int qValue) {
        if (this.getDspValue() != null && !this.getDspValue().isDisposed()) {
            IDspValue tempDspValue = this.refDspUser.createDspValue(dspValueType.getInt(), 0);
            IDspValue tempDspValue2 = this.DspValue_typeCast(tempDspValue, dspValueType, qValue);
            tempDspValue2.assign(this.getDspValue());
            if (this.myDspValue != null && !this.myDspValue.isDisposed()) {
                this.myDspValue.dispose();
            }
            this.myDspValue = this.DspValue_typeCast(tempDspValue2, dspValueType, qValue);
            if (!tempDspValue.isDisposed()) {
                tempDspValue.dispose();
            }
            if (!tempDspValue2.isDisposed()) {
                tempDspValue2.dispose();
            }
        }
        long result = 0L;
        switch (dspValueType) {
            case DSP_DATA40: {
                result = this.get40bLong();
                break;
            }
            case DSP_DATA48: {
                result = this.get48bLong();
                break;
            }
            case DSP_DATA64: {
                result = this.get64bLong();
                break;
            }
            case DSP_UDATA40: 
            case DSP_UDATA48: 
            case DSP_UDATA64: {
                result = this.getU64bLong();
                break;
            }
            default: {
                if (this.getDspValue() == null) break;
                result = this.getDspValue().toLongLong();
            }
        }
        return result;
    }

    public long getLongAdrs() {
        long result = 0L;
        IDspValue dspLongAdrs = null;
        if (this.refDspUser != null && (dspLongAdrs = this.refDspUser.createDspValue(EnumDspValueType.DSP_FAR_POINTER.getInt(), 0)) != null && this.getDspValue() != null) {
            if (dspLongAdrs.sizeOf() == 0) {
                dspLongAdrs = this.refDspUser.createDspValue(EnumDspValueType.DSP_POINTER.getInt(), 0);
            }
            dspLongAdrs.assign(this.getDspValue());
            result = dspLongAdrs.toLongLong();
            dspLongAdrs.dispose();
        }
        return result;
    }

    long get64bLong() {
        long result = 0L;
        if (this.getDspValue() != null) {
            String strResult = this.getDspValue().toStringCStyleHex();
            if ((strResult = strResult.toLowerCase()).startsWith("0x")) {
                strResult = strResult.substring(2, strResult.length());
                result = Long.parseLong(strResult, 16);
            } else {
                result = Long.parseLong(strResult);
            }
        }
        return result;
    }

    long get40bLong() {
        long result = 0L;
        if (this.getDspValue() != null) {
            String strResult = this.getDspValue().toStringCStyleHex();
            if ((strResult = strResult.toLowerCase()).startsWith("0x")) {
                strResult = strResult.substring(2, strResult.length());
                result = Long.parseLong(strResult, 16);
            } else {
                result = Long.parseLong(strResult);
            }
            if (result > 0L && (result & 0x8000000000L) != 0L) {
                long mask = 0xFFFFFFFFFFL;
                result |= (mask ^= 0xFFFFFFFFFFFFFFFFL);
            }
        }
        return result;
    }

    long get48bLong() {
        long result = 0L;
        if (this.getDspValue() != null) {
            String strResult = this.getDspValue().toStringCStyleHex();
            if ((strResult = strResult.toLowerCase()).startsWith("0x")) {
                strResult = strResult.substring(2, strResult.length());
                result = Long.parseLong(strResult, 16);
            } else {
                result = Long.parseLong(strResult);
            }
            if (result > 0L && (result & 0x800000000000L) != 0L) {
                long mask = 0xFFFFFFFFFFFFL;
                result |= (mask ^= 0xFFFFFFFFFFFFFFFFL);
            }
        }
        return result;
    }

    long getU64bLong() {
        long result = 0L;
        if (this.getDspValue() != null) {
            String strResult = this.getDspValue().toStringCStyleHex();
            if ((strResult = strResult.toLowerCase()).startsWith("0x")) {
                strResult = strResult.substring(2, strResult.length());
                result = Long.parseLong(strResult, 16);
            } else {
                result = Long.parseLong(strResult);
            }
        }
        return result;
    }

    public double getFloat() {
        double result = this.getDspValue().toDouble();
        return result;
    }

    public String getString(EnumStringFormatStyle StringFormat, EnumDspValueType dspValueType, short qValue) {
        String result = "";
        if (this.getDspValue() != null && qValue != 0 && dspValueType.getInt() != this.getDspValue().getType()) {
            IDspValue tempDspValue = this.refDspUser.createDspValue(dspValueType.getInt(), 0);
            tempDspValue = this.DspValue_typeCast(tempDspValue, dspValueType, qValue);
            tempDspValue.assign(this.getDspValue());
            if (this.myDspValue != null && !this.myDspValue.isDisposed()) {
                this.myDspValue.dispose();
            }
            this.myDspValue = this.DspValue_typeCast(tempDspValue, dspValueType, qValue);
            if (!tempDspValue.isDisposed()) {
                tempDspValue.dispose();
            }
        }
        if (this.getDspValue() != null) {
            switch (StringFormat) {
                case BINARY: {
                    result = this.getDspValue().toStringBinary();
                    break;
                }
                case OCTAL: {
                    result = UnimplementedDebugServerMethods.getDspValue_ToStringOctal(this.getDspValue());
                    break;
                }
                case CHARACTER: {
                    result = this.getDspValue().toStringChar();
                    break;
                }
                case SIGNED_INTEGER: {
                    if (this.floatingPointQ != 0) {
                        result = this.getDspValue().toStringReal((short)this.floatingPointQ);
                        break;
                    }
                    result = this.getDspValue().toStringSignedInt();
                    break;
                }
                case UNSIGNED_INTEGER: {
                    if (this.floatingPointQ != 0) {
                        result = this.getDspValue().toStringReal((short)this.floatingPointQ);
                        break;
                    }
                    result = this.getDspValue().toStringUnsignedInt();
                    break;
                }
                case C_STYLE_HEX: {
                    result = this.getDspValue().toStringCStyleHex();
                    break;
                }
                case TI_STYLE_HEX: {
                    result = this.getDspValue().toStringTIStyleHex();
                    break;
                }
                case SCIENTIFIC: {
                    result = this.getDspValue().toStringScientific((short)this.floatingPointQ);
                    break;
                }
                case REAL: {
                    result = this.getDspValue().toStringReal((short)this.floatingPointQ);
                    break;
                }
                case PACKED_CHAR: {
                    result = UnimplementedDebugServerMethods.getDspValue_ToStringPackedChar(this.refDspValue);
                }
            }
        }
        return result;
    }

    public void requestInfoFromTarget(String strCExpression) {
        this.originalCExpression = strCExpression;
        if (this.refDspUser != null && !this.refDspUser.isDisposed()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
                MemoryServerTrace.logTransaction("Evaluating C Expression:" + strCExpression, "DataValueFormatter.requestInfoFromTarget", null);
            }
            try {
                this.refDspUser.requestCExprEval(this.originalCExpression);
            }
            catch (Exception ex) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException("Exception calling refDspUser.requestCExprEval(" + strCExpression + ")", "DataValueFormatter.requestInfoFromTarget", ex, null);
                }
            }
        } else if (this.refDspUser != null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
            MemoryServerTrace.logWarning("attempt to request info from target after refDspUser was disposed (strCExpression = " + strCExpression + ")", "DataValueFormatter.requestInfoFromTarget", null);
        }
    }

    protected String doDspUserGetCExprEvalErrorInfo(short errorCode) {
        return this.refDspUser.cEvalErrorMessage(errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDspValue DspValue_typeCast(IDspValue oldDspValue, EnumDspValueType dspValueType, int floatingPointQ) {
        IDspValue dspValue = null;
        try {
            dspValue = oldDspValue.typeCast(dspValueType.getInt(), floatingPointQ);
        }
        finally {
            if (dspValue == null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError("Failed typecasting DspValue(type = " + dspValueType.toString() + ") COM Object", "MemoryRWHandler.DspValueAndItsType.typeCast", null);
            }
            if (oldDspValue != null && !oldDspValue.isDisposed()) {
                oldDspValue.dispose();
            }
        }
        return dspValue;
    }
}

