/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.interfaces.IEventListenerItem;
import java.util.concurrent.ConcurrentLinkedQueue;

public class EventHandlerThread
implements IDisposable {
    private final ConcurrentLinkedQueue<IEventListenerItem> eventQueue = new ConcurrentLinkedQueue();
    private EventQueueListener eventHdlrThread = new EventQueueListener("MemoryServer.EventQueue", this.eventQueue);
    private boolean isCanceled = false;
    private volatile boolean isDisposed = false;

    public EventHandlerThread() {
        this.eventHdlrThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IEventListenerItem item) throws InterruptedException {
        if (this.eventHdlrThread != null) {
            EventQueueListener eventQueueListener = this.eventHdlrThread;
            synchronized (eventQueueListener) {
                this.eventQueue.add(item);
                this.eventHdlrThread.notify();
            }
        }
    }

    public void clearEventList() {
        this.eventQueue.clear();
    }

    public EventQueueListener getThread() {
        return this.eventHdlrThread;
    }

    public void cancel() {
        this.isCanceled = true;
        if (this.eventHdlrThread != null && this.eventHdlrThread.isAlive()) {
            this.eventHdlrThread.interrupt();
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public synchronized void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            if (this.eventQueue != null) {
                this.eventQueue.clear();
            }
        }
    }

    class EventQueueListener
    extends Thread {
        private final ConcurrentLinkedQueue<IEventListenerItem> eventQueue;

        public EventQueueListener(String name, ConcurrentLinkedQueue<IEventListenerItem> eventQueue) {
            super(name);
            this.eventQueue = eventQueue;
            this.setPriority(5);
        }

        EventQueueListener(ConcurrentLinkedQueue<IEventListenerItem> q) {
            this.eventQueue = q;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean ok = true;
            try {
                while (!EventHandlerThread.this.isCanceled()) {
                    if (!this.eventQueue.isEmpty()) {
                        this.setPriority(7);
                        while (!this.eventQueue.isEmpty()) {
                            this.consume((IEventListenerItem)this.eventQueue.remove());
                        }
                        this.setPriority(5);
                    }
                    EventQueueListener eventQueueListener = this;
                    synchronized (eventQueueListener) {
                        if (this.eventQueue.isEmpty()) {
                            this.wait();
                        }
                    }
                }
            }
            catch (InterruptedException ex) {
                ok = false;
            }
            EventHandlerThread.this.dispose();
        }

        void consume(IEventListenerItem eventHdlrItem) {
            eventHdlrItem.raise();
        }
    }
}

