/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.MemoryPageHandler;
import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumAttributeTypeFlags;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumFactoryObjectStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumGtiMemResult;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumSpecialDisplayStrings;
import com.ti.ccstudio.debug.memoryserver.enums.EnumStringFormatStyle;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.interfaces.IFactoryCreatedObject;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRegion;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestClient;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMmuHandler;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRecyclingFactory;
import com.ti.ccstudio.debug.memoryserver.maps.AdrsRegion;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.CExprRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorQueue;
import com.ti.ccstudio.debug.memoryserver.target.DataValueFormatter;
import com.ti.ccstudio.debug.memoryserver.target.MemoryRWHandlerBaseClass;
import com.ti.ccstudio.debug.memoryserver.target.TargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspMemory2;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class MemoryRWHandler
extends MemoryRWHandlerBaseClass
implements IMemoryRequestClient,
IFactoryCreatedObject {
    public static int dspValueAndItsTypeID = 0;
    private IDspUser refDspUser = null;
    private IDspValue dspAdrs = null;
    protected MemoryPageHandler owner = null;
    protected TargetHandler targetHdlr = null;
    protected TargetDeviceInfo targetInfo = null;
    protected DspValueAndItsType currentDspValueAndItsType = null;
    protected ArrayList<DspValueAndItsType> listOfDspValuesWithDifferentDataTypes = null;
    private String idOfLastConfiguredRequest = "";
    private boolean isConfigured = false;
    protected DataValueFormatter dataValueFormatter = null;
    private MemoryRequestDescriptor originalRequest;
    private short memoryPageNumber = 0;
    private int memoryHierarchyReadEnableFlags = 0;
    private EnumSet<EnumAttributeTypeFlags> requestedMemoryAttributeFlags = EnumSet.noneOf(EnumAttributeTypeFlags.class);
    private EnumStringFormatStyle formatStyle = EnumStringFormatStyle.C_STYLE_HEX;
    protected EnumDspValueType formatDataType;
    private short floatingPointQ = (short)15;
    private EnumMemoryViews memoryView = EnumMemoryViews.CPU_MEMORY_VIEW;
    private IMmuHandler mmuHdlr = null;
    private IRecyclingFactory factory = null;
    private String factoryObjectId = "";
    private EnumFactoryObjectStates factoryObjectState = EnumFactoryObjectStates.CREATED;
    private volatile boolean disposed = false;

    public MemoryRWHandler(MemoryPageHandler owner, TargetHandler targetHdlr, IMmuHandler mmuHdlr) {
        this.owner = owner;
        this.targetHdlr = targetHdlr;
        this.targetInfo = (TargetDeviceInfo)targetHdlr.getInfo();
        this.mmuHdlr = mmuHdlr;
        this.setFormatStyle(EnumStringFormatStyle.TI_STYLE_HEX);
        this.listOfDspValuesWithDifferentDataTypes = new ArrayList();
        this.setDataValueFormatter(new DataValueFormatter(targetHdlr));
    }

    protected MemoryRWHandler() {
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public DataValueFormatter getDataValueFormatter() {
        return this.dataValueFormatter;
    }

    private void setDataValueFormatter(DataValueFormatter value) {
        this.dataValueFormatter = value;
    }

    public RequestDescriptorQueue getTargetAccessRequestQueue() {
        return this.owner.getTargetAccessRequestQueue();
    }

    public RequestDescriptorQueue getCExprEvalRequestQueue() {
        return this.owner.getCExprEvalRequestQueue();
    }

    public MemoryRequestDescriptor getOriginalRequest() {
        return this.originalRequest;
    }

    @Override
    public short getMemoryPageNumber() {
        return this.memoryPageNumber;
    }

    @Override
    public void setMemoryPageNumber(short value) {
        this.memoryPageNumber = value;
    }

    @Override
    public int getMemoryHierarchyReadEnableFlags() {
        return this.memoryHierarchyReadEnableFlags;
    }

    @Override
    public void setMemoryHierarchyReadEnableFlags(int value) {
        this.memoryHierarchyReadEnableFlags = value;
    }

    public EnumSet<EnumAttributeTypeFlags> getRequestedMemoryAttributeFlags() {
        return this.requestedMemoryAttributeFlags;
    }

    public void setRequestMemoryAttributeFlags(EnumSet<EnumAttributeTypeFlags> value) {
        this.requestedMemoryAttributeFlags.clear();
        this.requestedMemoryAttributeFlags.addAll(value);
    }

    @Override
    public EnumStringFormatStyle getFormatStyle() {
        return this.formatStyle;
    }

    @Override
    public void setFormatStyle(EnumStringFormatStyle value) {
        this.formatStyle = value;
    }

    @Override
    public EnumDspValueType getFormatDataType() {
        return this.formatDataType;
    }

    @Override
    public void setFormatDataType(EnumDspValueType value) {
        if (this.refDspUser == null) {
            this.initDspUser();
        }
        if (this.formatDataType != value) {
            this.formatDataType = value;
        }
        if (this.currentDspValueAndItsType == null || this.currentDspValueAndItsType.getDspValueType().getInt() != this.formatDataType.getInt()) {
            boolean found = false;
            for (DspValueAndItsType existingDspValueAndItsType : this.listOfDspValuesWithDifferentDataTypes) {
                if (existingDspValueAndItsType.getDspValueType().getInt() != this.formatDataType.getInt()) continue;
                this.currentDspValueAndItsType = existingDspValueAndItsType;
                found = true;
                break;
            }
            if (!found) {
                this.currentDspValueAndItsType = new DspValueAndItsType(this.refDspUser, this.formatDataType);
                this.listOfDspValuesWithDifferentDataTypes.add(this.currentDspValueAndItsType);
            }
        }
    }

    @Override
    public short getFloatingPointQ() {
        return this.floatingPointQ;
    }

    @Override
    public void setFloatingPointQ(short value) {
        this.floatingPointQ = value;
    }

    @Override
    public EnumMemoryViews getMemoryView() {
        return this.memoryView;
    }

    @Override
    public void setMemoryView(EnumMemoryViews value) {
        this.memoryView = value;
    }

    public IMmuHandler getMmuHdlr() {
        return this.mmuHdlr;
    }

    public void setMmuHdlr(IMmuHandler value) {
        this.mmuHdlr = value;
    }

    private void initDspUser() {
        block6: {
            try {
                this.refDspUser = this.targetHdlr.getDspUser();
                if (this.refDspUser != null) {
                    if (this.dspAdrs != null && !this.dspAdrs.isDisposed()) {
                        this.dspAdrs.dispose();
                    }
                    this.dspAdrs = this.refDspUser.createDspValue(EnumDspValueType.DSP_FAR_POINTER.getInt(), 0);
                    if (this.dspAdrs.sizeOf() == 0) {
                        if (this.dspAdrs != null && !this.dspAdrs.isDisposed()) {
                            this.dspAdrs.dispose();
                        }
                        this.dspAdrs = this.refDspUser.createDspValue(EnumDspValueType.DSP_POINTER.getInt(), 0);
                    }
                    this.setFormatDataType(EnumDspValueType.DSP_INT);
                }
            }
            catch (Exception err) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block6;
                MemoryServerTrace.logException(err.getMessage(), "MemoryRWHandler.initDspUser", err, this.targetInfo);
            }
        }
    }

    @Override
    public void config(MemoryRequestDescriptor request) {
        this.originalRequest = request;
        this.idOfLastConfiguredRequest = request.getRequestIdStr();
        this.setFormatDataType(request.getFormatDataType());
        this.setFormatStyle(request.getFormatStyle());
        this.setFloatingPointQ(request.getFloatingPointQ());
        this.memoryPageNumber = request.getTargetMemoryPageNumber();
        this.setMemoryView(request.getMemoryView());
        this.memoryHierarchyReadEnableFlags = this.owner != null ? this.owner.getMemoryHierarchy().getMemoryHierarchyReadEnableFlags(request.getTargetMemoryLevelEnableFlags(), true, false) : 0;
        this.requestedMemoryAttributeFlags = request.getTargetMemoryAttributeFlags();
        this.isConfigured = true;
    }

    @Override
    public String getSpecialDataString(EnumSpecialDisplayStrings StringType) {
        String result = " ";
        switch (StringType) {
            case DATA_NOT_REQUESTED: {
                result = this.getUnknownDataStringForMemoryItem(".");
                break;
            }
            case NO_DATA_AVAILABLE: {
                result = this.getUnknownDataStringForMemoryItem("-");
                break;
            }
            case ERROR_READING_MEMORY: {
                result = this.getUnknownDataStringForMemoryItem("?");
                break;
            }
            case NON_EMULATABLE_SECURE_MEMORY: {
                result = this.getUnknownDataStringForMemoryItem("*");
                break;
            }
            case MEMORY_DOES_NOT_EXIST: {
                result = this.getUnknownDataStringForMemoryItem("X");
            }
        }
        return result;
    }

    private String getUnknownDataStringForMemoryItem(String nibbleString) {
        String result = "";
        String mauString = "";
        int bytesPerMau = this.targetInfo.getNumBytesPerMauInMemoryPage(this.getMemoryPageNumber());
        while (bytesPerMau-- > 0) {
            mauString = mauString + nibbleString + nibbleString;
        }
        long numMAUs = this.getNumMAUsPerMemoryItem();
        while (numMAUs-- > 0L) {
            result = result + mauString;
        }
        return result;
    }

    public long getNextAdrs(long currentAdrs) {
        long adrsIncr = this.getNumMAUsPerMemoryItem();
        return this.targetInfo.getNextAdrs(currentAdrs, (int)adrsIncr, this.memoryPageNumber);
    }

    public int getActualNumMAUsPerMemoryItem() {
        int sizeOfDataTypeInMAUs = this.getNumMAUsPerMemoryItem();
        int numMAUsPerMemoryItem = this.targetInfo.getAdrsIncrementInMAUs(sizeOfDataTypeInMAUs, this.memoryPageNumber);
        return numMAUsPerMemoryItem;
    }

    @Override
    public int getGtiMemoryHierarchyHitCode(long adrs, IMemoryRegion memoryRegion) {
        int result = 0;
        if (this.requestedMemoryAttributeFlags.equals(EnumSet.of(EnumAttributeTypeFlags.LOCATION_IN_MEMORY_HIERARCHY))) {
            result = this.doDspUserMemoryRead_MemHierarchyLevel(adrs, memoryRegion);
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE) && adrs >= MemoryServerTrace.verboseTraceMinAdrs && adrs <= MemoryServerTrace.verboseTraceMaxAdrs) {
            MemoryServerTrace.logVerbose("Attribute flags = " + this.requestedMemoryAttributeFlags.toString() + "[No LOCATION_IN_MEMORY_HIERARCHY]", "MemoryRWHandler.GetLevelInMemoryHierarchy", this.targetInfo);
        }
        return result;
    }

    @Override
    public boolean setString(long adrs, MemoryRequestDescriptor request, long[] nextAdrs, String writeData, String[] strErrorInfo) {
        boolean result = true;
        strErrorInfo[0] = "";
        long adrsIncr = this.getNumMAUsPerMemoryItem();
        if (!this.isConfigured) {
            this.config(request);
        }
        if (this.memoryPageNumber != request.getTargetMemoryPageNumber()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError("Configuration error: MemoryRWHandler.memoryPageNumber = " + Long.toString(this.memoryPageNumber) + ", request.getTargetMemoryPageNumber() = " + Long.toString(request.getTargetMemoryPageNumber()), "MemoryRWHandler.setString", this.targetInfo);
            }
            this.memoryPageNumber = request.getTargetMemoryPageNumber();
        }
        nextAdrs[0] = this.targetInfo.getNextAdrs(adrs, (int)adrsIncr, this.memoryPageNumber);
        try {
            if (request.getLengthInMAUs() == 0L) {
                request.setLengthInMAUs(adrsIncr);
            }
            CExprRequestDescriptor cExprEvalRequest = (CExprRequestDescriptor)this.getCExprEvalRequestQueue().getRequestDescriptorFactory().createInstance();
            this.getCExprEvalRequestQueue().addRequest(cExprEvalRequest);
            cExprEvalRequest.config(this, adrs, writeData, request.getMemoryView(), this.getFormatStyle(), this.getFormatDataType(), this.getMemoryPageNumber(), this.getFloatingPointQ(), this.getMemoryHierarchyReadEnableFlags(), this, request);
            cExprEvalRequest.requestInfoFromTarget();
        }
        catch (Exception e) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException(e.getMessage(), "MemoryRWHandler.initDspUser", e, this.targetInfo);
            }
            result = false;
        }
        return result;
    }

    @Override
    public boolean setData(long adrs, MemoryRequestDescriptor request, long[] nextAdrs, long writeData, String[] strErrorInfo, EnumGtiMemResult[] memWriteErrorCode) {
        boolean result = true;
        long adrsIncr = this.getNumMAUsPerMemoryItem();
        memWriteErrorCode[0] = EnumGtiMemResult.MEM_ACCESS_OK;
        if (!this.isConfigured) {
            this.config(request);
        }
        if (this.memoryPageNumber != request.getTargetMemoryPageNumber()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError("Configuration error: MemoryRWHandler.memoryPageNumber = " + Long.toString(this.memoryPageNumber) + ", request.getTargetMemoryPageNumber() = " + Long.toString(request.getTargetMemoryPageNumber()), "MemoryRWHandler.setString", this.targetInfo);
            }
            this.memoryPageNumber = request.getTargetMemoryPageNumber();
        }
        nextAdrs[0] = this.targetInfo.getNextAdrs(adrs, (int)adrsIncr, this.memoryPageNumber);
        strErrorInfo[0] = "";
        try {
            if (request.getLengthInMAUs() == 0L) {
                request.setLengthInMAUs(adrsIncr);
            }
            memWriteErrorCode[0] = this.doDspUserRequestMemoryWrite(adrs, writeData, request);
            if (!memWriteErrorCode[0].equals((Object)EnumGtiMemResult.MEM_ACCESS_OK)) {
                result = false;
                strErrorInfo[0] = "Write Error " + (Object)((Object)memWriteErrorCode[0]) + "0x" + Long.toHexString(memWriteErrorCode[0].ordinal()) + " attempting to write (long)0x" + Long.toHexString(writeData) + " to adrs 0x" + Long.toHexString(adrs);
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                    MemoryServerTrace.logWarning(strErrorInfo[0] + "\nRequest: " + request.toString(), "MemoryRWHandler.setData (long)", this.targetInfo);
                }
            }
            if (memWriteErrorCode.equals((Object)EnumGtiMemResult.DEBUG_SERVER_ERROR_ACCESS_NOT_ATTEMPTED)) {
                memWriteErrorCode[0] = EnumGtiMemResult.fromOrdinal(0);
                strErrorInfo[0] = "";
                result = true;
            }
        }
        catch (Exception e) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException(e.getMessage(), "MemoryRWHandler.setData (long)", e, this.targetInfo);
            }
            result = false;
        }
        return result;
    }

    @Override
    public boolean setData(long adrs, MemoryRequestDescriptor request, long[] nextAdrs, CExprRequestDescriptor cExprEvalResult, String[] strErrorInfo, EnumGtiMemResult[] memWriteErrorCode) {
        boolean result = true;
        long adrsIncr = this.getNumMAUsPerMemoryItem();
        memWriteErrorCode[0] = EnumGtiMemResult.MEM_ACCESS_OK;
        if (!this.isConfigured) {
            this.config(request);
        }
        if (this.memoryPageNumber != request.getTargetMemoryPageNumber()) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError("Configuration error: MemoryRWHandler.memoryPageNumber = " + Long.toString(this.memoryPageNumber) + ", request.getTargetMemoryPageNumber() = " + Long.toString(request.getTargetMemoryPageNumber()), "MemoryRWHandler.setString", this.targetInfo);
            }
            this.memoryPageNumber = request.getTargetMemoryPageNumber();
        }
        nextAdrs[0] = this.targetInfo.getNextAdrs(adrs, (int)adrsIncr, this.memoryPageNumber);
        strErrorInfo[0] = "";
        try {
            if (request.getLengthInMAUs() == 0L) {
                request.setLengthInMAUs(adrsIncr);
            }
            memWriteErrorCode[0] = this.doDspUserRequestMemoryWrite(adrs, cExprEvalResult, request);
            if (!memWriteErrorCode[0].equals((Object)EnumGtiMemResult.MEM_ACCESS_OK)) {
                result = false;
                strErrorInfo[0] = "Write Error " + (Object)((Object)memWriteErrorCode[0]) + " [0x" + Long.toHexString(memWriteErrorCode[0].ordinal()) + "] attempting to write (long)0x" + cExprEvalResult.getString() + " to adrs 0x" + Long.toHexString(adrs);
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                    MemoryServerTrace.logWarning(strErrorInfo[0] + "\nRequest: " + request.toString(), "MemoryRWHandler.setData (cExprEvalResult)", this.targetInfo);
                }
            }
            if (memWriteErrorCode.equals((Object)EnumGtiMemResult.DEBUG_SERVER_ERROR_ACCESS_NOT_ATTEMPTED)) {
                memWriteErrorCode[0] = EnumGtiMemResult.fromOrdinal(0);
                strErrorInfo[0] = "";
                result = true;
            }
        }
        catch (Exception e) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException(e.getMessage(), "MemoryRWHandler.initDspUser", e, this.targetInfo);
            }
            result = false;
        }
        return result;
    }

    @Override
    public int getNumMAUsPerMemoryItem() {
        if (this.listOfDspValuesWithDifferentDataTypes.size() <= 0 && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("MemoryServer: MemoryRWHandler configuration error: Attempt to call GetNumMAUsPerMemoryItem without first configuring the MemoryRWHandler.", "MemoryRWHandler.GetNumMAUsPerMemoryItem", this.targetInfo);
        }
        int numMAUs = 1;
        if (this.currentDspValueAndItsType != null) {
            numMAUs = this.currentDspValueAndItsType.getNumMAUsPerMemoryItem();
        }
        return numMAUs;
    }

    public static IDspValue.Format convertToIDspValueFormat(EnumStringFormatStyle format) {
        switch (format) {
            case BINARY: {
                return IDspValue.Format.BINARY;
            }
            case C_STYLE_HEX: {
                return IDspValue.Format.CSTYLEHEX;
            }
            case CHARACTER: {
                return IDspValue.Format.CHARACTER;
            }
            case OCTAL: {
                return IDspValue.Format.OCTAL;
            }
            case PACKED_CHAR: {
                return IDspValue.Format.PACKEDCHAR;
            }
            case REAL: {
                return IDspValue.Format.REAL;
            }
            case UNSIGNED_INTEGER: {
                return IDspValue.Format.UNSIGNEDINT;
            }
            case TI_STYLE_HEX: {
                return IDspValue.Format.TISTYLEHEX;
            }
            case SCIENTIFIC: {
                return IDspValue.Format.SCIENTIFIC;
            }
            case SIGNED_INTEGER: {
                return IDspValue.Format.SIGNEDINT;
            }
        }
        return IDspValue.Format.TISTYLEHEX;
    }

    @Override
    public String getString(long adrs, IMemoryRegion memoryRegion, long[] nextAdrs, EnumGtiMemResult[] memAccessErrorCode) {
        String result;
        block2: {
            result = "";
            memAccessErrorCode[0] = EnumGtiMemResult.MEM_ACCESS_NOT_ATTEMPTED;
            long adrsIncr = this.getNumMAUsPerMemoryItem();
            nextAdrs[0] = this.targetInfo.getNextAdrs(adrs, (int)adrsIncr, this.memoryPageNumber);
            try {
                result = this.doDspUserMemoryRead_String(adrs, memoryRegion, memAccessErrorCode);
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block2;
                MemoryServerTrace.logException(e.getMessage(), "MemoryRWHandler.initDspUser", e, this.targetInfo);
            }
        }
        return result;
    }

    public String getSpecialDataString(EnumGtiMemResult error) {
        EnumSpecialDisplayStrings displayStringEnum = EnumSpecialDisplayStrings.NONE;
        switch (error) {
            case MEM_ACCESS_OK: {
                displayStringEnum = EnumSpecialDisplayStrings.NONE;
                break;
            }
            case DEBUG_SERVER_ERROR_TARGET_ACCESS_FAILED: 
            case MEM_ACCESS_FAILED: {
                displayStringEnum = EnumSpecialDisplayStrings.ERROR_READING_MEMORY;
                break;
            }
            case MEM_ACCESS_SECURITY_VIOLATION: {
                displayStringEnum = EnumSpecialDisplayStrings.NON_EMULATABLE_SECURE_MEMORY;
                break;
            }
            case DEBUG_SERVER_ERROR_ACCESS_NOT_ATTEMPTED: 
            case DEBUG_SERVER_ERROR_NOT_IN_MEMORY_MAP: 
            case MEM_ACCESS_NOT_ATTEMPTED: {
                displayStringEnum = EnumSpecialDisplayStrings.NO_DATA_AVAILABLE;
                break;
            }
            case MEM_NOT_PRESENT: {
                displayStringEnum = EnumSpecialDisplayStrings.MEMORY_DOES_NOT_EXIST;
                break;
            }
            case MEM_ACCESS_INVALID: {
                displayStringEnum = EnumSpecialDisplayStrings.ERROR_READING_MEMORY;
                break;
            }
            case MEM_REGION_DSP_MEMORY_OBJECT_NULL: {
                displayStringEnum = EnumSpecialDisplayStrings.NO_DATA_AVAILABLE;
                break;
            }
            case DEBUG_SERVER_ERROR_INVALID_INDEX_INTO_MEMORY_OBJECT: 
            case UNDEFINED_MEM_ACCESS_ERROR_CODE: {
                displayStringEnum = EnumSpecialDisplayStrings.ERROR_READING_MEMORY;
                break;
            }
            default: {
                displayStringEnum = EnumSpecialDisplayStrings.NONE;
            }
        }
        return this.getSpecialDataString(displayStringEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doDspUserMemoryRead_String(long adrs, IMemoryRegion memoryRegion, EnumGtiMemResult[] memAccessErrorCode) {
        String result = "";
        int errorCode = 0;
        IDspMemory2 mem2Obj = null;
        String errorString = "";
        EnumSpecialDisplayStrings displayCode = EnumSpecialDisplayStrings.NONE;
        try {
            long index = adrs - memoryRegion.getStartAdrs();
            IDspMemory memObj = ((AdrsRegion)memoryRegion).getDspMemoryObj();
            mem2Obj = memObj.getIDspMemory2();
            errorCode = mem2Obj.getErrorCode((int)index);
            errorString = mem2Obj.getErrorString((int)index, false);
            memAccessErrorCode[0] = EnumGtiMemResult.fromOrdinal(errorCode, errorString);
            switch (memAccessErrorCode[0]) {
                case MEM_ACCESS_OK: {
                    this.dspAdrs.assignLong((int)adrs);
                    this.currentDspValueAndItsType.typeCast(this.getFormatDataType(), this.getFloatingPointQ());
                    this.dataValueFormatter.setFloatingPointQ(this.getFloatingPointQ());
                    IDspValue[] outparamDspValue = new IDspValue[]{this.currentDspValueAndItsType.getDspValueObj()};
                    int errcode = memObj.getValueByAddr(outparamDspValue[0], this.dspAdrs);
                    if (errcode != 0 && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                        MemoryServerTrace.logWarning("DspMemory.getValueByAddr returned non-zero error code: " + Integer.toString(errcode), "MemoryRWHandler.doDspUserMemoryRead_String", this.targetInfo);
                    }
                    this.dataValueFormatter.storeEvaluationResult((short)0, this.currentDspValueAndItsType.getDspValueObj());
                    result = this.getFormatDataType().equals((Object)EnumDspValueType.DSP_DATA40) && this.getFormatStyle().equals((Object)EnumStringFormatStyle.SIGNED_INTEGER) ? Long.toString(this.dataValueFormatter.getLong()) : this.dataValueFormatter.getString(this.getFormatStyle(), this.getFormatDataType(), this.getFloatingPointQ());
                    this.dataValueFormatter.setDspValue(null);
                    break;
                }
                default: {
                    result = this.getSpecialDataString(memAccessErrorCode[0]);
                }
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE) && adrs >= MemoryServerTrace.verboseTraceMinAdrs && adrs <= MemoryServerTrace.verboseTraceMaxAdrs) {
                MemoryServerTrace.logVerbose("adrs " + Long.toHexString(adrs) + ": read data = " + result + ", errorCode = " + memAccessErrorCode[0].toString(), "MemoryRWHandler.doDspUserMemoryRead_String", this.targetInfo);
            }
        }
        catch (Exception e) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException(e.getMessage(), "MemoryRWHandler.doDspUserMemoryRead_String", e, this.targetInfo);
            }
        }
        finally {
            if (mem2Obj != null && !mem2Obj.isDisposed()) {
                mem2Obj.dispose();
            }
            if (this.dataValueFormatter != null) {
                this.dataValueFormatter.setDspValue(null);
            }
        }
        return result;
    }

    public int getStrings(List<IDspMemory.IMemoryValue> memValues, long adrs, long lengthInMaus, IMemoryRegion memoryRegion) {
        return this.doDspUserMemoryRead_Strings(memValues, adrs, lengthInMaus, memoryRegion);
    }

    protected int doDspUserMemoryRead_Strings(List<IDspMemory.IMemoryValue> memValues, long adrs, long lengthInMaus, IMemoryRegion memoryRegion) {
        int result;
        block2: {
            result = 0;
            try {
                AdrsRegion region = (AdrsRegion)memoryRegion;
                this.currentDspValueAndItsType.typeCast(this.getFormatDataType(), this.getFloatingPointQ());
                long index = adrs - memoryRegion.getStartAdrs();
                result = region.get(memValues, index, lengthInMaus, this.currentDspValueAndItsType.getDspValueObj(), MemoryRWHandler.convertToIDspValueFormat(this.getFormatStyle()));
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block2;
                MemoryServerTrace.logException(e.getMessage(), "MemoryRWHandler.doDspUserMemoryRead_String", e, this.targetInfo);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doDspUserMemoryRead_MemHierarchyLevel(long adrs, IMemoryRegion memoryRegion) {
        int result = 0;
        Object mem2Obj = null;
        try {
            AdrsRegion region = (AdrsRegion)memoryRegion;
            long numMAUsInMemObj = region.getLengthInMAUs();
            long index = adrs - memoryRegion.getStartAdrs();
            if (index >= numMAUsInMemObj) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    String strReqInfo = ", Original Request = ";
                    strReqInfo = this.originalRequest != null ? strReqInfo + this.originalRequest.toString() : strReqInfo + "null";
                    MemoryServerTrace.logError("Bad index into DspMemory Object (" + index + "):" + "doDspUserMemoryRead_MemHierarchyLevel adrs = " + Long.toHexString(adrs) + " beyond end adrs of DspMemoryObj (memoryRegion: " + memoryRegion.toString() + ", NumMAUSinMemObj=0x" + Long.toHexString(numMAUsInMemObj) + strReqInfo, "MemoryRWHandler.doDspUserMemoryRead_MemHierarchyLevel", this.targetInfo);
                }
            } else {
                result = region.getMemoryHitTypeCode(index);
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE) && adrs >= MemoryServerTrace.verboseTraceMinAdrs && adrs <= MemoryServerTrace.verboseTraceMaxAdrs) {
                    MemoryServerTrace.logVerbose("adrs " + Long.toHexString(adrs) + ": get_MemoryHitTypeCode = " + Long.toHexString(result) + ", numMAUsPerItem = " + this.getNumMAUsPerMemoryItem(), "MemoryRWHandler.getLevelInMemoryHierarchy", this.targetInfo);
                }
            }
        }
        catch (Exception e) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException(e.getMessage(), "MemoryRWHandler.doDspUserMemoryRead_MemHierarchyLevel", e, this.targetInfo);
            }
        }
        finally {
            if (mem2Obj != null && !mem2Obj.isDisposed()) {
                mem2Obj.dispose();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EnumGtiMemResult doDspUserRequestMemoryWrite(long adrs, double writeData, MemoryRequestDescriptor request) {
        if (!this.isConfigured) {
            this.config(request);
        }
        EnumGtiMemResult memWriteErrorCode = EnumGtiMemResult.MEM_ACCESS_OK;
        try {
            this.currentDspValueAndItsType.typeCast(this.getFormatDataType(), this.getFloatingPointQ());
            this.currentDspValueAndItsType.getDspValueObj().assignDouble(writeData);
            this.dspAdrs.assignLong((int)adrs);
            memWriteErrorCode = this.requestDspUserMemoryWrite(request, adrs, this.currentDspValueAndItsType.getNumMAUsPerMemoryItem());
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
                MemoryServerTrace.logTransaction("After call to doMemoryWrite for adrs " + Long.toHexString(adrs) + ": double writeData = " + writeData + ", memWriteErrorCode = " + memWriteErrorCode.toString(), "MemoryRWHandler.doDspUserRequestMemoryWrite", this.targetInfo);
            }
        }
        catch (Exception e) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException(e.getMessage(), "MemoryRWHandler.doDspUserRequestMemoryWrite", e, this.targetInfo);
            }
        }
        return memWriteErrorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EnumGtiMemResult doDspUserRequestMemoryWrite(long adrs, long writeData, MemoryRequestDescriptor request) {
        if (!this.isConfigured) {
            this.config(request);
        }
        Object dspValueQ = null;
        EnumGtiMemResult memWriteErrorCode = EnumGtiMemResult.MEM_ACCESS_OK;
        long modifiedWriteData = writeData;
        try {
            this.dspAdrs.assignLong((int)adrs);
            this.currentDspValueAndItsType.typeCast(this.getFormatDataType(), this.getFloatingPointQ());
            this.currentDspValueAndItsType.getDspValueObj().assignLong((int)modifiedWriteData);
            if (request.getFloatingPointQ() != 0) {
                this.currentDspValueAndItsType.getDspValueObj().assignLong((int)(Math.pow(2.0, request.getFloatingPointQ()) * (double)writeData));
            }
            memWriteErrorCode = this.requestDspUserMemoryWrite(request, adrs, this.currentDspValueAndItsType.getNumMAUsPerMemoryItem());
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
                MemoryServerTrace.logTransaction("After call to doMemoryWrite for adrs " + Long.toHexString(adrs) + ": long writeData = " + writeData + ", memWriteErrorCode = " + memWriteErrorCode.toString(), "MemoryRWHandler.DoDspUserRequestMemoryWrite", this.targetInfo);
            }
        }
        catch (Exception e) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException(e.getMessage(), "MemoryRWHandler.doDspUserRequestMemoryWrite", e, this.targetInfo);
            }
        }
        finally {
            if (dspValueQ != null && !dspValueQ.isDisposed()) {
                dspValueQ.dispose();
            }
        }
        return memWriteErrorCode;
    }

    protected EnumGtiMemResult doDspUserRequestMemoryWrite(long adrs, CExprRequestDescriptor cExprEvalRequest, MemoryRequestDescriptor request) {
        if (!this.isConfigured) {
            this.config(request);
        }
        EnumGtiMemResult memWriteErrorCode = EnumGtiMemResult.MEM_ACCESS_OK;
        this.dspAdrs.assignLong((int)adrs);
        if (this.getFloatingPointQ() == 0) {
            this.currentDspValueAndItsType.typeCast(this.getFormatDataType(), 0);
            this.currentDspValueAndItsType.getDspValueObj().assign(cExprEvalRequest.getDspValue());
        } else {
            this.currentDspValueAndItsType.typeCast(EnumDspValueType.DSP_DOUBLE, 0);
            this.currentDspValueAndItsType.getDspValueObj().assign(cExprEvalRequest.getDspValue());
            String strValue = this.currentDspValueAndItsType.getDspValueObj().toStringReal((short)0);
            String strQValue = this.currentDspValueAndItsType.getDspValueObj().toStringReal(this.getFloatingPointQ());
            double tempValue = this.currentDspValueAndItsType.getDspValueObj().toDouble();
            this.currentDspValueAndItsType.typeCast(this.getFormatDataType(), 0);
            this.currentDspValueAndItsType.getDspValueObj().assignDouble(tempValue *= Math.pow(2.0, this.getFloatingPointQ()));
        }
        memWriteErrorCode = this.requestDspUserMemoryWrite(request, adrs, this.currentDspValueAndItsType.getNumMAUsPerMemoryItem());
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
            MemoryServerTrace.logInfo("After call to doMemoryWrite for adrs " + Long.toHexString(adrs) + ", page=" + Long.toString(request.getTargetMemoryPageNumber()) + " : DspValue writeData = " + cExprEvalRequest.getString() + ", Q = " + this.floatingPointQ + ", DspValue.Type = " + this.currentDspValueAndItsType.getDspValueObj().getType() + ", memWriteErrorCode = " + memWriteErrorCode.toString(), "MemoryRWHandler.DoDspUserRequestMemoryWrite", this.targetInfo);
        }
        return memWriteErrorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnumGtiMemResult requestDspUserMemoryWrite(MemoryRequestDescriptor request, long writeAdrs, long lengthInMAUs) {
        IDspMemory memObj = null;
        IDspMemory2 mem2Obj = null;
        EnumGtiMemResult memWriteErrorCode = EnumGtiMemResult.MEM_ACCESS_OK;
        int flags = -1;
        try {
            int numMAUs = this.currentDspValueAndItsType.getNumMAUsPerMemoryItem();
            memObj = this.refDspUser.createDspMemory(this.dspAdrs, numMAUs, request.getTargetMemoryPageNumber());
            memObj.acquire();
            mem2Obj = memObj.getIDspMemory2();
            if (this.mmuHdlr != null && this.mmuHdlr.useDriverMmuBypassAPIs()) {
                flags = this.targetHdlr.getMemLevelInfoHdlr().calculateMemAccessIdFlags(this.memoryView, 0);
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Setting MemoryAccessLevel flags = 0x" + Integer.toHexString(flags), "MemoryRWHander.requestDspUserMemoryWrite", this.targetInfo);
            }
            mem2Obj.setMemoryAccessLevel(flags);
            IDspValue refDspValue = this.currentDspValueAndItsType.getDspValueObj();
            memObj.setValueByAddr(refDspValue, this.dspAdrs);
            request.setDspMemoryObj(memObj);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
                MemoryServerTrace.logTransaction("About to call refDspUser.requestMemoryWrite for " + (Object)((Object)this.getMemoryView()), "MemoryRWHandler.requestDspUserMemoryWrite", this.targetInfo);
            }
            this.refDspUser.requestMemoryWrite(memObj, true);
            memWriteErrorCode = EnumGtiMemResult.fromOrdinal(mem2Obj.getErrorCode(0), mem2Obj.getErrorString(0, true));
        }
        catch (Exception e) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException(e.getMessage(), "MemoryRWHandler.requestDspUserMemoryWrite", e, this.targetInfo);
            }
        }
        finally {
            if (mem2Obj != null && !mem2Obj.isDisposed()) {
                mem2Obj.dispose();
            }
            if (memObj != null && !memObj.isDisposed()) {
                memObj.dispose();
            }
        }
        return memWriteErrorCode;
    }

    protected String doDspUserGetCExprEvalErrorInfo(short errorCode) {
        return this.refDspUser.cEvalErrorMessage(errorCode);
    }

    @Override
    public void onMemoryRequestCompleteHandler(MemoryRequestDescriptor memoryRequestDescriptor, long requestStartAdrs, long requestLengthInMAUs) {
        MemoryRequestDescriptor request = memoryRequestDescriptor;
    }

    @Override
    public void onCExpressionEvaluationCompleteHandler(CExprRequestDescriptor cExprRequestDescriptor) {
        block14: {
            EnumGtiMemResult[] memWriteErrorCode = new EnumGtiMemResult[]{EnumGtiMemResult.MEM_ACCESS_OK};
            try {
                CExprRequestDescriptor request = cExprRequestDescriptor;
                if (request == null || request.getClientTagObject() == null || !(request.getClientTagObject() instanceof MemoryRequestDescriptor)) {
                    if (!request.getStrCExpression().equals("GEL_RefreshWindows()") && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logError("OnCExpressionEvaluationCompleteHandler parameter (request) is invalid", "MemoryRWHandler.OnCExpressionEvaluationCompleteHandler", this.owner.getTarget().getInfo());
                    }
                } else {
                    MemoryRequestDescriptor clientRequest = (MemoryRequestDescriptor)request.getClientTagObject();
                    if (!this.isConfigured) {
                        this.config(clientRequest);
                    }
                    if (request.getErrorCode() == 0) {
                        long[] nextAdrs = new long[]{0L};
                        String[] errorInfo = new String[]{""};
                        MemoryRequestDescriptor targetRequest = (MemoryRequestDescriptor)this.getTargetAccessRequestQueue().getRequestDescriptorFactory().createInstance();
                        if (this.getOriginalRequest() != null && this.getOriginalRequest().getRequestQueue() != null && this.getOriginalRequest().getRequestQueue().containsRequest(targetRequest) && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                            MemoryServerTrace.logError("new clientRequest already exists in ClientRequestQueue", "MemoryServerClass.createMemoryRequestDescriptor", this.targetInfo);
                        }
                        if (this.getTargetAccessRequestQueue().containsRequest(targetRequest) && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                            MemoryServerTrace.logError("new clientRequest already exists in TargetAccessRequestQueue", "MemoryServerClass.createMemoryRequestDescriptor", this.targetInfo);
                        }
                        this.getTargetAccessRequestQueue().addRequest(targetRequest);
                        targetRequest.config(this.owner, this.owner, clientRequest);
                        this.setData(targetRequest.getStartAdrs(), targetRequest, nextAdrs, request, errorInfo, memWriteErrorCode);
                    } else if (clientRequest != null) {
                        clientRequest.setErrorCode(request.getErrorCode());
                        clientRequest.setErrorInfoString(request.getErrorInfoString());
                        clientRequest.setRequestStatus(EnumMemoryRequestStates.REQUEST_FAILED);
                        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                            MemoryServerTrace.logInfo("CExpression evaluation failed. Error: " + request.getErrorInfoString() + ", ErrorCode = " + request.getErrorCode() + ".  About to call NotifyClient()", "MemoryRWHandler.OnCExpressionEvaluationCompleteHandler", this.targetInfo);
                        }
                        clientRequest.getRequestQueue().deleteRequest(clientRequest, false);
                        clientRequest.notifyClient();
                        clientRequest.release();
                    } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logError("client Request == null", "MemoryRWHandler.OnCExpressionEvaluationCompleteHandler", this.targetInfo);
                    }
                }
            }
            catch (Exception exc) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block14;
                MemoryServerTrace.logException(exc.getMessage(), "MemoryRWHandler.initDspUser", exc, this.targetInfo);
            }
        }
    }

    @Override
    public void release() {
        this.memoryHierarchyReadEnableFlags = 0;
        this.floatingPointQ = 0;
        this.memoryPageNumber = 0;
        this.idOfLastConfiguredRequest = "Released. Was last " + this.idOfLastConfiguredRequest;
        this.isConfigured = false;
        this.memoryView = EnumMemoryViews.CPU_MEMORY_VIEW;
        this.setFormatStyle(EnumStringFormatStyle.TI_STYLE_HEX);
        if (this.getFactory() != null) {
            this.getFactory().onRelease(this);
        }
    }

    @Override
    public IRecyclingFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(IRecyclingFactory value) {
        this.factory = value;
    }

    @Override
    public String getFactoryObjectId() {
        return this.factoryObjectId;
    }

    @Override
    public void setFactoryObjectId(String value) {
        this.factoryObjectId = value;
    }

    @Override
    public String getFactoryObjectStatus() {
        return this.factoryObjectState.toString();
    }

    @Override
    public void setFactoryObjectState(EnumFactoryObjectStates value) {
        this.factoryObjectState = value;
    }

    @Override
    public void dispose(IRecyclingFactory factory) {
        if (factory == this.getFactory()) {
            this.dispose(true);
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("Attempt to dispose of IFactoryCreatedObject by a caller that was not the factory that created it", "MemoryRWHandler.dispose", this.targetHdlr.info);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    protected synchronized void dispose(boolean disposing) {
        if (!this.disposed && disposing) {
            try {
                if (this.dspAdrs != null && !this.dspAdrs.isDisposed()) {
                    this.dspAdrs.dispose();
                }
                this.dspAdrs = null;
                for (DspValueAndItsType obj : this.listOfDspValuesWithDifferentDataTypes) {
                    if (obj.isDisposed()) continue;
                    obj.dispose();
                }
                this.isConfigured = false;
                this.idOfLastConfiguredRequest = "disposed.  was last " + this.idOfLastConfiguredRequest;
                this.listOfDspValuesWithDifferentDataTypes.clear();
                this.refDspUser = null;
                this.getDataValueFormatter().release();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.disposed = true;
    }

    public class DspValueAndItsType
    implements IDisposable {
        public int ID = 0;
        private IDspValue dspValue;
        private EnumDspValueType dspValueType = EnumDspValueType.DSP_INT;
        private int cachedNumMausPerMemoryItem = -1;
        private IDspValue cachedDspValue = null;
        private short cachedMemoryPageNumber = (short)-1;
        private volatile boolean isDisposed = false;

        public DspValueAndItsType(IDspUser refDspUser, EnumDspValueType dspValueType) {
            this.dspValue = refDspUser != null ? refDspUser.createDspValue(dspValueType.getInt(), 0) : null;
            this.dspValueType = dspValueType;
            this.ID = dspValueAndItsTypeID++;
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                MemoryServerTrace.logLifecycle("Creating DspValueAndItsType: type = " + dspValueType.toString() + " ID = " + Integer.toString(this.ID), "MemoryRWHandler.DspValueAndItsType.constructor", null);
            }
        }

        public IDspValue getDspValueObj() {
            return this.dspValue;
        }

        public EnumDspValueType getDspValueType() {
            return this.dspValueType;
        }

        public void setDspValueType(EnumDspValueType value) {
            this.dspValueType = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void typeCast(EnumDspValueType dspValueType, int floatingPointQ) {
            if (this.dspValueType != dspValueType) {
                IDspValue oldDspValue = this.dspValue;
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                    MemoryServerTrace.logLifecycle("Typecasting DspValueAndItsType: from type = " + this.dspValueType.toString() + "to type " + dspValueType.toString() + ", ID = " + Integer.toString(this.ID), "MemoryRWHandler.DspValueAndItsType.typeCast", null);
                }
                if (this.dspValue != null && !this.dspValue.isDisposed()) {
                    try {
                        this.dspValue = oldDspValue.typeCast(dspValueType.getInt(), floatingPointQ);
                    }
                    finally {
                        if (this.dspValue == null) {
                            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                                MemoryServerTrace.logError("Failed typecasting DspValue(type = " + dspValueType.toString() + ") COM Object", "MemoryRWHandler.DspValueAndItsType.typeCast", null);
                            }
                            this.dspValue = oldDspValue;
                            oldDspValue = null;
                        }
                        if (oldDspValue != null && !oldDspValue.isDisposed()) {
                            oldDspValue.dispose();
                        }
                    }
                }
            }
        }

        public synchronized int getNumMAUsPerMemoryItem() {
            if (this.cachedNumMausPerMemoryItem == -1 && this.cachedDspValue != this.dspValue && this.cachedMemoryPageNumber != MemoryRWHandler.this.getMemoryPageNumber() && !this.isDisposed && this.dspValue != null && !this.dspValue.isDisposed()) {
                this.cachedMemoryPageNumber = MemoryRWHandler.this.getMemoryPageNumber();
                this.cachedNumMausPerMemoryItem = this.dspValue.sizeOf2(this.cachedMemoryPageNumber);
                this.cachedDspValue = this.dspValue;
            }
            return this.cachedNumMausPerMemoryItem;
        }

        @Override
        public boolean isDisposed() {
            return this.isDisposed;
        }

        @Override
        public void dispose() {
            if (!this.isDisposed) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
                    MemoryServerTrace.logLifecycle("Disposing DspValueAndItsType: type = " + this.dspValueType.toString() + " ID = " + Integer.toString(this.ID), "MemoryRWHandler.DspValueAndItsType.dispose", null);
                }
                if (this.dspValue != null && !this.dspValue.isDisposed()) {
                    this.dspValue.dispose();
                }
                this.dspValue = null;
                this.isDisposed = true;
            }
        }
    }
}

