/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.MemoryServer;
import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMmuDomainAccessPermission;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.ITargetPropertyEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.TargetPropertyEventArgs;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestClient;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMmuHandler;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetHandler;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.CExprRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorQueue;
import com.ti.ccstudio.debug.memoryserver.target.RegisterDecoder;
import com.ti.ccstudio.debug.memoryserver.target.RegisterHandler;
import com.ti.ccstudio.debug.memoryserver.target.RegisterList;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import com.ti.ccstudio.debug.memoryserver.xml.DeviceXMLReader;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNavigator;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNodeIterator;
import com.ti.ccstudio.debug.memoryserver.xml.XmlDeviceInfoHandler;
import com.ti.ccstudio.debug.memoryserver.xml.XmlElement;
import com.ti.ccstudio.debug.memoryserver.xml.XmlHelper;
import com.ti.debug.engine.IDspUser;
import java.util.ArrayList;
import java.util.EventObject;

public class MmuHandler
implements IMemoryRequestClient,
IMmuHandler,
ITargetPropertyEventHandler,
IDisposable {
    private MemoryServer memoryServer = null;
    private RegisterList listOfRegHandlers = null;
    private TargetHandler target = null;
    private short memoryPageNumber = 0;
    private boolean canBeDisabled = true;
    private boolean useDriverMMUAPIs = true;
    private boolean useDriverMMUBypassAPIs = true;
    private boolean isMmuEnabled = false;
    private RegisterHandler regHdlrMmuEnable = null;
    private RegisterDecoder regDecoderMmuEnable = null;
    private int numTTBRregs = 1;
    private ArrayList<UInt63> listOfTTBRregs = null;
    private int numDomains = 16;
    private ArrayList<EnumMmuDomainAccessPermission> listOfDomains = null;
    private long processId = 0L;
    private volatile boolean isDisposed = false;

    public MmuHandler(MemoryServer memoryServer, RegisterList listOfRegHandlers, RequestDescriptorQueue cExprEvalRequestQueueObj) {
        this.memoryServer = memoryServer;
        this.target = memoryServer.targetHdlr;
        this.target.eventHandler.addEventListener(this);
        this.isMmuEnabled = false;
        this.listOfDomains = new ArrayList();
        this.setNumDomains((short)this.numDomains);
        this.listOfTTBRregs = new ArrayList();
        this.init(listOfRegHandlers);
    }

    public void initOld(RegisterList listOfRegHandlers) {
        block9: {
            this.listOfRegHandlers = listOfRegHandlers;
            if (this.target.getInfo().getXmlDeviceInfoHandler().isVirtualMemorySupported()) {
                try {
                    if (this.target.getInfo().getXmlDeviceInfoHandler().getXpathNav() != null) {
                        XmlDeviceInfoHandler xmlHdlr = this.target.getInfo().getXmlDeviceInfoHandler();
                        MyXPathNavigator xPathNav = xmlHdlr.getXpathNav();
                        XmlHelper xmlHelper = new XmlHelper();
                        MyXPathNodeIterator nodeIterator = xPathNav.select(xmlHdlr.getPathToActiveDeviceCore() + "/MemoryManagementUnit");
                        XmlElement memoryMgtNode = nodeIterator.moveToFirst();
                        this.useDriverMMUAPIs = xmlHelper.getBoolean(memoryMgtNode, "UseDriverMMUAPIs", false, 0);
                        this.useDriverMMUBypassAPIs = xmlHelper.getBoolean(memoryMgtNode, "UseDriverMMUBypassAPIs", true, 0);
                        this.canBeDisabled = xmlHelper.getBoolean(memoryMgtNode, "Control/CanBeDisabled", this.canBeDisabled, 0);
                        if (this.canBeDisabled) {
                            String mmuEnableRegName = xmlHelper.getString(memoryMgtNode, "Control/ConfigReg", "", 0);
                            String mmuEnableDecoderName = xmlHelper.getString(memoryMgtNode, "Control/DecoderName", "", 0);
                            if (mmuEnableRegName.length() > 0 && mmuEnableDecoderName.length() > 0) {
                                this.regHdlrMmuEnable = listOfRegHandlers.getRegisterHandler(mmuEnableRegName);
                                if (this.regHdlrMmuEnable != null) {
                                    this.regDecoderMmuEnable = this.regHdlrMmuEnable.getDecoder(mmuEnableDecoderName);
                                }
                            }
                            if (this.regHdlrMmuEnable == null) {
                                this.isMmuEnabled = true;
                                this.canBeDisabled = false;
                            }
                        } else {
                            this.isMmuEnabled = true;
                        }
                    }
                    boolean mmuEnableResult = false;
                    this.requestMmuPropertiesFromDebugServer();
                }
                catch (Exception ex) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block9;
                    MemoryServerTrace.logException("Error attempting to read MMU information from Memory Server XML file " + this.target.info.getXmlDeviceDescriptionFileName(), "MMUPageTableViewerForm.CcsMmuHandler xml constructor", ex, this.target.info);
                }
            }
        }
    }

    public void init(RegisterList listOfRegHandlers) {
        block13: {
            this.listOfRegHandlers = listOfRegHandlers;
            if (this.target.getInfo().getXmlDeviceInfoHandler().isVirtualMemorySupported()) {
                try {
                    if (this.target.getInfo().getXmlDeviceInfoHandler().getXpathNav() != null) {
                        XmlDeviceInfoHandler xmlHdlr = this.target.getInfo().getXmlDeviceInfoHandler();
                        DeviceXMLReader.CoreInfoItem coreInfoItem = DeviceXMLReader.getInstance(this.target.getMemoryServerXmlPath()).getCoreInfoItem(xmlHdlr, xmlHdlr.getPathToActiveDeviceCore());
                        if (coreInfoItem != null && coreInfoItem.memoryManagementUnitExist) {
                            this.useDriverMMUAPIs = coreInfoItem.useDriverMMUAPIs;
                            this.useDriverMMUBypassAPIs = coreInfoItem.useDriverMMUBypassAPIs;
                            if (coreInfoItem.canBeDisabled.length() > 0) {
                                boolean bl = this.canBeDisabled = coreInfoItem.canBeDisabled.compareToIgnoreCase("true") == 0;
                            }
                            if (this.canBeDisabled) {
                                String mmuEnableRegName = coreInfoItem.mmuEnableRegName;
                                String mmuEnableDecoderName = coreInfoItem.mmuEnableDecoderName;
                                if (mmuEnableRegName.length() > 0 && mmuEnableDecoderName.length() > 0) {
                                    this.regHdlrMmuEnable = listOfRegHandlers.getRegisterHandler(mmuEnableRegName);
                                    if (this.regHdlrMmuEnable != null) {
                                        this.regDecoderMmuEnable = this.regHdlrMmuEnable.getDecoder(mmuEnableDecoderName);
                                    }
                                }
                                if (this.regHdlrMmuEnable == null) {
                                    this.isMmuEnabled = true;
                                    this.canBeDisabled = false;
                                }
                            }
                        } else {
                            this.isMmuEnabled = true;
                        }
                    } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logError("Error attempting to read MMU information from Memory Server cache for XML file " + this.target.info.getXmlDeviceDescriptionFileName(), "MMUPageTableViewerForm.CcsMmuHandler xml constructor", this.target.info);
                    }
                    this.requestMmuPropertiesFromDebugServer();
                }
                catch (Exception ex) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block13;
                    MemoryServerTrace.logException("Error attempting to read MMU information from Memory Server XML file " + this.target.info.getXmlDeviceDescriptionFileName(), "MMUPageTableViewerForm.CcsMmuHandler xml constructor", ex, this.target.info);
                }
            }
        }
    }

    @Override
    public boolean isMmuSupported() {
        boolean result = this.isDriverMmuAware();
        if (!result && this.regHdlrMmuEnable != null && this.regHdlrMmuEnable.isRegisterSupported()) {
            result = true;
        }
        return result;
    }

    public boolean isMmuBypassSupported() {
        boolean result = false;
        if (this.memoryServer != null) {
            result = this.memoryServer.isMmuBypassSupported();
        }
        return result;
    }

    public MemoryServer getMemoryServer() {
        return this.memoryServer;
    }

    public RegisterList getListOfRegHandlers() {
        return this.listOfRegHandlers;
    }

    public ITargetHandler getTarget() {
        return this.target;
    }

    public short getMemoryPageNumber() {
        return this.memoryPageNumber;
    }

    @Override
    public boolean canBeDisabled() {
        return this.canBeDisabled;
    }

    public void setCanBeDisabled(boolean value) {
        this.canBeDisabled = value;
    }

    public boolean useDriverMMUAPIs() {
        return this.useDriverMMUAPIs;
    }

    @Override
    public boolean useDriverMmuBypassAPIs() {
        return this.useDriverMMUBypassAPIs;
    }

    @Override
    public boolean isMmuEnabled() {
        boolean result = this.isMmuEnabled;
        if (this.isDriverMmuAware()) {
            result = this.isMmuEnabled;
        } else if (this.regDecoderMmuEnable != null && this.regDecoderMmuEnable.getOwner().isRegisterSupported()) {
            result = this.regDecoderMmuEnable.decode_Boolean();
        }
        return result;
    }

    @Override
    public void setIsMmuEnabled(boolean value) {
        this.isMmuEnabled = value;
        if (this.isDriverMmuAware()) {
            long longValue = 0L;
            if (this.isMmuEnabled) {
                longValue = 1L;
            }
            this.target.getDspUser().requestPropertySet(IDspUser.TargetProperties.MMU_STATE, 0L, longValue);
        } else if (this.regDecoderMmuEnable != null && this.regDecoderMmuEnable.getOwner().isRegisterSupported()) {
            this.regDecoderMmuEnable.encode_Boolean(value, true);
        }
    }

    public RegisterHandler getRegHdlrMmuEnable() {
        return this.regHdlrMmuEnable;
    }

    public RegisterDecoder getRegDecoderMmuEnable() {
        return this.regDecoderMmuEnable;
    }

    @Override
    public boolean isDriverMmuAware() {
        boolean result = false;
        if (this.useDriverMMUAPIs && !(result = this.target.getDspUser().capableTargetProperties(IDspUser.TargetProperties.MMU_STATE))) {
            this.useDriverMMUAPIs = false;
        }
        return result;
    }

    @Override
    public void requestMmuPropertiesFromDebugServer() {
        if (!this.target.isDisconnected() && this.isDriverMmuAware()) {
            this.target.getDspUser().requestPropertyGet(IDspUser.TargetProperties.MMU_STATE, 0L);
            this.target.getDspUser().requestPropertyGet(IDspUser.TargetProperties.NUM_MMU_DOMAINS, 0L);
            this.target.getDspUser().requestPropertyGet(IDspUser.TargetProperties.NUM_MMU_TTBR_REGS, 0L);
        }
    }

    @Override
    public void updateMmuStatus() {
        if (!this.target.isDisconnected() && this.isDriverMmuAware()) {
            this.target.getDspUser().requestPropertyGet(IDspUser.TargetProperties.MMU_STATE, 0L);
            for (int ttbrIndex = 0; ttbrIndex < this.getNumTTBRregs(); ++ttbrIndex) {
                this.target.getDspUser().requestPropertyGet(IDspUser.TargetProperties.TTBR_REG, (long)ttbrIndex);
            }
            for (int domainIndex = 0; domainIndex < this.getNumDomains(); ++domainIndex) {
                this.target.getDspUser().requestPropertyGet(IDspUser.TargetProperties.DOMAIN_ACCESS, (long)domainIndex);
            }
            this.target.getDspUser().requestPropertyGet(IDspUser.TargetProperties.CURRENT_PROCID, 0L);
        }
    }

    @Override
    public int getNumTTBRregs() {
        return this.numTTBRregs;
    }

    private void setNumTTBRregs(short value) {
        this.numTTBRregs = value;
        while (this.listOfTTBRregs.size() > this.numTTBRregs) {
            this.listOfTTBRregs.remove(this.listOfTTBRregs.size() - 1);
        }
        while (this.listOfTTBRregs.size() < this.numTTBRregs) {
            this.listOfTTBRregs.add(new UInt63());
        }
    }

    @Override
    public long getTTBRreg(int index) {
        UInt63 u32Result = null;
        long retval = 0L;
        if (index < this.listOfTTBRregs.size()) {
            u32Result = this.listOfTTBRregs.get(index);
        }
        if (u32Result != null) {
            retval = u32Result.getValue();
        }
        return retval;
    }

    @Override
    public int getNumDomains() {
        return this.numDomains;
    }

    private void setNumDomains(short value) {
        this.numDomains = value;
        while (this.listOfDomains.size() > this.numDomains) {
            this.listOfDomains.remove(this.listOfDomains.size() - 1);
        }
        while (this.listOfDomains.size() < this.numDomains) {
            this.listOfDomains.add(EnumMmuDomainAccessPermission.NO_ACCESS);
        }
    }

    @Override
    public EnumMmuDomainAccessPermission getDomainAP(int index) {
        EnumMmuDomainAccessPermission result = EnumMmuDomainAccessPermission.NO_ACCESS;
        if (index < this.listOfDomains.size()) {
            result = this.listOfDomains.get(index);
        }
        return result;
    }

    @Override
    public long getProcessId() {
        return this.processId;
    }

    @Override
    public void setProcessId(long value) {
        this.target.getDspUser().requestPropertySet(IDspUser.TargetProperties.CURRENT_PROCID, 0L, value);
    }

    @Override
    public void restoreMmuEnableContext() {
        if (this.getRegDecoderMmuEnable() != null) {
            this.getRegHdlrMmuEnable().setUseBlockingWrites(true);
            this.getRegDecoderMmuEnable().encode(this.getRegHdlrMmuEnable().getContextSaveValue(), false);
            this.getRegHdlrMmuEnable().setUseBlockingWrites(false);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("MMU context restored: Enabled = " + Boolean.toString(this.isMmuEnabled()), "MmuHandler.restoreMmuEnableContext", null);
            }
        }
    }

    @Override
    public boolean getMmuEnableContext() {
        boolean result;
        block7: {
            result = false;
            try {
                if (this.getRegHdlrMmuEnable() != null) {
                    this.getRegHdlrMmuEnable().setUseBlockingReads(true);
                    this.getRegHdlrMmuEnable().setContextValid(false);
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo("Requesting MMU Enable Context Read", "MmuHandler.getMmuEnableContext", null);
                    }
                    result = this.getRegHdlrMmuEnable().requestRegisterRead();
                    this.getRegHdlrMmuEnable().setUseBlockingReads(false);
                } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                    MemoryServerTrace.logWarning("MMU Enable register handler is null - not properly configured.", "MmuHandler.getMMUEnableContext", this.target.info);
                }
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                    MemoryServerTrace.logVerbose("RegHdlrMmuEnable [0x" + Long.toHexString(this.getRegHdlrMmuEnable().getAdrs()) + "] = 0x" + Long.toHexString(this.getRegHdlrMmuEnable().getContextSaveValue()), "MmuHandler.getMmuEnableContext", this.target.info);
                }
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block7;
                MemoryServerTrace.logException("RegHdlrMmuEnable [0x" + Long.toHexString(this.getRegHdlrMmuEnable().getAdrs()) + "] = 0x" + Long.toHexString(this.getRegHdlrMmuEnable().getContextSaveValue()), "MmuHandler.getMmuEnableContext", ex, this.target.info);
            }
        }
        return result;
    }

    @Override
    public void onCExpressionEvaluationCompleteHandler(CExprRequestDescriptor cExprEvalRequestDescriptor) {
    }

    @Override
    public void onMemoryRequestCompleteHandler(MemoryRequestDescriptor memoryRequestDescriptor, long requestStartAdrs, long requestLengthInMAUs) {
    }

    @Override
    public void handleOnTargetPropertyEvent(EventObject sender, TargetPropertyEventArgs args) {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo(args.toString(), "MmuHandler.handleOnTargetPropertyEvent", this.target.info);
        }
        switch (args.getType()) {
            case MMU_STATE: {
                this.isMmuEnabled = args.getValue() != 0L;
                break;
            }
            case NUM_MMU_TTBR_REGS: {
                int oldNumTTBRregs = this.numTTBRregs;
                this.numTTBRregs = (int)args.getValue();
                if (this.numTTBRregs == oldNumTTBRregs) break;
                this.updateMmuStatus();
                break;
            }
            case TTBR_REG: {
                int ttbrIndex = (int)args.getParameter();
                if (ttbrIndex >= this.listOfTTBRregs.size()) break;
                this.listOfTTBRregs.get(ttbrIndex).setValue(args.getValue());
                break;
            }
            case CURRENT_PROCID: {
                this.processId = args.getValue();
                break;
            }
            case NUM_MMU_DOMAINS: {
                if (args.getValue() <= 0L) {
                    this.useDriverMMUAPIs = false;
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) break;
                    MemoryServerTrace.logWarning("Driver returned NUM_MMU_DOMAINS <= 0 (bad value) - setting useDriverMMUAPIs = false.", "MmuHandler.handleOnTargetPropertyEvent", this.target.info);
                    break;
                }
                if ((long)this.numDomains == args.getValue()) break;
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                    MemoryServerTrace.logInfo("Driver returned NUM_MMU_DOMAINS = " + Long.toString(args.getValue()) + ".", "MmuHandler.handleOnTargetPropertyEvent", this.target.info);
                }
                this.setNumDomains((short)args.getValue());
                this.updateMmuStatus();
                break;
            }
            case DOMAIN_ACCESS: {
                int domainIndex = (int)args.getParameter();
                long AP = args.getValue();
                if (domainIndex > this.listOfDomains.size()) {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo("Driver DOMAIN_ACCESS for domainIndex = " + Long.toString(domainIndex) + ", which is greater than NUM_MMU_DOMAINS = " + Long.toString(this.listOfDomains.size()) + ". Expanding listOfDomains.size() to accommodate.", "MmuHandler.handleOnTargetPropertyEvent", this.target.info);
                    }
                    this.setNumDomains((short)domainIndex);
                }
                if (AP == 2L) {
                    AP = 3L;
                } else if (AP > 2L) {
                    AP = 2L;
                }
                if (domainIndex >= this.listOfDomains.size()) break;
                if (AP >= (long)EnumMmuDomainAccessPermission.values().length || AP < 0L) {
                    AP = EnumMmuDomainAccessPermission.UNKNOWN.getInt();
                }
                this.listOfDomains.set(domainIndex, EnumMmuDomainAccessPermission.fromInt((int)AP));
                break;
            }
            case ALL_DOMAIN_ACCESS: {
                break;
            }
            case COHERENCY_CONTROL: {
                break;
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public synchronized void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            if (this.target != null) {
                this.target.eventHandler.removeEventListener(this);
            }
        }
    }
}

