/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumFactoryObjectStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IFactoryCreatedObject;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRecyclingFactory;
import com.ti.ccstudio.debug.memoryserver.public_events.IClientRefreshRequiredEventHandler;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.ITransaction;

public class RefreshToken
implements IFactoryCreatedObject {
    private ITransaction dspUserTransactionObj = null;
    private TargetHandler targetHdlr = null;
    private IClientRefreshRequiredEventHandler clientInstance = null;
    private String clientName = "";
    private IRecyclingFactory factory = null;
    private String factoryObjectId = "";
    private EnumFactoryObjectStates factoryObjectState = EnumFactoryObjectStates.CREATED;
    private volatile boolean isDisposed = false;

    public RefreshToken(TargetHandler targetHdlr) {
        this.targetHdlr = targetHdlr;
    }

    public void beginRefresh(IClientRefreshRequiredEventHandler clientInstance, String clientName) {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            this.clientName = clientName;
            MemoryServerTrace.logInfo("Begin refresh for " + clientName, "RefreshToken.beginRefresh", this.targetHdlr.info);
        }
        this.clientInstance = clientInstance;
        IDspUser dspUser = this.targetHdlr.getDspUser();
        this.dspUserTransactionObj = dspUser.beginRefresh();
    }

    public void endRefresh() {
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("End refresh for " + this.clientName, "RefreshToken.endRefresh", this.targetHdlr.info);
        }
        if (this.dspUserTransactionObj != null && !this.dspUserTransactionObj.isDisposed()) {
            this.dspUserTransactionObj.dispose();
        }
        this.dspUserTransactionObj = null;
        this.clientInstance = null;
    }

    @Override
    public void release() {
        if (!this.isDisposed && this.getFactory() != null) {
            this.getFactory().onRelease(this);
        }
    }

    @Override
    public IRecyclingFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(IRecyclingFactory value) {
        this.factory = value;
    }

    @Override
    public String getFactoryObjectId() {
        return this.factoryObjectId;
    }

    @Override
    public void setFactoryObjectId(String value) {
        this.factoryObjectId = value;
    }

    @Override
    public String getFactoryObjectStatus() {
        return this.factoryObjectState.toString();
    }

    @Override
    public void setFactoryObjectState(EnumFactoryObjectStates value) {
        this.factoryObjectState = value;
    }

    @Override
    public void dispose(IRecyclingFactory factory) {
        if (factory == this.getFactory()) {
            this.dispose();
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("Attempt to dispose of IFactoryCreatedObject by a caller that was not the factory that created it", "RefreshToken.dispose", this.targetHdlr.info);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    protected synchronized void dispose() {
        if (!this.isDisposed) {
            if (this.dspUserTransactionObj != null && !this.dspUserTransactionObj.isDisposed()) {
                this.dspUserTransactionObj.dispose();
            }
            this.dspUserTransactionObj = null;
            this.release();
            this.isDisposed = true;
        }
    }
}

