/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.target.RegisterHandler;
import com.ti.ccstudio.debug.memoryserver.xml.DeviceXMLReader;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNavigator;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNodeIterator;
import com.ti.ccstudio.debug.memoryserver.xml.XmlElement;
import com.ti.ccstudio.debug.memoryserver.xml.XmlHelper;
import java.util.ArrayList;

public class RegisterDecoder {
    private RegisterHandler owner;
    private String name;
    public long xorWithRegValue;
    public long mask;
    public int shift;
    public boolean isAValueField;
    public double multiplier;
    public long addToProduct;
    public boolean isALookupTable;
    public boolean isAStringTable;
    public boolean isADecoderTable;
    private boolean isTrueIfResultIsZero;
    private ArrayList<Long> lookupTable;
    private ArrayList<String> stringTable;
    private ArrayList<String> decoderNameTable;
    private ArrayList<RegisterDecoder> decoderTable;

    public RegisterDecoder(RegisterHandler owner, String strXPathQueryRoot, MyXPathNavigator xmlDocNav, XmlElement nodeAtDecoder) {
        block16: {
            this.xorWithRegValue = 0L;
            this.mask = -1L;
            this.shift = 0;
            this.isAValueField = true;
            this.multiplier = 1.0;
            this.addToProduct = 0L;
            this.isALookupTable = false;
            this.isAStringTable = false;
            this.isADecoderTable = false;
            this.isTrueIfResultIsZero = false;
            this.lookupTable = null;
            this.stringTable = null;
            this.decoderNameTable = null;
            this.decoderTable = null;
            this.owner = owner;
            try {
                XmlElement arrayItem;
                int numDecoders;
                int numStrings;
                XmlHelper xmlHelper = new XmlHelper();
                this.name = xmlHelper.getString(nodeAtDecoder, "DecoderName", "none", 0);
                this.xorWithRegValue = xmlHelper.getLong(nodeAtDecoder, "XorWithRegValue", 0L, 0);
                this.mask = xmlHelper.getLong(nodeAtDecoder, "BitfieldMask", -1L, 0);
                this.shift = xmlHelper.getInt(nodeAtDecoder, "BitfieldShift", 0, 0);
                this.multiplier = xmlHelper.getDouble(nodeAtDecoder, "Multiplier", 1.0, 0);
                this.addToProduct = xmlHelper.getLong(nodeAtDecoder, "AddToProduct", 0L, 0);
                this.isTrueIfResultIsZero = xmlHelper.getBoolean(nodeAtDecoder, "IsTrueIfResultIsZero", false, 0);
                this.isAValueField = true;
                int numValues = xmlHelper.getInt(nodeAtDecoder, "LookupTable/NumIndexValues", 0, 0);
                if (numValues > 0) {
                    this.isAValueField = false;
                    this.isALookupTable = true;
                }
                if ((numStrings = xmlHelper.getInt(nodeAtDecoder, "StringTable/NumStrings", 0, 0)) > 0) {
                    this.isAStringTable = true;
                }
                if ((numDecoders = xmlHelper.getInt(nodeAtDecoder, "DecoderTable/NumDecoders", 0, 0)) > 0) {
                    this.isADecoderTable = true;
                }
                if (this.isALookupTable) {
                    long lookupValue = 0L;
                    this.lookupTable = new ArrayList();
                    MyXPathNodeIterator lookupTableArrayIterator = xmlHelper.navTo(nodeAtDecoder, "LookupTable/Array");
                    if (lookupTableArrayIterator != null) {
                        arrayItem = null;
                        while (lookupTableArrayIterator.hasNext()) {
                            arrayItem = lookupTableArrayIterator.next();
                            lookupValue = arrayItem.getValueAsLong();
                            this.lookupTable.add(lookupValue);
                        }
                    }
                }
                if (this.isAStringTable) {
                    this.stringTable = new ArrayList();
                    String stringValue = "";
                    MyXPathNodeIterator stringTableArrayIterator = xmlHelper.navTo(nodeAtDecoder, "StringTable/Array");
                    if (stringTableArrayIterator != null) {
                        XmlElement arrayItem2 = null;
                        while (stringTableArrayIterator.hasNext()) {
                            arrayItem2 = stringTableArrayIterator.next();
                            stringValue = arrayItem2.getValue();
                            this.stringTable.add(stringValue);
                        }
                    }
                }
                if (this.isADecoderTable) {
                    String decoderName = "";
                    RegisterDecoder nestedDecoder = null;
                    this.decoderNameTable = new ArrayList();
                    this.decoderTable = new ArrayList();
                    MyXPathNodeIterator decoderArrayIterator = xmlHelper.navTo(nodeAtDecoder, "DecoderTable/Array");
                    if (decoderArrayIterator != null) {
                        arrayItem = null;
                        while (decoderArrayIterator.hasNext()) {
                            arrayItem = decoderArrayIterator.next();
                            decoderName = arrayItem.getValue();
                            this.decoderNameTable.add(decoderName);
                        }
                    }
                    MyXPathNodeIterator decoderIterator = nodeAtDecoder.getIteratorForSiblingNodes(false);
                    for (String name : this.decoderNameTable) {
                        nestedDecoder = this.getDecoder(strXPathQueryRoot, decoderIterator, xmlDocNav, name);
                        if (nestedDecoder == null) {
                            nestedDecoder = this.getDecoder(strXPathQueryRoot, decoderIterator, xmlDocNav, name);
                            String xmlFilePath = xmlDocNav.xmlFileName;
                            String xmlFileName = xmlFilePath.substring(xmlFilePath.lastIndexOf("/") + 1, xmlFilePath.length());
                            if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                            MemoryServerTrace.logError("Could not find decoder " + name + " listed in DecoderTable of " + this.getName(), "RegisterDecoder xml constructor[" + xmlFileName + "]", null);
                            continue;
                        }
                        this.decoderTable.add(nestedDecoder);
                    }
                }
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block16;
                MemoryServerTrace.logException("Exception parsing xml file path " + strXPathQueryRoot, "RegisterDecoder xml constructor", ex, null);
            }
        }
    }

    public RegisterDecoder(RegisterHandler owner, String strXPathQueryRoot, MyXPathNavigator xmlDocNav, DeviceXMLReader.DecoderInfoItem decoderInfo, DeviceXMLReader.DecoderInfo decoderList) {
        block13: {
            this.xorWithRegValue = 0L;
            this.mask = -1L;
            this.shift = 0;
            this.isAValueField = true;
            this.multiplier = 1.0;
            this.addToProduct = 0L;
            this.isALookupTable = false;
            this.isAStringTable = false;
            this.isADecoderTable = false;
            this.isTrueIfResultIsZero = false;
            this.lookupTable = null;
            this.stringTable = null;
            this.decoderNameTable = null;
            this.decoderTable = null;
            this.owner = owner;
            try {
                int i;
                this.name = decoderInfo.name;
                this.xorWithRegValue = decoderInfo.xorWithRegValue;
                this.mask = decoderInfo.mask;
                this.shift = decoderInfo.shift;
                this.multiplier = decoderInfo.multiplier;
                this.addToProduct = decoderInfo.addToProduct;
                this.isTrueIfResultIsZero = decoderInfo.isTrueIfResultIsZero;
                this.isAValueField = true;
                this.isAValueField = decoderInfo.isAValueField;
                this.isALookupTable = decoderInfo.isALookupTable;
                this.isAStringTable = decoderInfo.isAStringTable;
                this.isADecoderTable = decoderInfo.isADecoderTable;
                if (this.isALookupTable) {
                    this.lookupTable = new ArrayList();
                    if (decoderInfo.lookupTable != null) {
                        for (i = 0; i < decoderInfo.lookupTable.size(); ++i) {
                            this.lookupTable.add(decoderInfo.lookupTable.get(i));
                        }
                    }
                }
                if (this.isAStringTable) {
                    this.stringTable = new ArrayList();
                    if (decoderInfo.stringTable != null) {
                        for (i = 0; i < decoderInfo.stringTable.size(); ++i) {
                            this.stringTable.add(decoderInfo.stringTable.get(i));
                        }
                    }
                }
                if (this.isADecoderTable) {
                    RegisterDecoder nestedDecoder = null;
                    this.decoderNameTable = new ArrayList();
                    this.decoderTable = new ArrayList();
                    if (decoderInfo.decoderNameTable != null) {
                        for (int i2 = 0; i2 < decoderInfo.decoderNameTable.size(); ++i2) {
                            this.decoderNameTable.add(decoderInfo.decoderNameTable.get(i2));
                        }
                    }
                    for (String name : this.decoderNameTable) {
                        nestedDecoder = this.getDecoder(strXPathQueryRoot, decoderList, xmlDocNav, name);
                        if (nestedDecoder == null) {
                            String xmlFilePath = xmlDocNav.xmlFileName;
                            String xmlFileName = xmlFilePath.substring(xmlFilePath.lastIndexOf("/") + 1, xmlFilePath.length());
                            if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                            MemoryServerTrace.logError("Could not find decoder " + name + " listed in DecoderTable of " + this.getName(), "RegisterDecoder xml constructor[" + xmlFileName + "]", null);
                            continue;
                        }
                        this.decoderTable.add(nestedDecoder);
                    }
                }
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block13;
                MemoryServerTrace.logException("Exception parsing xml file path " + strXPathQueryRoot, "RegisterDecoder xml constructor", ex, null);
            }
        }
    }

    public RegisterDecoder(RegisterHandler owner, RegisterDecoder copyFromObj) {
        int i;
        int numIndexValues;
        this.xorWithRegValue = 0L;
        this.mask = -1L;
        this.shift = 0;
        this.isAValueField = true;
        this.multiplier = 1.0;
        this.addToProduct = 0L;
        this.isALookupTable = false;
        this.isAStringTable = false;
        this.isADecoderTable = false;
        this.isTrueIfResultIsZero = false;
        this.lookupTable = null;
        this.stringTable = null;
        this.decoderNameTable = null;
        this.decoderTable = null;
        this.owner = owner;
        this.name = copyFromObj.getName();
        this.addToProduct = copyFromObj.addToProduct;
        this.multiplier = copyFromObj.multiplier;
        this.mask = copyFromObj.mask;
        this.shift = copyFromObj.shift;
        this.xorWithRegValue = copyFromObj.xorWithRegValue;
        this.isAValueField = copyFromObj.isAValueField;
        this.isALookupTable = copyFromObj.isALookupTable;
        this.isAStringTable = copyFromObj.isAStringTable;
        this.isADecoderTable = copyFromObj.isADecoderTable;
        this.isTrueIfResultIsZero = copyFromObj.isTrueIfResultIsZero();
        if (this.isALookupTable) {
            long lookupValue = 0L;
            this.lookupTable = new ArrayList();
            numIndexValues = copyFromObj.lookupTable.size();
            for (i = 0; i < numIndexValues; ++i) {
                lookupValue = copyFromObj.lookupTable.get(i);
                this.lookupTable.add(lookupValue);
            }
        }
        if (this.isAStringTable) {
            String StringValue = "";
            this.stringTable = new ArrayList();
            int numIndexValues2 = copyFromObj.stringTable.size();
            for (int i2 = 0; i2 < numIndexValues2; ++i2) {
                StringValue = copyFromObj.stringTable.get(i2);
                this.stringTable.add(StringValue);
            }
        }
        if (this.isADecoderTable) {
            String decoderName = "";
            RegisterDecoder decoder = null;
            this.decoderNameTable = new ArrayList();
            this.decoderTable = new ArrayList();
            numIndexValues = copyFromObj.decoderNameTable.size();
            for (i = 0; i < numIndexValues; ++i) {
                decoderName = copyFromObj.decoderNameTable.get(i);
                this.decoderNameTable.add(decoderName);
            }
            numIndexValues = copyFromObj.decoderTable.size();
            for (i = 0; i < numIndexValues; ++i) {
                decoder = copyFromObj.decoderTable.get(i);
                this.decoderTable.add(decoder);
            }
        }
    }

    public RegisterHandler getOwner() {
        return this.owner;
    }

    public void setOwner(RegisterHandler value) {
        this.owner = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public boolean isTrueIfResultIsZero() {
        return this.isTrueIfResultIsZero;
    }

    public void setIsTrueIfResultIsZero(boolean value) {
        this.isTrueIfResultIsZero = value;
    }

    public ArrayList<Long> getLookupTable() {
        return this.lookupTable;
    }

    public ArrayList<String> getStringTable() {
        return this.stringTable;
    }

    public ArrayList<String> getDecoderNameTable() {
        return this.decoderNameTable;
    }

    public ArrayList<RegisterDecoder> getDecoderTable() {
        return this.decoderTable;
    }

    private RegisterDecoder getDecoder(String strXPathQueryRoot, MyXPathNodeIterator nodeIterator, MyXPathNavigator xpathNav, String nameOfDecoder) {
        RegisterDecoder decoder = null;
        String decoderName = "";
        XmlElement node = null;
        XmlHelper xmlHelper = new XmlHelper();
        nodeIterator.reset();
        while (decoder == null && nodeIterator.hasNext()) {
            node = nodeIterator.next();
            decoderName = xmlHelper.getString(node, "DecoderName", "", 1);
            if (!decoderName.equalsIgnoreCase(nameOfDecoder)) continue;
            decoder = new RegisterDecoder(null, strXPathQueryRoot, xpathNav, node);
        }
        return decoder;
    }

    private RegisterDecoder getDecoder(String strXPathQueryRoot, DeviceXMLReader.DecoderInfo decoderList, MyXPathNavigator xpathNav, String nameOfDecoder) {
        RegisterDecoder decoder = null;
        String decoderName = "";
        for (int i = 0; decoder == null && i < decoderList.decoderItems.size(); ++i) {
            DeviceXMLReader.DecoderInfoItem decoderInfoItem = decoderList.decoderItems.get(i);
            decoderName = decoderInfoItem.name;
            if (!decoderName.equalsIgnoreCase(nameOfDecoder)) continue;
            decoder = new RegisterDecoder(null, strXPathQueryRoot, xpathNav, decoderInfoItem, decoderList);
        }
        return decoder;
    }

    private void fillDecoderTable() {
        boolean found = false;
        String decoderName_lc = "";
        for (String decoderName : this.decoderNameTable) {
            decoderName_lc = decoderName.toLowerCase();
            for (RegisterDecoder decoderInList : this.owner.getListOfDecoders()) {
                if (!decoderName_lc.equals(decoderInList.getName().toLowerCase())) continue;
                found = true;
                this.decoderTable.add(decoderInList);
                break;
            }
            if (found || !MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
            MemoryServerTrace.logError("Improperly configured DecoderTable for Decoder " + this.getName() + "Could not find " + decoderName + " in register " + this.owner.getName() + "'s list of decoders.", "RegisterDecoder.FillDecoderTable", this.owner.getTargetHdlr().getInfo());
        }
    }

    public long decode(long regValue) {
        int index;
        long result = ((regValue ^ this.xorWithRegValue) & this.mask) >> this.shift;
        if (this.isALookupTable && (index = (int)result) < this.lookupTable.size()) {
            result = this.lookupTable.get(index);
        }
        result = (long)(this.multiplier * (double)result);
        result += this.addToProduct;
        if (this.isADecoderTable) {
            if (this.decoderTable.size() == 0) {
                this.fillDecoderTable();
            }
            int decoderIndex = (int)result;
            RegisterDecoder nestedDecoder = null;
            if (decoderIndex < this.decoderTable.size()) {
                nestedDecoder = this.decoderTable.get(decoderIndex);
            }
            if (nestedDecoder != null) {
                result = nestedDecoder.decode(regValue);
            }
        }
        return result;
    }

    public String decode_Binary(long regValue) {
        long decoderOutput = this.decode(regValue);
        long bitMask = this.mask >> this.shift;
        String result = "";
        while ((1L & bitMask) == 1L) {
            long bit = decoderOutput & 1L;
            decoderOutput >>= 1;
            bitMask >>= 1;
            if (bit == 0L) {
                result = "0" + result;
                continue;
            }
            result = "1" + result;
        }
        return result;
    }

    public boolean decode_Boolean(long regValue) {
        boolean result = false;
        long decoderOutput = this.decode(regValue);
        if (this.isTrueIfResultIsZero) {
            if (decoderOutput == 0L) {
                result = true;
            }
        } else if (decoderOutput != 0L) {
            result = true;
        }
        return result;
    }

    public long decode() {
        long result = 0L;
        if (this.owner != null) {
            result = this.decode(this.owner.getDataValue());
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("RegisterDecoder " + this.getName() + " called Decode() with owner = null", "RegisterDecoder.Decode()", null);
        }
        return result;
    }

    public String decode_Binary() {
        String result = this.decode_Binary(this.owner.getDataValue());
        return result;
    }

    public boolean decode_Boolean() {
        boolean result = false;
        long decoderOutput = this.decode();
        if (this.isTrueIfResultIsZero) {
            if (decoderOutput == 0L) {
                result = true;
            }
        } else if (decoderOutput != 0L) {
            result = true;
        }
        return result;
    }

    public String decode_String() {
        return this.decode_String(this.owner.getDataValue());
    }

    public String decode_String(long regValue) {
        String result = "";
        int index = (int)this.decode(regValue);
        if (this.isAStringTable && index < this.stringTable.size()) {
            result = this.stringTable.get(index);
        }
        return result;
    }

    public long encode(long regValue, long dataToEncode, boolean updateContextSaveValue, RegisterHandler regHdlrToUpdate) {
        long tempData = dataToEncode;
        int regIndex = 0;
        tempData -= this.addToProduct;
        if (this.multiplier != 0.0) {
            tempData = (long)((double)tempData / this.multiplier);
        }
        if (this.isALookupTable) {
            int index = 0;
            boolean found = false;
            for (Long item : this.lookupTable) {
                if (tempData == item) {
                    found = true;
                    break;
                }
                ++index;
            }
            tempData = found ? (long)index : 0L;
        }
        tempData <<= this.shift;
        tempData ^= this.xorWithRegValue;
        tempData &= this.mask;
        tempData |= regValue & (this.mask ^ 0xFFFFFFFFFFFFFFFFL);
        if (regHdlrToUpdate != null) {
            regHdlrToUpdate.getDataValues().set(regIndex, tempData);
            if (updateContextSaveValue) {
                regHdlrToUpdate.getContextSaveValues().set(regIndex, tempData);
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo(this.getName() + ".Encode(0x" + Long.toHexString(dataToEncode) + ") for register " + this.owner.getName(), "RegisterDecoder.Encode", null);
            }
            regHdlrToUpdate.requestRegisterWrite(updateContextSaveValue);
        }
        return tempData;
    }

    public long encode_Boolean(boolean dataToEncode, boolean updateContextSaveValue) {
        long input = 0L;
        if (this.isTrueIfResultIsZero) {
            if (!dataToEncode) {
                input = 1L;
            }
        } else if (dataToEncode) {
            input = 1L;
        }
        long encoderOutput = this.encode(input, updateContextSaveValue);
        return encoderOutput;
    }

    public long encode(long dataToEncode, boolean updateContextSaveValue) {
        long result = this.encode(this.owner.getDataValue(), dataToEncode, updateContextSaveValue, this.owner);
        return result;
    }

    public long getMaxLookupValue() {
        long result = 0L;
        if (this.isALookupTable && !this.isAStringTable) {
            for (long value : this.lookupTable) {
                if (result >= value) continue;
                result = value;
            }
        }
        return result;
    }
}

