/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumGtiMemResult;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumRegisterRequestType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.EventArgs;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IMemoryServerEventHandler;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.RegisterUpdateArgs;
import com.ti.ccstudio.debug.memoryserver.events.internal.RegisterActionRequestEvent;
import com.ti.ccstudio.debug.memoryserver.events.internal.RegisterListReadCompleteEvent;
import com.ti.ccstudio.debug.memoryserver.events.internal.RegisterValueChangedEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IMemoryRequestClient;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRegisterRequestClient;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetHandler;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.CExprRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RegisterRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.target.DataValueCollection;
import com.ti.ccstudio.debug.memoryserver.target.RegisterDecoder;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.ccstudio.debug.memoryserver.xml.DeviceXMLReader;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNavigator;
import com.ti.ccstudio.debug.memoryserver.xml.XmlElement;
import com.ti.ccstudio.debug.memoryserver.xml.XmlHelper;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspMemory2;
import com.ti.debug.engine.IDspRegister;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import com.ti.debug.engine.framework.IDisposable;
import java.util.ArrayList;
import java.util.EventObject;

public class RegisterHandler
implements IMemoryServerEventHandler,
IRegisterRequestClient,
IDisposable,
IMemoryRequestClient {
    private IDspValue dspAdrs = null;
    private IDspValue dspValue = null;
    private IDspUser refDspUser = null;
    private ArrayList<IDspRegister> freeQueue_DspReg = null;
    private ArrayList<IDspRegister> inUseQueue_DspReg = null;
    private String name;
    private String symbolName = "";
    private long lengthInMAUs = 1L;
    private int numMAUSperRegister = 4;
    private boolean isMemoryMapped = true;
    private boolean useBlockingWrites = false;
    private boolean useBlockingReads = false;
    private long adrs;
    private long numRegistersInSet = 1L;
    private short memoryPageNumber = 0;
    private TargetHandler targetHdlr = null;
    private EnumGtiMemResult memAccessErrorCode = EnumGtiMemResult.MEM_ACCESS_OK;
    public boolean isRegValueReadOnHalt = false;
    public boolean isRegValueReadOnlyIfMemAnalysisEnabled = false;
    private boolean isContextRestoreReqd = false;
    private boolean isContextValid = false;
    private ArrayList<RegisterDecoder> listOfDecoders = null;
    private Object tagObject = null;
    private int registerId = -1;
    private IDspMemory dspMemoryObj = null;
    private IDspMemory2 dspMemory2Obj = null;
    private DataValueCollection dataValues;
    private DataValueCollection contextSaveValues;
    public RegisterActionRequestEvent onReadRequestEvent = null;
    public RegisterActionRequestEvent onWriteRequestEvent = null;
    public RegisterListReadCompleteEvent onRegisterListReadCompleteEvent = null;
    public RegisterValueChangedEvent onRegisterValueChangedEvent = null;
    private boolean disposed = false;

    public RegisterHandler(String registerName, int registerLengthInMAUs, int numRegistersInSet, long registerAdrs, short memoryPageNumber, ArrayList<RegisterDecoder> listOfDecodersForThisRegister, TargetHandler targetHdlr) {
        this.createRegisterHandler(registerName, numRegistersInSet, targetHdlr);
        this.lengthInMAUs = registerLengthInMAUs;
        this.numMAUSperRegister = (int)this.lengthInMAUs;
        this.memoryPageNumber = memoryPageNumber;
        this.adrs = registerAdrs;
        this.isMemoryMapped = true;
        if (this.targetHdlr != null) {
            if (this.isMemoryMapped) {
                this.dspAdrs.assignLong((int)this.adrs);
                this.dspMemoryObj = this.refDspUser.createDspMemory(this.dspAdrs, (int)this.getLengthInMAUs(), memoryPageNumber);
                if (this.dspMemory2Obj != null && !this.dspMemory2Obj.isDisposed()) {
                    this.dspMemory2Obj.dispose();
                }
                this.dspMemory2Obj = this.dspMemoryObj.getIDspMemory2();
            }
        } else {
            this.dspMemoryObj = null;
            this.dspMemory2Obj = null;
            this.numMAUSperRegister = 1;
        }
        this.registerId = -1;
        this.listOfDecoders = new ArrayList();
        for (RegisterDecoder deviceDecoder : listOfDecodersForThisRegister) {
            this.listOfDecoders.add(new RegisterDecoder(this, deviceDecoder));
        }
    }

    private void createRegisterHandler(String registerName, int numRegistersInSet, TargetHandler targetHdlr) {
        this.name = registerName;
        this.targetHdlr = targetHdlr;
        this.initDspUser();
        this.numRegistersInSet = numRegistersInSet;
        this.dataValues = new DataValueCollection(this, numRegistersInSet);
        this.contextSaveValues = new DataValueCollection(this, numRegistersInSet);
        this.freeQueue_DspReg = new ArrayList();
        this.inUseQueue_DspReg = new ArrayList();
        this.onReadRequestEvent = new RegisterActionRequestEvent(this, EnumRegisterRequestType.READ_REGISTER);
        this.onWriteRequestEvent = new RegisterActionRequestEvent(this, EnumRegisterRequestType.WRITE_REGISTER);
        this.onRegisterListReadCompleteEvent = new RegisterListReadCompleteEvent(this);
        this.onRegisterValueChangedEvent = new RegisterValueChangedEvent(this);
    }

    public RegisterHandler(String registerName, String sdkSymbolicName, int registerLengthInMAUs, long registerAdrs, ArrayList<RegisterDecoder> listOfDecodersForThisRegister, TargetHandler targetHdlr) {
        this.createRegisterHandler(registerName, 1, targetHdlr);
        this.symbolName = sdkSymbolicName;
        this.lengthInMAUs = registerLengthInMAUs;
        this.numMAUSperRegister = (int)this.lengthInMAUs;
        this.dspMemoryObj = null;
        this.dspMemory2Obj = null;
        this.isMemoryMapped = false;
        if (this.symbolName.length() > 0) {
            this.initDspRegisterStuff();
        }
        this.listOfDecoders = new ArrayList();
        for (RegisterDecoder deviceDecoder : listOfDecodersForThisRegister) {
            this.listOfDecoders.add(new RegisterDecoder(this, deviceDecoder));
        }
    }

    public RegisterHandler(String strXPathQueryRoot, MyXPathNavigator xPathNav, XmlElement nodeAtReg, ArrayList<RegisterDecoder> listOfDecodersForDevice, TargetHandler handler) {
        this.targetHdlr = handler;
        this.initDspUser();
        this.freeQueue_DspReg = new ArrayList();
        this.inUseQueue_DspReg = new ArrayList();
        XmlHelper xmlHelper = new XmlHelper();
        this.name = xmlHelper.getString(nodeAtReg, "Name", "none", 0);
        this.symbolName = xmlHelper.getString(nodeAtReg, "SymbolName", "", 0);
        this.lengthInMAUs = xmlHelper.getLong(nodeAtReg, "LengthInMAUs", 1L, 0);
        this.adrs = xmlHelper.getLong(nodeAtReg, "Address", 0L, 1);
        this.memoryPageNumber = (short)xmlHelper.getLong(nodeAtReg, "MemoryPageNumber", 0L, 0);
        this.isMemoryMapped = xmlHelper.getBoolean(nodeAtReg, "IsMemoryMapped", true, 0);
        this.dspMemoryObj = null;
        this.registerId = -1;
        if (this.targetHdlr.getDspUser() != null) {
            if (this.isMemoryMapped) {
                this.dspAdrs.assignLong((int)this.adrs);
                this.dspMemoryObj = this.refDspUser.createDspMemory(this.dspAdrs, (int)this.getLengthInMAUs(), this.memoryPageNumber);
                if (this.dspMemory2Obj != null && !this.dspMemory2Obj.isDisposed()) {
                    this.dspMemory2Obj.dispose();
                }
                this.dspMemory2Obj = this.dspMemoryObj.getIDspMemory2();
            } else if (this.symbolName.length() > 0) {
                this.initDspRegisterStuff();
            }
        }
        this.isRegValueReadOnHalt = xmlHelper.getBoolean(nodeAtReg, "IsRegValueReadOnHalt", false, 0);
        this.isRegValueReadOnlyIfMemAnalysisEnabled = xmlHelper.getBoolean(nodeAtReg, "IsOnlyForMemAnalysis", false, 0);
        this.setContextRestoreReqd(xmlHelper.getBoolean(nodeAtReg, "IsRegValueContextRestoreReqd", false, 0));
        this.numRegistersInSet = xmlHelper.getLong(nodeAtReg, "NumRegistersInSet", 1L, 0);
        this.dataValues = new DataValueCollection(this, (int)this.numRegistersInSet);
        this.contextSaveValues = new DataValueCollection(this, (int)this.numRegistersInSet);
        this.numMAUSperRegister = (int)(this.lengthInMAUs / this.numRegistersInSet);
        if (!this.isMemoryMapped) {
            this.numMAUSperRegister = 1;
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
            MemoryServerTrace.logVerbose("RegisterHandler " + this.name + " created. ", "RegisterList xml constructor", null);
        }
        this.listOfDecoders = new ArrayList();
        if (listOfDecodersForDevice != null) {
            try {
                xmlHelper.readListOfDecodersForThisRegister(nodeAtReg, this, listOfDecodersForDevice);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.onReadRequestEvent = new RegisterActionRequestEvent(this, EnumRegisterRequestType.READ_REGISTER);
        this.onWriteRequestEvent = new RegisterActionRequestEvent(this, EnumRegisterRequestType.WRITE_REGISTER);
        this.onRegisterListReadCompleteEvent = new RegisterListReadCompleteEvent(this);
        this.onRegisterValueChangedEvent = new RegisterValueChangedEvent(this);
    }

    public RegisterHandler(String strXPathQueryRoot, MyXPathNavigator xPathNav, DeviceXMLReader.RegisterInfoItem registerInfo, ArrayList<RegisterDecoder> listOfDecodersForDevice, TargetHandler handler) {
        this.targetHdlr = handler;
        this.initDspUser();
        this.freeQueue_DspReg = new ArrayList();
        this.inUseQueue_DspReg = new ArrayList();
        this.name = registerInfo.name;
        this.symbolName = registerInfo.symbolName;
        this.lengthInMAUs = registerInfo.lengthInMAUs;
        this.adrs = registerInfo.adrs;
        this.memoryPageNumber = registerInfo.memoryPageNumber;
        this.isMemoryMapped = registerInfo.isMemoryMapped;
        this.dspMemoryObj = null;
        this.registerId = -1;
        if (this.targetHdlr.getDspUser() != null) {
            if (this.isMemoryMapped) {
                this.dspAdrs.assignLong((int)this.adrs);
                this.dspMemoryObj = this.refDspUser.createDspMemory(this.dspAdrs, (int)this.getLengthInMAUs(), this.memoryPageNumber);
                if (this.dspMemory2Obj != null && !this.dspMemory2Obj.isDisposed()) {
                    this.dspMemory2Obj.dispose();
                }
                this.dspMemory2Obj = this.dspMemoryObj.getIDspMemory2();
            } else if (this.symbolName.length() > 0) {
                this.initDspRegisterStuff();
            }
        }
        this.isRegValueReadOnHalt = registerInfo.isRegValueReadOnHalt;
        this.isRegValueReadOnlyIfMemAnalysisEnabled = registerInfo.isRegValueReadOnlyIfMemAnalysisEnabled;
        this.setContextRestoreReqd(registerInfo.isContextRestoreReqd);
        this.numRegistersInSet = registerInfo.numRegistersInSet;
        this.dataValues = new DataValueCollection(this, (int)this.numRegistersInSet);
        this.contextSaveValues = new DataValueCollection(this, (int)this.numRegistersInSet);
        this.numMAUSperRegister = (int)(this.lengthInMAUs / this.numRegistersInSet);
        if (!this.isMemoryMapped) {
            this.numMAUSperRegister = 1;
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
            MemoryServerTrace.logVerbose("RegisterHandler " + this.name + " created. ", "RegisterList xml constructor", null);
        }
        this.listOfDecoders = new ArrayList();
        if (listOfDecodersForDevice != null) {
            try {
                this.readListOfDecodersForThisRegister(registerInfo.regDecoders, listOfDecodersForDevice);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.onReadRequestEvent = new RegisterActionRequestEvent(this, EnumRegisterRequestType.READ_REGISTER);
        this.onWriteRequestEvent = new RegisterActionRequestEvent(this, EnumRegisterRequestType.WRITE_REGISTER);
        this.onRegisterListReadCompleteEvent = new RegisterListReadCompleteEvent(this);
        this.onRegisterValueChangedEvent = new RegisterValueChangedEvent(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public void setSymbolName(String value) {
        this.symbolName = value;
    }

    public long getLengthInMAUs() {
        return this.lengthInMAUs;
    }

    public void setLengthInMAUs(long value) {
        this.lengthInMAUs = value;
    }

    public int getNumMAUSperRegister() {
        return this.numMAUSperRegister;
    }

    public void setNumMAUSperRegister(int value) {
        this.numMAUSperRegister = value;
    }

    public boolean isMemoryMapped() {
        return this.isMemoryMapped;
    }

    public boolean getUseBlockingWrites() {
        return this.useBlockingWrites;
    }

    public void setUseBlockingWrites(boolean value) {
        this.useBlockingWrites = value;
    }

    public boolean getUseBlockingReads() {
        return this.useBlockingReads;
    }

    public void setUseBlockingReads(boolean value) {
        this.useBlockingReads = value;
    }

    public long getAdrs() {
        long result = this.adrs;
        if (this.isTargetAccessRequestEnabled() && this.registerId >= 0) {
            result = this.registerId;
        }
        return result;
    }

    public long getNumRegistersInSet() {
        return this.numRegistersInSet;
    }

    public void setNumRegistersInSet(long value) {
        this.numRegistersInSet = value;
    }

    public short getMemoryPageNumber() {
        return this.memoryPageNumber;
    }

    public ITargetHandler getTargetHdlr() {
        return this.targetHdlr;
    }

    public boolean isTargetAccessRequestEnabled() {
        boolean result = false;
        if (!this.isMemoryMapped || this.dspMemoryObj != null) {
            result = true;
        }
        return result;
    }

    public EnumGtiMemResult getMemAccessErrorCode() {
        return this.memAccessErrorCode;
    }

    public void setMemAccessErrorCode(EnumGtiMemResult value) {
        this.memAccessErrorCode = value;
        if (this.memAccessErrorCode != EnumGtiMemResult.MEM_ACCESS_OK && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("Error reading register " + this.name + " (Adrs = 0x" + Long.toHexString(this.adrs) + ")", "RegisterHandler.set_MemAccessErrorCode", null);
        }
    }

    public void setContextRestoreReqd(boolean isContextRestoreReqd) {
        this.isContextRestoreReqd = isContextRestoreReqd;
    }

    public boolean isContextRestoreReqd() {
        return this.isContextRestoreReqd;
    }

    public void setContextValid(boolean isContextValid) {
        this.isContextValid = isContextValid;
    }

    public boolean isContextValid() {
        return this.isContextValid;
    }

    public boolean isRegisterSupported() {
        boolean result = true;
        if (this.isMemoryMapped) {
            if (this.getAdrs() == -1L) {
                result = false;
            }
        } else if (this.getRegisterId() == -1) {
            result = false;
        }
        return result;
    }

    public ArrayList<RegisterDecoder> getListOfDecoders() {
        return this.listOfDecoders;
    }

    public Object getTagObject() {
        return this.tagObject;
    }

    public void setTagObject(Object value) {
        this.tagObject = value;
    }

    public int getRegisterId() {
        return this.registerId;
    }

    public void setRegisterId(int value) {
        this.registerId = value;
    }

    public IDspMemory getDspMemoryObj() {
        return this.dspMemoryObj;
    }

    public DataValueCollection getDataValues() {
        return this.dataValues;
    }

    public long getDataValue() {
        long result = this.dataValues.get(0);
        return result;
    }

    public void setDataValue(long value) {
        boolean hasChanged = false;
        if (this.dataValues.size() > 0L) {
            if (this.dataValues.get(0) != value) {
                hasChanged = true;
            }
            this.dataValues.set(0, value);
        }
        this.requestRegisterWrite(hasChanged);
    }

    public DataValueCollection getContextSaveValues() {
        return this.contextSaveValues;
    }

    public void setContextSaveValues(DataValueCollection value) {
        this.contextSaveValues = value;
    }

    public long getContextSaveValue() {
        long result = this.contextSaveValues.get(0);
        return result;
    }

    public void setContextSaveValue(long value) {
        if (this.contextSaveValues.size() > 0L) {
            this.contextSaveValues.set(0, value);
        }
    }

    public void update(IDspRegister dspReg) {
        boolean hasChanged = false;
        long newDataValue = 0L;
        int mauIndex = 0;
        int index = 0;
        while ((long)index < this.dataValues.size()) {
            mauIndex = index * this.numMAUSperRegister;
            dspReg.getDspValue(this.dspValue, mauIndex);
            newDataValue = this.dspValue.toLongLong();
            if (this.dataValues.get(index) != newDataValue) {
                this.dataValues.set(index, newDataValue);
                hasChanged = true;
            }
            ++index;
        }
        if (hasChanged && this.onRegisterValueChangedEvent != null) {
            this.onRegisterValueChangedEvent.raise();
        }
    }

    private void initDspUser() {
        block4: {
            try {
                this.refDspUser = this.targetHdlr.getDspUser();
                if (this.refDspUser != null) {
                    this.dspAdrs = this.refDspUser.createDspValue(EnumDspValueType.DSP_FAR_POINTER.getInt(), 0);
                    if (this.dspAdrs.sizeOf() == 0) {
                        this.dspAdrs = this.refDspUser.createDspValue(EnumDspValueType.DSP_POINTER.getInt(), 0);
                    }
                    this.dspValue = this.refDspUser.createDspValue(EnumDspValueType.DSP_INT.getInt(), 0);
                }
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block4;
                MemoryServerTrace.logException("Exception creating dsp Value objects", "RegisterHandler.InitDspUser", ex, this.targetHdlr.info);
            }
        }
    }

    private void initDspRegisterStuff() {
        block4: {
            IDspTask refDspTask = this.targetHdlr.getDspTask();
            if (refDspTask != null) {
                try {
                    this.registerId = this.refDspUser.getDspRegisterID(this.symbolName);
                }
                catch (Exception ex) {
                    String strSymbolName = "null";
                    if (this.symbolName != null) {
                        strSymbolName = this.symbolName;
                    }
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block4;
                    MemoryServerTrace.logException("Failure attempting to read register with symbol name = " + strSymbolName, "RegisterHandler.initDspRegisterStuff", ex, null);
                }
            }
        }
    }

    private IDspRegister getDspRegisterObj() {
        IDspRegister result;
        block4: {
            result = null;
            if (this.refDspUser != null) {
                try {
                    result = this.refDspUser.createDspRegister(this.registerId);
                    this.inUseQueue_DspReg.add(result);
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo("Added register to queue: inUseQueue_DspReg.Count = " + this.inUseQueue_DspReg.size() + ", freeQueue_DspReg.Count = " + this.freeQueue_DspReg.size(), "RegisterHandler.getDspRegisterObj", this.targetHdlr.info);
                    }
                }
                catch (Exception ex) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block4;
                    MemoryServerTrace.logException("Exception calling dspUser.createDspRegister", "RegisterHazndler.getDspRegisterObj", ex, this.targetHdlr.info);
                }
            }
        }
        return result;
    }

    private void releaseDspRegisterObj(IDspRegister dspRegister) {
        if (dspRegister != null) {
            this.inUseQueue_DspReg.remove(dspRegister);
            this.freeQueue_DspReg.add(dspRegister);
            if (!dspRegister.isDisposed()) {
                dspRegister.dispose();
            }
        }
    }

    public RegisterDecoder getDecoder(String decoderName) {
        RegisterDecoder result = null;
        for (RegisterDecoder decoder : this.listOfDecoders) {
            if (!decoder.getName().equals(decoderName)) continue;
            result = decoder;
            break;
        }
        return result;
    }

    public boolean requestRegisterWrite(boolean broadcast) {
        boolean result;
        block18: {
            result = false;
            try {
                if (!this.isMemoryMapped) {
                    IDspRegister writeDspRegister = this.getDspRegisterObj();
                    if (writeDspRegister != null) {
                        int index = 0;
                        while ((long)index < this.dataValues.size()) {
                            writeDspRegister.setMem(index * this.numMAUSperRegister, (int)this.dataValues.get(index));
                            ++index;
                        }
                        if (this.onWriteRequestEvent != null) {
                            this.onWriteRequestEvent.raise(writeDspRegister, this.useBlockingWrites);
                        }
                        if (!this.useBlockingWrites) {
                            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
                                MemoryServerTrace.logTransaction("About to call dspUser.RequestRegisterWrite for RegHdlr " + this.getName() + "[" + this.symbolName + ", id=0x" + Long.toHexString(this.registerId) + "), write data = 0x" + Long.toHexString(this.getDataValue()), "RegisterHandler.RequestRegisterWrite", this.targetHdlr.info);
                            }
                            this.refDspUser.requestRegisterWrite(writeDspRegister, broadcast);
                        } else {
                            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
                                MemoryServerTrace.logTransaction("BLOCKING WRITE NOT IMPLEMENTED (using async write instead)!! About to call dspUser.BlockingRegisterWrite for RegHdlr " + this.getName() + "[" + this.symbolName + ", id=0x" + Long.toHexString(this.registerId) + "), write data = 0x" + Long.toHexString(this.getDataValue()), "RegisterHandler.RequestRegisterWrite", this.targetHdlr.info);
                            }
                            this.refDspUser.requestRegisterWrite(writeDspRegister, broadcast);
                        }
                    }
                } else if (this.dspMemoryObj != null) {
                    int index = 0;
                    while ((long)index < this.dataValues.size()) {
                        this.dspValue.assignLong((int)this.dataValues.get(index));
                        this.dspMemoryObj.setDspValue(this.dspValue, this.numMAUSperRegister * index);
                        ++index;
                    }
                    if (this.onWriteRequestEvent != null) {
                        this.onWriteRequestEvent.raise((IDspRegister)null, this.useBlockingWrites);
                    }
                    if (this.dspMemory2Obj != null) {
                        if (this.targetHdlr.getMemLevelInfoHdlr().isMmuBypassSupported() && this.targetHdlr.info.isARMdevice()) {
                            int memAllLevalsFlags = this.targetHdlr.getMemLevelInfoHdlr().getGtiMemAccessIdFlags_AllLevels();
                            int flags = this.targetHdlr.getMemLevelInfoHdlr().calculateMemAccessIdFlags(EnumMemoryViews.PHYSICAL_MEMORY_VIEW, memAllLevalsFlags);
                            this.dspMemory2Obj.setMemoryAccessLevel(flags);
                        }
                        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
                            MemoryServerTrace.logTransaction("About to call dspUser.RequestMemoryWrite for RegHdlr " + this.getName() + "[" + this.symbolName + ", id=0x" + Long.toHexString(this.registerId) + "), write data = 0x" + Long.toHexString(this.getDataValue()), "RegisterHandler.RequestRegisterWrite", this.targetHdlr.info);
                        }
                        this.refDspUser.requestMemoryWrite(this.dspMemoryObj, broadcast);
                        result = true;
                    }
                }
                if (broadcast && this.onRegisterValueChangedEvent != null) {
                    this.onRegisterValueChangedEvent.raise();
                }
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block18;
                MemoryServerTrace.logException("Exception writing to RegHdlr " + this.getName() + "[" + this.symbolName + ", id=0x" + Long.toHexString(this.registerId) + "), write data = 0x" + Long.toHexString(this.getDataValue()), "RegisterHandler.RequestRegisterWrite", ex, this.targetHdlr.info);
            }
        }
        return result;
    }

    public boolean requestRegisterRead() {
        boolean result = false;
        boolean requestMadeByOwner = false;
        if (!this.isMemoryMapped) {
            if (this.refDspUser != null) {
                IDspRegister dspReg = this.getDspRegisterObj();
                if (this.onReadRequestEvent != null) {
                    requestMadeByOwner = this.onReadRequestEvent.raise(dspReg, this.useBlockingReads);
                }
                if (requestMadeByOwner) {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
                        MemoryServerTrace.logTransaction("About to call dspUser.requestRegisterRead for RegHdlr " + this.getName() + "[" + this.symbolName + ", id=0x" + Integer.toHexString(this.registerId) + ")", "RegisterHandler.requestRegisterRead", this.targetHdlr.info);
                    }
                    if (!this.useBlockingReads) {
                        this.refDspUser.requestRegisterRead(dspReg, false);
                        result = true;
                    } else {
                        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                            MemoryServerTrace.logError("BLOCKING READ NOT IMPLEMENTED (using async read instead)!! About to call dspUser.requestRegisterRead for RegHdlr " + this.getName() + "[" + this.symbolName + ", id=0x" + Integer.toHexString(this.registerId) + ")", "RegisterHandler.requestRegisterRead", this.targetHdlr.info);
                        }
                        this.refDspUser.requestRegisterRead(dspReg, false);
                        result = true;
                    }
                } else {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logTransaction("Attempt to read register without having RegisterList create transaction request first. " + this.getName() + "[" + this.symbolName + ", id=0x" + Integer.toHexString(this.registerId) + ")", "RegisterHandler.requestRegisterRead", this.targetHdlr.info);
                    }
                    result = false;
                }
                if (dspReg != null && !dspReg.isDisposed()) {
                    dspReg.dispose();
                }
            }
        } else if (this.dspMemoryObj != null) {
            if (this.onReadRequestEvent != null) {
                requestMadeByOwner = this.onReadRequestEvent.raise(this.dspMemoryObj, this.useBlockingReads);
            }
            if (requestMadeByOwner) {
                if (this.dspMemory2Obj != null) {
                    if (this.targetHdlr.getMemLevelInfoHdlr().isMmuBypassSupported() && this.targetHdlr.info.isARMdevice()) {
                        int memAllLevalsFlags = this.targetHdlr.getMemLevelInfoHdlr().getGtiMemAccessIdFlags_AllLevels();
                        int flags = this.targetHdlr.getMemLevelInfoHdlr().calculateMemAccessIdFlags(EnumMemoryViews.PHYSICAL_MEMORY_VIEW, memAllLevalsFlags);
                        this.dspMemory2Obj.setMemoryAccessLevel(flags);
                    }
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
                        MemoryServerTrace.logTransaction("About to call dspUser.requestMemoryRead for RegHdlr " + this.getName() + "[" + this.symbolName + ", id=0x" + Integer.toHexString(this.registerId) + ")", "RegisterHandler.requestRegisterRead", this.targetHdlr.info);
                    }
                    this.refDspUser.requestMemoryRead(this.dspMemoryObj, false);
                    result = true;
                } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logError("dspMemory2Obj == null", "RegisterHandler.requestRegisterRead", this.targetHdlr.info);
                }
                result = true;
            } else {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logTransaction("Attempt to read memory without having RegisterList create transaction request first. " + this.getName() + "[" + this.symbolName + ", id=0x" + Integer.toHexString(this.registerId) + ")", "RegisterHandler.requestRegisterRead", this.targetHdlr.info);
                }
                result = false;
            }
        }
        return result;
    }

    private void onMemoryReadComplete(Object dspObject) {
        boolean hasChanged = false;
        long newDataValue = 0L;
        int mauIndex = 0;
        if (this.isMemoryMapped) {
            int index = 0;
            while ((long)index < this.dataValues.size()) {
                mauIndex = index * this.numMAUSperRegister;
                if (this.dspMemoryObj != null) {
                    this.dspMemoryObj.getDspValue(this.dspValue, mauIndex);
                    newDataValue = this.dspValue.toLongLong();
                }
                if (this.dataValues.get(index) != newDataValue) {
                    hasChanged = true;
                }
                this.dataValues.set(index, newDataValue);
                this.contextSaveValues.set(index, newDataValue);
                ++index;
            }
            this.setContextValid(true);
            if (this.onRegisterListReadCompleteEvent != null) {
                this.onRegisterListReadCompleteEvent.raise();
            }
            if (hasChanged && this.onRegisterValueChangedEvent != null) {
                this.onRegisterValueChangedEvent.raise();
            }
        }
    }

    private void onRegisterReadComplete(RegisterUpdateArgs args) {
        if (this.refDspUser != null) {
            IDspRegister dspReg = args.getDspRegisterObj();
            this.update(dspReg);
            this.setContextValid(true);
        }
        if (this.onRegisterListReadCompleteEvent != null) {
            this.onRegisterListReadCompleteEvent.raise();
        }
    }

    private void onWriteRequestCompleteHandler(Object regUpdateArgs) {
        if (!this.isMemoryMapped) {
            if (regUpdateArgs instanceof RegisterUpdateArgs) {
                RegisterUpdateArgs args = (RegisterUpdateArgs)regUpdateArgs;
                if (args != null && !args.isDisposed()) {
                    args.dispose();
                }
                Object var2_2 = null;
            } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                MemoryServerTrace.logWarning("Unknown type of dspObject: " + regUpdateArgs.toString(), "RegisterHandler.onWriteRequestCompleteHandler", this.targetHdlr.info);
            }
        }
    }

    @Override
    public void onCExpressionEvaluationCompleteHandler(CExprRequestDescriptor cExprEvalRequestDescriptor) {
    }

    @Override
    public void onMemoryRequestCompleteHandler(MemoryRequestDescriptor memoryRequestDescriptor, long requestStartAdrs, long requestLengthInMAUs) {
        MemoryRequestDescriptor req = memoryRequestDescriptor;
        switch (req.getRequestType()) {
            case READ: {
                this.onMemoryReadComplete(req.getClientTagObject());
                break;
            }
            case WRITE: {
                this.onWriteRequestCompleteHandler(req.getClientTagObject());
            }
        }
    }

    @Override
    public void onRegisterRequestCompleteHandler(RegisterRequestDescriptor req) {
        switch (req.getRegisterRequestType()) {
            case READ_REGISTER: {
                this.onRegisterReadComplete(req.getRegisterUpdateInfo());
                break;
            }
            case WRITE_REGISTER: {
                this.onWriteRequestCompleteHandler(req.getRegisterUpdateInfo());
            }
        }
    }

    @Override
    public void handleEvent(EventObject e, EventArgs args) {
    }

    public void dispose() {
        this.dispose(true);
    }

    protected synchronized void dispose(boolean disposing) {
        if (!this.disposed && disposing) {
            try {
                if (this.dspMemoryObj != null && !this.dspMemoryObj.isDisposed()) {
                    this.dspMemoryObj.dispose();
                }
                this.dspMemoryObj = null;
                if (this.dspMemory2Obj != null && !this.dspMemory2Obj.isDisposed()) {
                    this.dspMemory2Obj.dispose();
                }
                this.dspMemory2Obj = null;
                if (this.dspAdrs != null && !this.dspAdrs.isDisposed()) {
                    this.dspAdrs.dispose();
                }
                this.dspAdrs = null;
                if (this.dspValue != null && !this.dspValue.isDisposed()) {
                    this.dspValue.dispose();
                }
                IDspRegister dspReg = null;
                while (this.inUseQueue_DspReg.size() > 0) {
                    dspReg = this.inUseQueue_DspReg.get(0);
                    this.inUseQueue_DspReg.remove(0);
                    if (dspReg == null || dspReg.isDisposed()) continue;
                    dspReg.dispose();
                }
                while (this.freeQueue_DspReg.size() > 0) {
                    dspReg = this.inUseQueue_DspReg.get(0);
                    this.freeQueue_DspReg.remove(0);
                    if (dspReg == null || dspReg.isDisposed()) continue;
                    dspReg.dispose();
                }
                if (this.onReadRequestEvent != null && !this.onReadRequestEvent.isDisposed()) {
                    this.onReadRequestEvent.dispose();
                }
                this.onReadRequestEvent = null;
                if (this.onWriteRequestEvent != null && !this.onWriteRequestEvent.isDisposed()) {
                    this.onWriteRequestEvent.dispose();
                }
                this.onWriteRequestEvent = null;
                if (this.onRegisterListReadCompleteEvent != null && !this.onRegisterListReadCompleteEvent.isDisposed()) {
                    this.onRegisterListReadCompleteEvent.dispose();
                }
                this.onRegisterListReadCompleteEvent = null;
                if (this.onRegisterValueChangedEvent != null && !this.onRegisterValueChangedEvent.isDisposed()) {
                    this.onRegisterValueChangedEvent.dispose();
                }
                this.onRegisterValueChangedEvent = null;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void acquire() {
    }

    private boolean readListOfDecodersForThisRegister(ArrayList<String> regDecoders, ArrayList<RegisterDecoder> listOfDecodersForDevice) {
        boolean decoderFound = false;
        String decoderName = "";
        String xmlDecoderName = "";
        int numDecodersListedForRegHdlr = 0;
        if (regDecoders == null) {
            return false;
        }
        for (int i = 0; i < regDecoders.size(); ++i) {
            ++numDecodersListedForRegHdlr;
            xmlDecoderName = regDecoders.get(i);
            decoderName = xmlDecoderName.trim().toLowerCase();
            decoderFound = false;
            for (RegisterDecoder deviceDecoder : listOfDecodersForDevice) {
                if (!deviceDecoder.getName().trim().toLowerCase().equals(decoderName)) continue;
                decoderFound = true;
                this.getListOfDecoders().add(new RegisterDecoder(this, deviceDecoder));
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) break;
                MemoryServerTrace.logVerbose("RegisterDecoder " + xmlDecoderName + " added to register " + this.getName(), "RegisterHandler.readListOfDecodersForThisRegister", null);
                break;
            }
            if (decoderFound || !MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
            MemoryServerTrace.logError("Error reading xml file for register " + this.getName() + ": could not find decoder " + xmlDecoderName, "RegisterHandler.readListOfDecodersForThisRegister", null);
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo(Integer.toString(numDecodersListedForRegHdlr) + " found in xml file for register " + this.getName(), "RegisterHandler.readListOfDecodersForThisRegister", null);
        }
        return decoderFound;
    }
}

