/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryRequestTypes;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumReasonForRefresh;
import com.ti.ccstudio.debug.memoryserver.enums.EnumRegisterRequestType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumStringFormatStyle;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.EventArgs;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IRegisterActionRequestEventHandler;
import com.ti.ccstudio.debug.memoryserver.events.internal.GetRegisterContextValuesCompleteEvent;
import com.ti.ccstudio.debug.memoryserver.events.internal.IRegisterListReadCompleteEventHandler;
import com.ti.ccstudio.debug.memoryserver.events.internal.MemoryServerEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IReleasable;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetHandler;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.CExprRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.MemoryRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RegisterRequestDescriptor;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorQueue;
import com.ti.ccstudio.debug.memoryserver.target.RegisterDecoder;
import com.ti.ccstudio.debug.memoryserver.target.RegisterHandler;
import com.ti.debug.engine.IDspMemory;
import com.ti.debug.engine.IDspRegister;
import com.ti.debug.engine.framework.IDisposable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;

public class RegisterList
implements Iterable<RegisterHandler>,
IRegisterActionRequestEventHandler,
IRegisterListReadCompleteEventHandler,
IDisposable {
    private ArrayList<RegisterHandler> listOfRegisters = null;
    private ITargetHandler target = null;
    private RequestDescriptorQueue targetAccessRequestQueue = null;
    private RequestDescriptorQueue registerAccessRequestQueue = null;
    private RequestDescriptorQueue cexprEvalRequestQueue = null;
    private String name = "";
    private ArrayList<EnumReasonForRefresh> reasonForRefreshQueue = null;
    private boolean isReadingRegisterContextValues = false;
    private ArrayList<RegisterDecoder> listOfDecoders = null;
    private RegisterHandler lastRegHdlrInListOfRegsReadOnHalt = null;
    private boolean isOnlyReadMemoryAnalysisRegisters = false;
    public GetRegisterContextValuesCompleteEvent onGetRegisterContextValuesComplete;
    private int currentIndex = -1;
    public MemoryServerEvent onRestoreRegisterContextValuesComplete = null;
    private volatile boolean disposed = false;

    public RegisterList(ITargetHandler targetDevice, RequestDescriptorQueue targetAccessRequestQueueObj, RequestDescriptorQueue cexprEvalRequestQueueObj, RequestDescriptorQueue targetRegisterRequestQueueObj, boolean readInfoFromXmlFile) {
        this.target = targetDevice;
        this.target.getEventHandler().addEventListener(this);
        this.targetAccessRequestQueue = targetAccessRequestQueueObj;
        this.registerAccessRequestQueue = targetRegisterRequestQueueObj;
        this.cexprEvalRequestQueue = cexprEvalRequestQueueObj;
        this.listOfRegisters = new ArrayList();
        this.listOfDecoders = new ArrayList();
        this.onGetRegisterContextValuesComplete = new GetRegisterContextValuesCompleteEvent(this);
        if (readInfoFromXmlFile) {
            this.target.getInfo().getXmlDeviceInfoHandler().readRegisterInfoFromXmlFile(this);
        }
        this.reasonForRefreshQueue = new ArrayList();
    }

    public RegisterList(ITargetHandler targetDevice, RequestDescriptorQueue targetAccessRequestQueueObj, RequestDescriptorQueue cexprEvalRequestQueueObj, RequestDescriptorQueue targetRegisterRequestQueueObj) {
        this(targetDevice, targetAccessRequestQueueObj, cexprEvalRequestQueueObj, targetRegisterRequestQueueObj, true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public EnumReasonForRefresh getReasonForRefresh() {
        EnumReasonForRefresh reason = EnumReasonForRefresh.NO_REASON_SPECIFIED;
        if (this.reasonForRefreshQueue.size() > 0) {
            reason = this.reasonForRefreshQueue.remove(0);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("RegisterList.get_ReasonForRefresh: " + reason.toString() + "[queue count = " + Long.toString(this.reasonForRefreshQueue.size()) + "]", "RegisterList.getReasonForRefresh", this.target.getInfo());
            }
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("RegisterList.reasonForRefreshQueue.size() == 0, using NO_REASON_SPECIFIED", "RegisterList.getReasonForRefresh", this.target.getInfo());
        }
        return reason;
    }

    public void setReasonForRefresh(EnumReasonForRefresh value) {
        this.reasonForRefreshQueue.add(value);
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("RegisterList.get_ReasonForRefresh: " + value.toString() + "[queue count = " + Long.toString(this.reasonForRefreshQueue.size()) + "]", "RegisterList.setReasonForRefresh", this.target.getInfo());
        }
    }

    public RegisterHandler get(int registerIndex) {
        if (registerIndex > this.listOfRegisters.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.listOfRegisters.get(registerIndex);
    }

    public int size() {
        return this.listOfRegisters.size();
    }

    public int getNumRegistersToReadOnFlush(boolean isMemoryAnalysisEnabled) {
        int result = 0;
        for (RegisterHandler regObj : this.listOfRegisters) {
            if (!regObj.isRegValueReadOnHalt || !isMemoryAnalysisEnabled && regObj.isRegValueReadOnlyIfMemAnalysisEnabled) continue;
            ++result;
        }
        return result;
    }

    public boolean isReadingRegisterContextValues() {
        return this.isReadingRegisterContextValues;
    }

    public void setIsReadingRegisterContextValues(boolean value) {
        this.isReadingRegisterContextValues = value;
    }

    public ArrayList<RegisterDecoder> getListOfDecoders() {
        return this.listOfDecoders;
    }

    public void add(RegisterHandler regHdlr) {
        this.listOfRegisters.add(regHdlr);
        regHdlr.onReadRequestEvent.addListener(this);
        regHdlr.onWriteRequestEvent.addListener(this);
    }

    public RegisterHandler getRegisterHandler(String regName) {
        RegisterHandler result = null;
        String strRegName = regName.trim().toUpperCase();
        for (RegisterHandler regHandler : this.listOfRegisters) {
            String strRegHdlrName = regHandler.getName().trim().toUpperCase();
            if (strRegName == null || !strRegName.equals(strRegHdlrName)) continue;
            result = regHandler;
            break;
        }
        return result;
    }

    public void flush() {
        for (RegisterHandler regHandler : this.listOfRegisters) {
            regHandler.setContextValid(false);
        }
    }

    public int getRegisterContextValues(boolean isMemoryAnalysisEnabled) {
        return this.getRegisterContextValues(false, isMemoryAnalysisEnabled, false);
    }

    public int getRegisterContextValues(boolean forceReadNow, boolean isMemoryAnalysisEnabled, boolean onlyReadMemoryAnalysisRegisters) {
        int result = 0;
        RegisterHandler lastRegToBeRead = null;
        int regIndex = 0;
        while (regIndex < this.listOfRegisters.size()) {
            RegisterHandler regHdlr = this.listOfRegisters.get(regIndex++);
            if (!forceReadNow && (!regHdlr.isRegValueReadOnHalt || regHdlr.isRegValueReadOnlyIfMemAnalysisEnabled && !isMemoryAnalysisEnabled) || !regHdlr.isRegisterSupported() || !forceReadNow && onlyReadMemoryAnalysisRegisters && !regHdlr.isRegValueReadOnlyIfMemAnalysisEnabled) continue;
            lastRegToBeRead = regHdlr;
        }
        if (lastRegToBeRead != null) {
            this.isReadingRegisterContextValues = true;
            this.lastRegHdlrInListOfRegsReadOnHalt = lastRegToBeRead;
            this.lastRegHdlrInListOfRegsReadOnHalt.onRegisterListReadCompleteEvent.addListener(this);
            for (int index = 0; index < this.listOfRegisters.size(); ++index) {
                block9: {
                    RegisterHandler regHdlr = this.listOfRegisters.get(index);
                    if (!forceReadNow && (!regHdlr.isRegValueReadOnHalt || regHdlr.isRegValueReadOnlyIfMemAnalysisEnabled && !isMemoryAnalysisEnabled) || !regHdlr.isRegisterSupported() || !forceReadNow && onlyReadMemoryAnalysisRegisters && !regHdlr.isRegValueReadOnlyIfMemAnalysisEnabled) continue;
                    regHdlr.setContextValid(false);
                    try {
                        regHdlr.requestRegisterRead();
                        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                            MemoryServerTrace.logInfo("regHdlr.Name = " + regHdlr.getName() + " [0x" + Long.toHexString(regHdlr.getAdrs()) + "] = 0x" + Long.toHexString(regHdlr.getContextSaveValue()), "RegisterList.getRegisterContextValues", this.target.getInfo());
                        }
                    }
                    catch (Exception ex) {
                        if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) break block9;
                        MemoryServerTrace.logException("regHdlr.Name = " + regHdlr.getName(), "RegisterList.getRegisterContextValues", ex, this.target.getInfo());
                    }
                }
                ++result;
            }
            if (onlyReadMemoryAnalysisRegisters) {
                this.isOnlyReadMemoryAnalysisRegisters = true;
            }
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
            for (RegisterHandler regHdlr : this.listOfRegisters) {
                if (regHdlr.isRegValueReadOnHalt && regHdlr.getTagObject() != null) continue;
                MemoryServerTrace.logVerbose("regHdlr.Name = " + regHdlr.getName() + " [0x" + Long.toHexString(regHdlr.getAdrs()) + "] IsRegisterSupported = " + regHdlr.isRegisterSupported() + "] IsRegValueReadOnHalt = " + regHdlr.isRegValueReadOnHalt + "] isRegValueReadOnlyIfMemAnalysisEnabled = " + regHdlr.isRegValueReadOnlyIfMemAnalysisEnabled, "RegisterList.getRegisterContextValues", this.target.getInfo());
            }
        }
        return result;
    }

    public void remove(RegisterHandler regObj) {
        IReleasable tagObj;
        if (regObj.getTagObject() instanceof IReleasable && (tagObj = (IReleasable)regObj.getTagObject()) != null) {
            tagObj.release();
        }
        this.listOfRegisters.remove(regObj);
    }

    public RegisterHandler getRegister(int registerListIndex) {
        RegisterHandler result = null;
        if (registerListIndex < this.listOfRegisters.size()) {
            result = this.listOfRegisters.get(registerListIndex);
        }
        return result;
    }

    public ArrayList<RegisterHandler> getList() {
        return this.listOfRegisters;
    }

    public int indexOf(RegisterHandler register) {
        int result = -1;
        for (int index = 0; index < this.listOfRegisters.size(); ++index) {
            if (this.listOfRegisters.get(index) != register) continue;
            result = index;
            break;
        }
        return result;
    }

    public RegisterHandler findRegister(long registerId) {
        RegisterHandler result = null;
        for (RegisterHandler regHdlr : this.listOfRegisters) {
            if ((long)regHdlr.getRegisterId() != registerId) continue;
            result = regHdlr;
            break;
        }
        return result;
    }

    public void clear() {
        RegisterHandler regHdlr = null;
        this.flush();
        while (this.listOfRegisters.size() > 0) {
            int index;
            regHdlr = this.listOfRegisters.get(0);
            if (this.targetAccessRequestQueue != null) {
                index = 0;
                MemoryRequestDescriptor memReq = null;
                while (index < this.targetAccessRequestQueue.size()) {
                    memReq = (MemoryRequestDescriptor)this.targetAccessRequestQueue.peekAtRequestAtIndex(index);
                    if (memReq.getClientToNotifyOnRequestComplete() == regHdlr) {
                        memReq.setDiscard(true);
                        this.targetAccessRequestQueue.deleteRequest(memReq, true);
                        continue;
                    }
                    ++index;
                }
            }
            if (this.cexprEvalRequestQueue != null) {
                index = 0;
                CExprRequestDescriptor cExprReq = null;
                while (index < this.cexprEvalRequestQueue.size()) {
                    cExprReq = (CExprRequestDescriptor)this.cexprEvalRequestQueue.peekAtRequestAtIndex(index);
                    if (cExprReq.getClientToNotifyOnRequestComplete() == regHdlr) {
                        cExprReq.setDiscard(true);
                        this.cexprEvalRequestQueue.deleteRequest(cExprReq, true);
                        continue;
                    }
                    ++index;
                }
            }
            if (regHdlr != null && !regHdlr.isDisposed()) {
                regHdlr.dispose();
            }
            this.remove(this.listOfRegisters.get(0));
        }
        this.listOfRegisters.clear();
        this.listOfDecoders.clear();
        this.reset();
    }

    public void onGetRegisterContextValuesCompleted() {
        this.isReadingRegisterContextValues = false;
        if (this.onGetRegisterContextValuesComplete != null) {
            this.onGetRegisterContextValuesComplete.raise();
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("EventHandler is Null, could not raise event.", "RegisterList.onGetRegisterContextValuesCompleted", this.target.getInfo());
        }
    }

    public void reset() {
        this.currentIndex = -1;
    }

    public RegisterHandler getCurrent() {
        RegisterHandler result = null;
        if (this.currentIndex >= 0 && this.listOfRegisters.size() > this.currentIndex) {
            result = this.listOfRegisters.get(this.currentIndex);
        }
        return result;
    }

    public RegisterHandler next() {
        RegisterHandler result = null;
        if (this.currentIndex + 1 < this.listOfRegisters.size()) {
            ++this.currentIndex;
            result = this.listOfRegisters.get(this.currentIndex);
        }
        return result;
    }

    public boolean hasNext() {
        boolean result = false;
        if (this.currentIndex + 1 < this.listOfRegisters.size()) {
            result = true;
        }
        return result;
    }

    public void remove() {
        if (this.currentIndex >= 0 && this.currentIndex < this.listOfRegisters.size()) {
            this.listOfRegisters.remove(this.currentIndex);
            if (this.currentIndex >= this.listOfRegisters.size()) {
                this.currentIndex = this.listOfRegisters.size() - 1;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void remove(int index) {
        if (index < 0 || index >= this.listOfRegisters.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.listOfRegisters.remove(index);
    }

    @Override
    public Iterator<RegisterHandler> iterator() {
        this.reset();
        return this.listOfRegisters.iterator();
    }

    @Override
    public void handleRegisterActionRequestEvent(EventObject sender, IDspRegister register, EnumRegisterRequestType registerRequestType, boolean isBlocking) {
        switch (registerRequestType) {
            case READ_REGISTER: {
                this.regHdlr_OnDspRegisterReadRequestEvent(sender, register, isBlocking);
                break;
            }
            case WRITE_REGISTER: {
                this.regHdlr_OnDspRegisterWriteRequestEvent(sender, register, isBlocking);
            }
        }
    }

    @Override
    public void handleMemMappedRegisterActionRequestEvent(EventObject sender, IDspMemory memoryMappedRegister, EnumRegisterRequestType registerRequestType, boolean isBlocking) {
        switch (registerRequestType) {
            case READ_REGISTER: {
                this.regHdlr_OnMemoryMappedReadRequestEvent(sender, memoryMappedRegister, isBlocking);
                break;
            }
            case WRITE_REGISTER: {
                this.regHdlr_OnMemoryMappedWriteRequestEvent(sender, memoryMappedRegister, isBlocking);
            }
        }
    }

    private void regHdlr_OnDspRegisterReadRequestEvent(EventObject sender, IDspRegister dspRegisterObj, boolean isBlocking) {
        RegisterRequestDescriptor req = (RegisterRequestDescriptor)this.registerAccessRequestQueue.getRequestDescriptorFactory().createInstance();
        RegisterHandler regHdlr = (RegisterHandler)sender.getSource();
        this.registerAccessRequestQueue.addRequest(req, isBlocking);
        req.config(regHdlr, dspRegisterObj, regHdlr.getAdrs(), regHdlr.getNumMAUSperRegister(), regHdlr.getRegisterId(), EnumRegisterRequestType.READ_REGISTER, EnumStringFormatStyle.C_STYLE_HEX, EnumDspValueType.DSP_LONG, regHdlr.getMemoryPageNumber(), 0, (short)0, null, regHdlr.getName(), EnumMemoryViews.DONT_CARE, regHdlr, null);
        if (req != null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("RegHdlr " + regHdlr.getName() + ": registerAccessRequestDescriptor created and configured: " + req.toString() + "\n" + this.registerAccessRequestQueue.getRequestDescriptorFactory().getStatus(), "RegisterList.regHdlr_onReadRequestEvent", this.target.getInfo());
        }
    }

    private synchronized void regHdlr_OnMemoryMappedReadRequestEvent(EventObject sender, IDspMemory memoryMappedRegister, boolean isBlocking) {
        MemoryRequestDescriptor req = (MemoryRequestDescriptor)this.targetAccessRequestQueue.getRequestDescriptorFactory().createInstance();
        RegisterHandler regHdlr = (RegisterHandler)sender.getSource();
        this.targetAccessRequestQueue.addRequest(req, isBlocking);
        req.config(regHdlr, EnumMemoryRequestTypes.READ, EnumStringFormatStyle.C_STYLE_HEX, EnumDspValueType.DSP_LONG, regHdlr.getMemoryPageNumber(), 0, (short)0, null, regHdlr.getAdrs(), regHdlr.getLengthInMAUs(), EnumMemoryViews.DONT_CARE, regHdlr, memoryMappedRegister);
        if (req != null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.TRANSACTIONS)) {
            MemoryServerTrace.logTransaction("RegHdlr " + regHdlr.getName() + ": targetAccessRequestDescriptor created and configured: " + req.toString() + "\n" + this.targetAccessRequestQueue.getRequestDescriptorFactory().getStatus(), "RegisterList.regHdlr_onMemoryMappedReadRequestEvent", this.target.getInfo());
        }
    }

    private synchronized void regHdlr_OnDspRegisterWriteRequestEvent(EventObject sender, IDspRegister dspRegisterObj, boolean isBlocking) {
        RegisterRequestDescriptor req = (RegisterRequestDescriptor)this.registerAccessRequestQueue.getRequestDescriptorFactory().createInstance();
        RegisterHandler regHdlr = (RegisterHandler)sender.getSource();
        this.registerAccessRequestQueue.addRequest(req, isBlocking);
        req.config(regHdlr, dspRegisterObj, regHdlr.getAdrs(), regHdlr.getNumMAUSperRegister(), regHdlr.getRegisterId(), EnumRegisterRequestType.WRITE_REGISTER, EnumStringFormatStyle.C_STYLE_HEX, EnumDspValueType.DSP_LONG, regHdlr.getMemoryPageNumber(), 0, (short)0, null, regHdlr.getName(), EnumMemoryViews.DONT_CARE, regHdlr, null);
        if (req != null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("RegHdlr " + regHdlr.getName() + ": targetAccessRequestDescriptor created and configured: " + req.toString() + "\n" + this.targetAccessRequestQueue.getRequestDescriptorFactory().getStatus(), "RegisterList.regHdlr_onWriteRequestEvent", this.target.getInfo());
        }
    }

    private void regHdlr_OnMemoryMappedWriteRequestEvent(EventObject sender, IDspMemory memoryMappedRegister, boolean isBlocking) {
        MemoryRequestDescriptor req = (MemoryRequestDescriptor)this.targetAccessRequestQueue.getRequestDescriptorFactory().createInstance();
        RegisterHandler regHdlr = (RegisterHandler)sender.getSource();
        this.targetAccessRequestQueue.addRequest(req, isBlocking);
        req.config(regHdlr, EnumMemoryRequestTypes.WRITE, EnumStringFormatStyle.C_STYLE_HEX, EnumDspValueType.DSP_LONG, regHdlr.getMemoryPageNumber(), 0, (short)0, null, regHdlr.getAdrs(), regHdlr.getLengthInMAUs(), EnumMemoryViews.DONT_CARE, regHdlr, memoryMappedRegister);
        if (req != null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("RegHdlr " + regHdlr.getName() + ": targetAccessRequestDescriptor created and configured: " + req.toString() + "\n" + this.targetAccessRequestQueue.getRequestDescriptorFactory().getStatus(), "RegisterList.regHdlr_onMemoryMappedWriteRequestEvent", this.target.getInfo());
        }
    }

    public void onRestoreRegisterContextValuesCompleted(EventArgs e) {
        if (this.onRestoreRegisterContextValuesComplete != null) {
            this.onRestoreRegisterContextValuesComplete.raise(e);
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("EventHandler is Null, could not raise event.", "RegisterList.onRestoreRegisterContextValuesCompleted", this.target.getInfo());
        }
    }

    @Override
    public void handleRegisterListReadCompleteEvent(EventObject sender) {
        RegisterHandler regHdlr = (RegisterHandler)sender.getSource();
        regHdlr.onRegisterListReadCompleteEvent.removeListener(this);
        if (this.isOnlyReadMemoryAnalysisRegisters) {
            this.isOnlyReadMemoryAnalysisRegisters = false;
        } else if (this.onGetRegisterContextValuesComplete != null) {
            this.onGetRegisterContextValuesComplete.raise();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        this.dispose(true);
    }

    public synchronized void dispose(boolean disposing) {
        if (!this.disposed && disposing) {
            try {
                if (this.target != null) {
                    this.target.getEventHandler().removeEventListener(this);
                }
                this.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.disposed = true;
    }

    public void acquire() {
    }
}

