/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumDspValueType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumMemoryViews;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTargetType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.ccstudio.debug.memoryserver.target.TargetProcessorId;
import com.ti.ccstudio.debug.memoryserver.util.UInt63;
import com.ti.ccstudio.debug.memoryserver.xml.XmlDeviceInfoHandler;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspUser;
import com.ti.debug.engine.IDspValue;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;

public class TargetDeviceInfo
implements ITargetDeviceInfo,
IDisposable {
    private IDspUser dspUser = null;
    private TargetHandler owner = null;
    private IDspTask dspTask;
    private XmlDeviceInfoHandler xmlDeviceInfoHandler;
    private boolean isNonDebuggableDevice = false;
    private boolean isNoMemoryDevice = false;
    protected String memoryServerXmlPath;
    protected String xmlDeviceDescriptionFileName;
    protected ArrayList<String> memoryPageNames = null;
    private long targetIsaId;
    private long targetProcessorId = 0L;
    protected String strTargetProcessorId;
    protected String strCoreId;
    private int coreNumber = 0;
    protected String strTargetIsaXId;
    private String strTargetIsaXXId;
    protected EnumTargetType targetTypeId;
    protected short numMemoryPages = 0;
    private int minNumMausPerMemoryRead = 1;
    private volatile boolean disposed = false;

    public TargetDeviceInfo(TargetHandler targetHandler, IDspTask dspTask, IDspUser dspUser, String memoryServerXmlPath) {
        this.owner = targetHandler;
        this.dspTask = dspTask;
        this.dspUser = dspUser;
        this.memoryServerXmlPath = memoryServerXmlPath;
        this.memoryPageNames = new ArrayList();
        this.getTargetInfo();
    }

    public TargetDeviceInfo(TargetHandler targetHandler, EnumTargetType targetType, long processorId, String memoryServerXmlDirectoryPath) {
        this.owner = targetHandler;
        this.memoryPageNames = new ArrayList();
        this.targetTypeId = targetType;
        this.setMemoryServerXmlPath(memoryServerXmlDirectoryPath);
        this.setTargetProcessorId(processorId);
        this.xmlDeviceDescriptionFileName = this.getXmlDeviceDescriptionFileName(this.memoryServerXmlPath);
    }

    @Override
    public void init() {
        this.getTargetInfoFromXmlFile();
        this.config(this.dspTask, this.dspUser);
    }

    public TargetHandler getOwner() {
        if (this.owner == null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("Attempting to use TargetDeviceInfo without first calling TargetHdlr.init() to complete construction", "TargetDeviceInfo.getOwner", null);
        }
        return this.owner;
    }

    public IDspTask getDspTask() {
        return this.dspTask;
    }

    @Override
    public XmlDeviceInfoHandler getXmlDeviceInfoHandler() {
        return this.xmlDeviceInfoHandler;
    }

    public boolean isNonDebuggableDevice() {
        return this.isNonDebuggableDevice;
    }

    public void setIsNonDebuggableDevice(boolean value) {
        this.isNonDebuggableDevice = value;
    }

    public boolean isNoMemoryDevice() {
        return this.isNoMemoryDevice;
    }

    public void setIsNoMemoryDevice(boolean value) {
        this.isNoMemoryDevice = value;
    }

    @Override
    public String getMemoryServerXmlPath() {
        return this.memoryServerXmlPath;
    }

    public void setMemoryServerXmlPath(String value) {
        this.memoryServerXmlPath = value.replace("%20", " ");
        if (!this.memoryServerXmlPath.endsWith(File.separator)) {
            this.memoryServerXmlPath = this.memoryServerXmlPath + File.separator;
        }
    }

    @Override
    public String getXmlDeviceDescriptionFileName() {
        return this.xmlDeviceDescriptionFileName;
    }

    @Override
    public void setXmlDeviceDescriptionFileName(String value) {
        this.xmlDeviceDescriptionFileName = value;
        if (value.indexOf(File.separator) < 0) {
            this.xmlDeviceDescriptionFileName = this.memoryServerXmlPath + value;
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo("setting Xml file to " + value, "TargetDeviceInfo.setXmlDeviceDescriptionFileName", this);
        }
    }

    @Override
    public ArrayList<String> getMemoryPageNames() {
        return this.memoryPageNames;
    }

    public String getMemoryPageName(int pageNumber) {
        if (pageNumber < 0 || pageNumber >= this.memoryPageNames.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.memoryPageNames.get(pageNumber);
    }

    public long getTargetIsaId() {
        return this.targetIsaId;
    }

    public boolean isARMdevice() {
        boolean result = false;
        if (this.strTargetIsaXXId.startsWith("TMS4")) {
            result = true;
        }
        return result;
    }

    @Override
    public long getTargetProcessorId() {
        return this.targetProcessorId;
    }

    public void setTargetProcessorId(long value) {
        this.targetProcessorId = value;
        TargetProcessorId procId = new TargetProcessorId(value, this.targetTypeId, this.isNoMemoryDevice);
        if (procId != null) {
            this.strTargetProcessorId = procId.getStrTargetProcessorId();
            this.strTargetIsaXId = procId.getStrTargetIsaXId();
            this.strTargetIsaXXId = procId.getStrTargetIsaXXId();
            this.strCoreId = this.strTargetProcessorId;
            int index = 0;
            if (this.strCoreId != null) {
                this.strCoreId.indexOf("TMS320");
            }
            if (index >= 0) {
                this.strCoreId = this.strCoreId.substring(6, this.strCoreId.length());
            }
            this.targetIsaId = procId.getTargetIsaId();
        }
        this.xmlDeviceDescriptionFileName = this.getXmlDeviceDescriptionFileName(this.memoryServerXmlPath);
    }

    @Override
    public String getStrTargetProcessorId() {
        return this.strTargetProcessorId;
    }

    @Override
    public String getStrCoreId() {
        return this.strCoreId + "_" + this.getStrCoreNumber();
    }

    public void setCoreNumber(int value) {
        this.coreNumber = value;
    }

    public int getCoreNumber() {
        return this.coreNumber;
    }

    public String getStrCoreNumber() {
        return Integer.toString(this.coreNumber);
    }

    @Override
    public String getStrTargetDescription() {
        return this.getStrTargetProcessorId() + " (" + this.targetTypeId.toString() + ")";
    }

    @Override
    public String getStrTargetIsaXId() {
        return this.strTargetIsaXId;
    }

    @Override
    public String getStrTargetIsaXXId() {
        return this.strTargetIsaXXId;
    }

    @Override
    public EnumTargetType getTargetTypeId() {
        return this.targetTypeId;
    }

    @Override
    public String getStrTargetTypeId() {
        return this.targetTypeId.toString();
    }

    @Override
    public short getNumMemoryPages() {
        return this.numMemoryPages;
    }

    public boolean isMemoryColoringSupported() {
        boolean result = false;
        if (this.xmlDeviceInfoHandler != null) {
            result = this.xmlDeviceInfoHandler.isMemoryLevelVisibilitySupported();
        }
        return result;
    }

    public boolean isAdrsSpecificErrorInfoSupported() {
        boolean result = false;
        if (this.xmlDeviceInfoHandler != null) {
            result = this.xmlDeviceInfoHandler.isGTI_GetMemWithStatSupported();
        }
        return result;
    }

    public void config(IDspTask refDspTask, IDspUser refDspUser) {
        block2: {
            this.dspTask = refDspTask;
            this.dspUser = refDspUser;
            try {
                this.getTargetInfo();
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block2;
                MemoryServerTrace.logException(e.getMessage(), "TargetDeviceInfo.config", e, null);
            }
        }
    }

    protected synchronized void getTargetInfoFromXmlFile() {
        if (this.xmlDeviceInfoHandler == null || this.xmlDeviceInfoHandler.getXmlFileName().compareTo(this.xmlDeviceDescriptionFileName) != 0) {
            if (this.xmlDeviceInfoHandler != null) {
                this.xmlDeviceInfoHandler.dispose();
            }
            this.xmlDeviceInfoHandler = new XmlDeviceInfoHandler(this.xmlDeviceDescriptionFileName, false, this.owner);
        }
    }

    public String getXmlDeviceDescriptionFileName(String memoryServerXmlPath) {
        File directory;
        String path = memoryServerXmlPath;
        String filename = "";
        String suffix = "";
        boolean found = false;
        int maxNumAttempts = 1;
        switch (this.targetTypeId) {
            case SIMULATOR: {
                suffix = "sim";
                maxNumAttempts = 2;
                break;
            }
            default: {
                suffix = "";
                maxNumAttempts = 1;
            }
        }
        boolean use645X = false;
        if (this.strTargetIsaXXId.compareToIgnoreCase("TMS320C64XX") == 0 && !this.owner.isDisconnected() && this.dspTask != null && this.dspTask.capableCacheTagRamReader()) {
            use645X = true;
        }
        if (!(directory = new File(path)).exists()) {
            path = "";
        } else {
            for (int numLoops = 0; !found && numLoops < maxNumAttempts; ++numLoops) {
                filename = path + this.strTargetProcessorId + suffix + ".xml";
                if (new File(filename).exists()) {
                    found = true;
                    break;
                }
                filename = path + this.strTargetIsaXId + suffix + ".xml";
                if (new File(filename).exists()) {
                    found = true;
                    break;
                }
                filename = !use645X ? path + this.strTargetIsaXXId + suffix + ".xml" : path + "TMS320C645X" + suffix + ".xml";
                if (new File(filename).exists()) {
                    found = true;
                    break;
                }
                suffix = "";
            }
            if (!found) {
                filename = "";
            }
        }
        return filename;
    }

    @Override
    public boolean isMemoryPageNumberValid(short memoryPageNumber) {
        boolean retval = false;
        if (memoryPageNumber >= 0 && memoryPageNumber < this.numMemoryPages) {
            retval = true;
        }
        return retval;
    }

    private void getTargetInfo() {
        if (this.dspUser != null) {
            try {
                this.targetTypeId = EnumTargetType.fromOrdinal(this.dspUser.getTargetType());
            }
            catch (Exception e) {
                this.targetTypeId = EnumTargetType.EMULATOR;
            }
            this.setTargetProcessorId(this.dspUser.getProcessorID());
            this.numMemoryPages = this.dspUser.numberOfMemoryPages();
            for (short i = 0; i < this.numMemoryPages; i = (short)(i + 1)) {
                this.memoryPageNames.add(this.dspUser.nameOfMemoryPage(i));
            }
        }
    }

    @Override
    public long getMinAdrsInMemoryPage(short pageNumber) {
        long retval = 0L;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExtendedAddressingSupported() {
        boolean result = false;
        if (this.dspUser != null) {
            IDspValue dspTempAddress = null;
            try {
                dspTempAddress = this.dspUser.createDspValue(EnumDspValueType.DSP_FAR_POINTER.getInt(), 0);
                if (dspTempAddress.sizeOf() > 0) {
                    result = true;
                }
            }
            finally {
                if (dspTempAddress != null && !dspTempAddress.isDisposed()) {
                    dspTempAddress.dispose();
                }
            }
        }
        return result;
    }

    @Override
    public long getMaxAdrsInMemoryPage(short memoryPageNumber) {
        return this.getMaxAdrsInMemoryPage(memoryPageNumber, EnumMemoryViews.CPU_MEMORY_VIEW);
    }

    @Override
    public long getMaxAdrsInMemoryPage(short pageNumber, EnumMemoryViews view) {
        int adrsBusWidth = this.getMaxAddressBusWidth(pageNumber, view);
        BigInteger biMaxAdrs = new BigInteger("2");
        biMaxAdrs = biMaxAdrs.pow(adrsBusWidth);
        long maxAdrs = biMaxAdrs.longValue();
        return --maxAdrs;
    }

    @Override
    public int getMaxAddressBusWidth(short pageNumber, EnumMemoryViews view) {
        int adrsBusWidth = 0;
        if (view == EnumMemoryViews.PHYSICAL_MEMORY_VIEW) {
            adrsBusWidth = this.owner.getMemLevelInfoHdlr().getMaxPhysicalMemoryWidth();
        } else if (view == EnumMemoryViews.STAGE2_PHYSICAL_MEMORY_VIEW) {
            adrsBusWidth = this.owner.getMemLevelInfoHdlr().getStage2MaxPhysicalMemoryWidth();
        }
        if (adrsBusWidth == 0) {
            adrsBusWidth = 32;
            if (this.dspUser != null) {
                try {
                    adrsBusWidth = this.dspUser.addrSizeInBits(pageNumber);
                }
                catch (Exception ex) {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logException("DspUser.get_AddrSizeInBits threw exception", "TargetDeviceInfo.getMaxAdrsInMemoryPage", ex, this);
                    }
                }
            } else if (this.numMemoryPages > 1) {
                adrsBusWidth = 16;
            }
        }
        return adrsBusWidth;
    }

    public long getLengthOfMemoryPageInMaus(short pageNumber) {
        int adrsBusWidth;
        block3: {
            adrsBusWidth = 32;
            if (this.dspUser != null) {
                try {
                    adrsBusWidth = this.dspUser.addrSizeInBits(pageNumber);
                }
                catch (Exception ex) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block3;
                    MemoryServerTrace.logException("DspUser.get_AddrSizeInBits threw exception", "TargetDeviceInfo.GetLengthOfMemoryPageInMaus", ex, this);
                }
            }
        }
        long length = (long)Math.pow(2.0, adrsBusWidth);
        return length;
    }

    public long getLengthOfMemoryPageInBytes(short pageNumber) {
        int adrsBusWidth;
        block3: {
            adrsBusWidth = 32;
            if (this.dspUser != null) {
                try {
                    adrsBusWidth = this.dspUser.addrSizeInBits(pageNumber);
                }
                catch (Exception ex) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block3;
                    MemoryServerTrace.logException("DspUser.get_AddrSizeInBits threw exception", "TargetDeviceInfo.getLengthOfMemoryPageInBytes", ex, this);
                }
            }
        }
        long length = (long)Math.pow(2.0, adrsBusWidth + this.getNumBytesPerMauInMemoryPage(pageNumber));
        return length;
    }

    @Override
    public int getMemoryPageDataWidth(short pageNumber) {
        int result;
        block3: {
            result = 32;
            if (this.dspUser != null) {
                try {
                    result = this.dspUser.wordSizeInBits(pageNumber);
                }
                catch (Exception ex) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block3;
                    MemoryServerTrace.logException("DspUser.get_WordSizeInBits threw exception", "TargetDeviceInfo.getMemoryPageDataWidth", ex, this);
                }
            }
        }
        return result;
    }

    @Override
    public long getNumMausInAddressRange(long startAdrs, long endAdrs, short pageNumber) {
        long result = 0L;
        UInt63 u32startAdrs = new UInt63(startAdrs);
        UInt63 u32endAdrs = new UInt63(endAdrs);
        if (u32endAdrs.getValue() >= u32startAdrs.getValue()) {
            result = u32endAdrs.getValue() - u32startAdrs.getValue() + 1L;
        }
        return result;
    }

    public short getNumBytesPerMauInMemoryPage(short pageNumber) {
        short retval;
        block3: {
            retval = 4;
            if (this.dspUser != null) {
                try {
                    retval = (short)(this.dspUser.addressableDataSizeInBits(pageNumber) >> 3);
                }
                catch (Exception ex) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block3;
                    MemoryServerTrace.logException("DspUser.get_AddressableDataSizeInBits threw exception", "TargetDeviceInfo.GetNumBytesPerMauInMemoryPage", ex, this);
                }
            }
        }
        return retval;
    }

    @Override
    public int getMinNumMausPerMemoryRead() {
        if (this.dspUser != null && this.dspUser.getMapOn()) {
            return 1;
        }
        return this.minNumMausPerMemoryRead;
    }

    @Override
    public void setMinNumMausPerMemoryRead(int value) {
        this.minNumMausPerMemoryRead = value;
    }

    @Override
    public long getEndAdrsInRange(long startAdrs, long numMaus, short pageNumber) {
        UInt63 u32 = new UInt63(startAdrs);
        return u32.getValue() + numMaus - 1L;
    }

    @Override
    public long getNextAdrs(long startAdrs, int sizeOfDataTypeInMAUs, short pageNumber) {
        int adrsIncr = this.getAdrsIncrementInMAUs(sizeOfDataTypeInMAUs, pageNumber);
        UInt63 u32 = new UInt63(startAdrs);
        return u32.getValue() + (long)adrsIncr;
    }

    public int getAdrsIncrementInMAUs(int sizeOfDataTypeInMAUs, short pageNumber) {
        int adrsIncr = sizeOfDataTypeInMAUs;
        if (sizeOfDataTypeInMAUs > 8 && sizeOfDataTypeInMAUs < 16) {
            adrsIncr = 16;
        }
        if (sizeOfDataTypeInMAUs > 4 && sizeOfDataTypeInMAUs < 8) {
            adrsIncr = 8;
        }
        if (sizeOfDataTypeInMAUs == 3) {
            adrsIncr = 4;
        }
        return adrsIncr;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void dispose() {
        this.dispose(true);
    }

    public synchronized void dispose(boolean disposing) {
        if (!this.disposed && disposing) {
            try {
                if (this.xmlDeviceInfoHandler != null && !this.xmlDeviceInfoHandler.isDisposed()) {
                    this.xmlDeviceInfoHandler.dispose();
                }
                this.xmlDeviceInfoHandler = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.disposed = true;
    }

    public void acquire() {
    }
}

