/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTargetRunningStatus;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetEventHandler;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetHandler;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemLevelInfoHdlr;
import com.ti.ccstudio.debug.memoryserver.target.TargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.target.TargetEventManager;
import com.ti.debug.engine.IDspTask;
import com.ti.debug.engine.IDspUser;

public class TargetHandler
implements ITargetHandler,
IDisposable {
    private IDspTask dspTask;
    public TargetDeviceInfo info = null;
    private IDspUser private_dspUser;
    private MemLevelInfoHdlr memLevelInfoHdlr = null;
    private String taskName = "";
    private String boardName;
    private boolean disconnected = true;
    protected String memoryServerXmlPath;
    protected volatile ITargetEventHandler eventHandler = null;
    private volatile boolean isDisposed = false;

    public TargetHandler(String boardName, IDspTask refDspTask, String memoryServerXmlPath) {
        this.boardName = boardName;
        this.memoryServerXmlPath = memoryServerXmlPath;
        this.dspTask = refDspTask;
        if (this.dspTask != null) {
            this.private_dspUser = this.dspTask.createDspUser();
            this.taskName = this.dspTask.getFullPathName();
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("TargetHandler created for " + this.taskName, "TargetHandler constructor", null);
            }
        } else {
            this.private_dspUser = null;
            this.taskName = "TEST_" + boardName;
            this.disconnected = false;
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("TargetHandler created for null dspTask.", "TargetHandler constructor", null);
            }
        }
    }

    public void init() {
        if (this.eventHandler != null && !this.eventHandler.isDisposed()) {
            this.eventHandler.dispose();
            this.eventHandler = null;
        }
        if (this.memLevelInfoHdlr != null && !this.memLevelInfoHdlr.isDisposed()) {
            this.memLevelInfoHdlr.dispose();
            this.memLevelInfoHdlr = null;
        }
        if (this.info != null && !this.info.isDisposed()) {
            this.info.dispose();
            this.info = null;
        }
        this.info = new TargetDeviceInfo(this, this.dspTask, this.getDspUser(), this.memoryServerXmlPath);
        this.info.init();
        if (this.dspTask != null) {
            if (!this.dspTask.getTargetType().startsWith("ICEPick")) {
                this.info.setIsNoMemoryDevice(false);
            } else {
                this.info.setIsNoMemoryDevice(true);
            }
        }
        this.eventHandler = new TargetEventManager(this);
        this.memLevelInfoHdlr = new MemLevelInfoHdlr(this, this.getDspUser());
        this.refreshDisconnectedState();
        this.memLevelInfoHdlr.init();
    }

    public IDspTask getDspTask() {
        return this.dspTask;
    }

    public void setDspTask(IDspTask value) {
        if (this.private_dspUser != null && !this.private_dspUser.isDisposed()) {
            this.private_dspUser.dispose();
            this.private_dspUser = null;
        }
        if (this.dspTask != null && !this.dspTask.isDisposed()) {
            this.dspTask.dispose();
            this.dspTask = null;
        }
        this.dspTask = value;
        this.private_dspUser = this.dspTask.createDspUser();
        this.info.config(this.dspTask, this.private_dspUser);
        this.init();
    }

    @Override
    public ITargetDeviceInfo getInfo() {
        if (this.info == null && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("TargetHandler.getInfo() called before TargetHandler.init(). MUST call init() to complete construction!!", "TargetHandler.getInfo()", null);
        }
        return this.info;
    }

    public IDspUser getDspUser() {
        IDspUser result = null;
        if (!this.isDisposed) {
            if ((this.private_dspUser == null || this.private_dspUser.isDisposed()) && this.dspTask != null && !this.dspTask.isDisposed()) {
                this.private_dspUser = this.dspTask.createDspUser();
            }
            result = this.private_dspUser;
        }
        return result;
    }

    public MemLevelInfoHdlr getMemLevelInfoHdlr() {
        return this.memLevelInfoHdlr;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String value) {
        this.taskName = value;
    }

    public String getBoardName() {
        return this.boardName;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public void setIsDisconnected(boolean value) {
        this.disconnected = value;
    }

    public boolean isMemoryReadAllowed() {
        boolean result;
        boolean bl = result = !this.isDisposed;
        if (result) {
            result = this.isDisconnected() ? false : !this.info.isNoMemoryDevice();
        }
        return result;
    }

    public boolean isMemoryWriteAllowed() {
        boolean result;
        boolean bl = result = !this.isDisposed;
        if (result) {
            result = this.isDisconnected() ? false : !this.info.isNoMemoryDevice();
        }
        return result;
    }

    public boolean isCExprEvalAllowed() {
        boolean result;
        boolean bl = result = !this.isDisposed;
        if (result) {
            result = !this.isDisconnected();
        }
        return result;
    }

    public boolean isRegisterReadAllowed() {
        boolean result;
        boolean bl = result = !this.isDisposed;
        if (result) {
            result = !this.isDisconnected();
        }
        return result;
    }

    public boolean isRegisterWriteAllowed() {
        boolean result;
        boolean bl = result = !this.isDisposed;
        if (result) {
            result = !this.isDisconnected();
        }
        return result;
    }

    public boolean isRealTimeModeEnabled() {
        boolean result = false;
        return result;
    }

    public String getMemoryServerXmlPath() {
        return this.memoryServerXmlPath;
    }

    public void refreshDisconnectedState() {
        this.disconnected = this.getDspUser() != null ? this.getDspUser().connectionStatus() != 0 : true;
    }

    public boolean isRunning() {
        boolean result = false;
        EnumTargetRunningStatus status = EnumTargetRunningStatus.TASK_HALTED;
        boolean[] vbPowered = new boolean[]{true};
        boolean[] vbSecured = new boolean[]{true};
        if (this.getDspUser() != null) {
            status = EnumTargetRunningStatus.fromInt(this.getDspUser().getTaskRunningState3(vbPowered, vbSecured));
        }
        result = false;
        switch (status) {
            case TASK_FREE_RUNNING: {
                result = true;
            }
            case TASK_LOW_POWER_RUNNING: {
                result = true;
            }
            case TASK_RUNNING: {
                result = true;
            }
        }
        return result;
    }

    public String toString() {
        String retval = "Target[" + this.getTaskName() + "]";
        return retval;
    }

    @Override
    public ITargetEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public void dispose() {
        this.dispose(true);
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    public synchronized void dispose(boolean disposing) {
        if (!this.isDisposed && disposing) {
            try {
                if (this.eventHandler != null && !this.eventHandler.isDisposed()) {
                    this.eventHandler.dispose();
                    this.eventHandler = null;
                }
                if (this.memLevelInfoHdlr != null && !this.memLevelInfoHdlr.isDisposed()) {
                    this.memLevelInfoHdlr.dispose();
                    this.memLevelInfoHdlr = null;
                }
                if (this.info != null && !this.info.isDisposed()) {
                    this.info.dispose();
                    this.info = null;
                }
                if (this.private_dspUser != null && !this.private_dspUser.isDisposed()) {
                    this.private_dspUser.dispose();
                }
                this.private_dspUser = null;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.isDisposed = true;
    }
}

