/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.target;

import com.ti.ccstudio.debug.memoryserver.enums.EnumTargetType;

public class TargetProcessorId {
    private long targetProcessorId;
    private String strTargetProcessorId;
    private String strTargetIsaXId;
    private String strTargetIsaXXId;
    private long targetIsaId = 0L;

    public TargetProcessorId(long processorId, EnumTargetType targetType, boolean isNoMemoryDevice) {
        this.targetProcessorId = processorId;
        switch (targetType) {
            case EMULATOR: 
            case SIMULATOR: 
            case DSK: 
            case RESERVED_TYPE3: 
            case RESERVED_TYPE4: 
            case NEW_TARGET_TYPE: {
                this.strTargetProcessorId = this.decodeTargetProcessorId(this.targetProcessorId, false);
                this.strTargetIsaXId = this.strTargetProcessorId.substring(0, this.strTargetProcessorId.length() - 1) + "X";
                this.strTargetIsaXXId = this.decodeTargetProcessorId(this.targetProcessorId, true);
                break;
            }
            case NON_DEBUGGABLE_DEVICE: {
                String value = Long.toHexString(this.targetProcessorId);
                this.strTargetProcessorId = !isNoMemoryDevice ? "DAP_" + value : "ICEPICK_" + value;
                this.strTargetIsaXId = this.strTargetProcessorId;
                this.strTargetIsaXXId = this.strTargetProcessorId;
            }
        }
    }

    public String getStrTargetProcessorId() {
        return this.strTargetProcessorId;
    }

    public String getStrTargetIsaXId() {
        return this.strTargetIsaXId;
    }

    public String getStrTargetIsaXXId() {
        return this.strTargetIsaXXId;
    }

    public long getTargetIsaId() {
        return this.targetIsaId;
    }

    private String decodeTargetProcessorId(long processorId, boolean XXformat) {
        String result = "";
        long procId = processorId;
        long family = procId >> 22 & 0x3FFL;
        String strFamily = Long.toString(family, 10);
        this.targetIsaId = procId >> 10 & 0xFFFL;
        String strSubFamily = Long.toHexString(this.targetIsaId).toUpperCase();
        long revision = procId >> 3 & 0x7FL;
        String strRevision = "";
        if (revision <= 99L && !XXformat) {
            strRevision = Long.toString(revision, 10);
            if (revision < 10L && (this.targetIsaId >= 84L || this.targetIsaId == 12L && family == 470L)) {
                strRevision = "0" + strRevision;
            }
        } else {
            strRevision = XXformat || revision > 119L ? "XX" : (revision <= 109L ? Long.toString(revision -= 100L, 10) + "X" : "X" + Long.toString(revision -= 110L, 10));
        }
        result = strFamily.compareToIgnoreCase("470") == 0 ? "TMS" + strFamily + "R" + strSubFamily + strRevision : "TMS" + strFamily + "C" + strSubFamily + strRevision;
        return result;
    }
}

