/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.util;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;

public class BaseConverter {
    public static boolean isHex(String value) {
        value = value.toLowerCase();
        if ((value = value.trim()).length() < 2 || value.charAt(0) != '0' || value.charAt(1) != 'x') {
            return false;
        }
        value = value.substring(2);
        try {
            Long.parseLong(value, 16);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isDec(String value) {
        value = value.toLowerCase();
        if ((value = value.trim()).length() < 1 || value.charAt(0) == '0') {
            return false;
        }
        try {
            Long.parseLong(value, 10);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isBin(String value) {
        value = value.toLowerCase();
        if ((value = value.trim()).length() < 1) {
            return false;
        }
        block3: for (int i = 0; i < value.length(); ++i) {
            char theValue = value.charAt(i);
            switch (theValue) {
                case '0': 
                case '1': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isOct(String value) {
        value = value.toLowerCase();
        if ((value = value.trim()).length() < 1 || value.charAt(0) != '0') {
            return false;
        }
        block3: for (int i = 1; i < value.length(); ++i) {
            char theValue = value.charAt(i);
            switch (theValue) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static String fromULongToHEXString(long value) {
        return "0x" + Long.toHexString(value);
    }

    public static String fromULongToTIHEXString(long value) {
        return Long.toHexString(value);
    }

    public static String fromULongToDECString(long value) {
        return Long.toString(value, 10);
    }

    public static String fromULongToOCTString(long value) {
        String ret = "";
        long remainder = value % 8L;
        for (long result = value / 8L; result > 0L; result /= 8L) {
            ret = Long.toString(remainder) + ret;
            remainder = result % 8L;
        }
        return Long.toString(remainder) + ret;
    }

    public static String fromULongToBINString(long value) {
        String ret = "";
        long remainder = value % 2L;
        for (long result = value / 2L; result > 0L; result /= 2L) {
            ret = Long.toString(remainder) + ret;
            remainder = result % 2L;
        }
        return Long.toString(remainder) + ret;
    }

    public static long fromCharStringToULong(String value) {
        long retValue;
        block3: {
            retValue = 0L;
            try {
                int length = value.length();
                for (int i = 0; i < length; ++i) {
                    char theValue = value.charAt(length - 1 - i);
                    retValue <<= 8 * i;
                    retValue += (long)((byte)theValue);
                }
            }
            catch (Exception e) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block3;
                MemoryServerTrace.logException(e.getMessage() + " [input string = " + value + "].", "BaseConverter.fromCharStringToULong", e, null);
            }
        }
        return retValue;
    }

    public static long fromBinStringToULong(String value) {
        long ret = Long.MIN_VALUE;
        if (BaseConverter.isBin(value)) {
            value = value.substring(0, value.length());
            long retValue = 0L;
            block4: for (int i = value.length() - 1; i >= 0; --i) {
                char theValue = value.charAt(i);
                switch (theValue) {
                    case '0': {
                        retValue += 0L * (long)Math.pow(2.0, value.length() - 1 - i);
                        continue block4;
                    }
                    case '1': {
                        retValue += 1L * (long)Math.pow(2.0, value.length() - 1 - i);
                        continue block4;
                    }
                }
            }
            ret = retValue;
        }
        return ret;
    }

    public static long fromOctStringToULong(String value) {
        long ret = Long.MIN_VALUE;
        if (BaseConverter.isOct(value)) {
            value = value.trim();
            long retValue = 0L;
            for (int i = value.length() - 1; i >= 0; --i) {
                String theValue = "";
                theValue = theValue + value.charAt(i);
                retValue += (long)Integer.parseInt(theValue) * (long)Math.pow(8.0, value.length() - 1 - i);
            }
            ret = retValue;
        }
        return ret;
    }
}

