/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.util;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumFactoryObjectStates;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IFactoryCreatedObject;
import com.ti.ccstudio.debug.memoryserver.interfaces.IFactoryObjectCreator;
import com.ti.ccstudio.debug.memoryserver.interfaces.IRecyclingFactory;
import com.ti.debug.engine.framework.IDisposable;
import java.util.Vector;

public class RecyclingFactory
implements IRecyclingFactory,
IDisposable {
    protected Vector<IFactoryCreatedObject> freeQueue = null;
    protected Vector<IFactoryCreatedObject> inUseQueue = null;
    protected String name = "";
    protected IFactoryObjectCreator factoryObjCreator = null;
    private volatile boolean disposed = false;

    public RecyclingFactory(String name, IFactoryObjectCreator factoryObjectCreator) {
        this.name = name;
        this.freeQueue = new Vector();
        this.inUseQueue = new Vector();
        this.factoryObjCreator = factoryObjectCreator;
    }

    public RecyclingFactory() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public synchronized IFactoryCreatedObject createInstance() {
        IFactoryCreatedObject instance;
        if (this.freeQueue.size() > 0) {
            instance = this.freeQueue.get(0);
            this.freeQueue.remove(instance);
            this.inUseQueue.add(instance);
        } else {
            instance = this.factoryObjCreator.createObject();
            instance.setFactoryObjectState(EnumFactoryObjectStates.CREATED);
            instance.setFactory(this);
            this.inUseQueue.add(instance);
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
            MemoryServerTrace.logLifecycle(instance.getFactoryObjectStatus(), this.name + " Factory.CreateInstance", null);
        }
        instance.setFactoryObjectState(EnumFactoryObjectStates.IN_USE);
        return instance;
    }

    @Override
    public void setFactoryObjectCreator(IFactoryObjectCreator value) {
        this.factoryObjCreator = value;
    }

    public String getStatus() {
        String status = this.name + ".freeQueue: ";
        for (IFactoryCreatedObject factoryObj : this.freeQueue) {
            status = status + factoryObj.getFactoryObjectId() + " ";
        }
        status = status + "\n" + this.name + ".inUse queue: ";
        for (IFactoryCreatedObject factoryObj : this.inUseQueue) {
            status = status + factoryObj.getFactoryObjectId() + " ";
        }
        return status;
    }

    public int getNumInUse() {
        int result = this.inUseQueue.size();
        return result;
    }

    @Override
    public synchronized void onRelease(IFactoryCreatedObject factoryObj) {
        if (this.inUseQueue.contains(factoryObj)) {
            this.inUseQueue.remove(factoryObj);
            this.freeQueue.add(factoryObj);
            factoryObj.setFactoryObjectState(EnumFactoryObjectStates.RECYCLED);
        } else if (!this.freeQueue.contains(factoryObj) && !this.disposed) {
            this.freeQueue.add(factoryObj);
            factoryObj.setFactoryObjectState(EnumFactoryObjectStates.RECYCLED);
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Factory object not in either freeQueue or inUseQueue. obj = :" + factoryObj.getFactoryObjectStatus() + "\n" + this.getStatus(), "RecyclingFactory.onRelease", null);
            }
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.OBJECT_LIFECYCLE)) {
            MemoryServerTrace.logLifecycle(this.getStatus(), "RecyclingFactory.onRelease", null);
        }
    }

    public void dispose() {
        this.dispose(true);
    }

    public synchronized void dispose(boolean disposing) {
        if (!this.disposed && disposing) {
            try {
                this.disposeAllObjects();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    protected synchronized void disposeAllObjects() {
        IFactoryCreatedObject factoryObj = null;
        while (this.freeQueue.size() > 0) {
            factoryObj = this.freeQueue.get(0);
            if (!factoryObj.isDisposed()) {
                factoryObj.dispose(this);
            }
            this.freeQueue.remove(0);
        }
        while (this.inUseQueue.size() > 0) {
            factoryObj = this.inUseQueue.get(0);
            if (!factoryObj.isDisposed()) {
                factoryObj.dispose(this);
            }
            this.inUseQueue.remove(0);
        }
    }

    public void acquire() {
    }
}

