/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.util;

import java.util.Date;

public class TimeStamp {
    private boolean isRunning = false;
    private long startTimeInMilliseconds = 0L;
    private long endTimeInMilliseconds = 0L;

    public TimeStamp() {
        this.reset();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void reset() {
        this.startTimeInMilliseconds = Long.MAX_VALUE & System.currentTimeMillis();
        this.isRunning = true;
    }

    public void completed() {
        this.endTimeInMilliseconds = Long.MAX_VALUE & System.currentTimeMillis();
        this.isRunning = false;
    }

    public long getStartTimeInMilliseconds() {
        return this.startTimeInMilliseconds;
    }

    public long getEndTimeInMilliseconds() {
        return this.endTimeInMilliseconds;
    }

    public long getElapsedTimeInMilliseconds() {
        long now = 0L;
        now = !this.isRunning ? this.endTimeInMilliseconds : Long.MAX_VALUE & System.currentTimeMillis();
        long elapsed = now - this.startTimeInMilliseconds;
        if (elapsed < 0L) {
            elapsed = now + (Long.MAX_VALUE - this.startTimeInMilliseconds);
        }
        return elapsed;
    }

    public String getElapsedTime() {
        String result = Integer.toString((int)this.getElapsedTimeInMilliseconds()) + " ms";
        return result;
    }

    public String getWallclockTime() {
        Date date = new Date();
        return date.toString();
    }
}

