/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.xml;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.target.RegisterDecoder;
import com.ti.ccstudio.debug.memoryserver.target.RegisterHandler;
import com.ti.ccstudio.debug.memoryserver.xml.DeviceXMLReader;
import com.ti.ccstudio.debug.memoryserver.xml.XmlDeviceInfoHandler;
import com.ti.debug.engine.framework.IDisposable;

public class DeviceIdHdlr
implements IDisposable {
    private RegisterHandler deviceIdRegHdlr = null;
    private RegisterDecoder deviceIdDecoder = null;
    private String xmlFileName = "";
    private boolean initComplete = false;
    private boolean isDisposed = false;

    public DeviceIdHdlr(XmlDeviceInfoHandler xmlDeviceInfoHdlr) {
        this.xmlFileName = xmlDeviceInfoHdlr.getXmlFileName();
        String deviceIdRegName = "";
        String deviceIdDecoderName = "";
        DeviceXMLReader.CoreInfoItem coreInfoItem = DeviceXMLReader.getInstance(xmlDeviceInfoHdlr.target.getMemoryServerXmlPath()).getCoreInfoItem(xmlDeviceInfoHdlr, xmlDeviceInfoHdlr.getPathToActiveDeviceCore());
        if (coreInfoItem != null) {
            deviceIdRegName = coreInfoItem.deviceId_configReg;
            deviceIdDecoderName = coreInfoItem.configReg;
        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
            MemoryServerTrace.logError("Failed to retrieve read DeviceId/DecoderName and DeviceId/ConfigReg from cache for XML file: " + this.xmlFileName, "DeviceIdHdlr contructor", xmlDeviceInfoHdlr.targetInfo);
        }
        if (deviceIdRegName.length() > 0 && deviceIdDecoderName.length() > 0) {
            this.deviceIdRegHdlr = xmlDeviceInfoHdlr.readRegisterInfoFromXmlFile(null, true, deviceIdRegName);
            this.deviceIdDecoder = xmlDeviceInfoHdlr.readDecoderInfoFromXmlFile(null, true, deviceIdDecoderName);
            if (this.deviceIdRegHdlr != null && this.deviceIdDecoder != null) {
                this.deviceIdRegHdlr.getListOfDecoders().add(this.deviceIdDecoder);
                this.deviceIdDecoder.setOwner(this.deviceIdRegHdlr);
            }
        }
    }

    public DeviceIdHdlr(RegisterHandler regHdlr, RegisterDecoder regDecoder) {
        this.deviceIdRegHdlr = regHdlr;
        this.deviceIdDecoder = regDecoder;
        this.xmlFileName = "";
        if (this.deviceIdDecoder != null && this.deviceIdDecoder.isAStringTable && regDecoder.getStringTable() != null) {
            this.xmlFileName = regDecoder.getStringTable().get(0);
        }
    }

    public RegisterHandler getDeviceIdRegHdlr() {
        return this.deviceIdRegHdlr;
    }

    public RegisterDecoder getDeviceIdDecoder() {
        return this.deviceIdDecoder;
    }

    public String getXmlFileName() {
        return this.xmlFileName;
    }

    public void setXmlFileName(String value) {
        this.xmlFileName = value;
    }

    public boolean isDeviceIdValidForThisTarget() {
        boolean result = false;
        if (this.deviceIdDecoder != null) {
            result = this.deviceIdDecoder.decode_Boolean();
        }
        return result;
    }

    public boolean getInitComplete() {
        return this.initComplete;
    }

    public void setInitComplete(boolean value) {
        this.initComplete = value;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            if (this.deviceIdRegHdlr != null && !this.deviceIdRegHdlr.isDisposed()) {
                this.deviceIdRegHdlr.dispose();
                this.deviceIdRegHdlr = null;
            }
        }
    }

    public void acquire() {
    }
}

