/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.xml;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.target.RegisterDecoder;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNavigator;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNodeIterator;
import com.ti.ccstudio.debug.memoryserver.xml.XmlDeviceInfoHandler;
import com.ti.ccstudio.debug.memoryserver.xml.XmlElement;
import com.ti.ccstudio.debug.memoryserver.xml.XmlHelper;
import com.ti.debug.engine.xpcom.Runtime;
import com.ti.utility.filesystem.FSUtil;
import com.ti.utility.filesystem.SWIGTYPE_p_FSUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class DeviceXMLReader {
    private static DeviceCache cacheOfDevices = new DeviceCache();
    private final String deviceCacheFilename = "/devicedb.cache";
    private static final String XML_ROOT_TAG = "/CodeComposer/CcsMemoryServer";
    private static DeviceXMLReader instance = null;

    public DeviceXMLReader() {
        new StoreDeviceCacheJob().run();
    }

    public static synchronized DeviceXMLReader getInstance(String memoryServerPath) {
        String path = FSUtil.FSUtil_Get_AppData_Dir((SWIGTYPE_p_FSUtil)Runtime.getFSUtil());
        if (instance == null) {
            instance = new DeviceXMLReader();
            instance.loadCachedDevices(path, true);
        }
        return instance;
    }

    public synchronized DeviceCacheItem getDeviceInfo(XmlDeviceInfoHandler xmlHandler) {
        return DeviceXMLReader.cacheOfDevices.getDeviceInfo(xmlHandler);
    }

    public synchronized TraceInfoItem getDeviceTraceInfo(XmlDeviceInfoHandler xmlHandler) {
        return DeviceXMLReader.cacheOfDevices.getDeviceTraceInfo(xmlHandler);
    }

    public synchronized Hashtable<String, CoreInfoItem> getCoreInfo(XmlDeviceInfoHandler xmlHandler) {
        return DeviceXMLReader.cacheOfDevices.getCoreInfo(xmlHandler);
    }

    public synchronized AddressSpaceInfo getAddressSpaceInfo(XmlDeviceInfoHandler xmlHandler, String addressSpacePath) {
        return DeviceXMLReader.cacheOfDevices.getAddressSpaceInfo(xmlHandler, addressSpacePath);
    }

    public synchronized RegisterInfo getRegisterInfo(XmlDeviceInfoHandler xmlHandler, String registerPath) {
        return DeviceXMLReader.cacheOfDevices.getRegisterInfo(xmlHandler, registerPath);
    }

    public synchronized DecoderInfo getDecoderInfo(XmlDeviceInfoHandler xmlHandler, String decoderPath) {
        return DeviceXMLReader.cacheOfDevices.getDecoderInfo(xmlHandler, decoderPath);
    }

    public synchronized CoreInfoItem getCoreInfoItem(XmlDeviceInfoHandler xmlHandler, String corePath) {
        return DeviceXMLReader.cacheOfDevices.getCoreInfoItem(xmlHandler, corePath);
    }

    public synchronized MemoryManagementInfoItem getMemoryManagementInfoItem(XmlDeviceInfoHandler xmlHandler, String path) {
        return DeviceXMLReader.cacheOfDevices.getMemoryManagementInfoItem(xmlHandler, path);
    }

    private synchronized void loadCachedDevices(String memoryServerPath, boolean doPurgeAfter) {
        String path = FSUtil.FSUtil_Get_AppData_Dir((SWIGTYPE_p_FSUtil)Runtime.getFSUtil());
        DeviceXMLReader.cacheOfDevices.loadCachedDevices(path + "/devicedb.cache", doPurgeAfter);
    }

    public synchronized void storeCachedDevices() {
        String path = FSUtil.FSUtil_Get_AppData_Dir((SWIGTYPE_p_FSUtil)Runtime.getFSUtil());
        if (path != null) {
            DeviceXMLReader.cacheOfDevices.storeCachedDevices(path + "/devicedb.cache");
        }
    }

    private class StoreDeviceCacheJob
    extends Thread {
        public StoreDeviceCacheJob() {
            super("Saving Device information");
            this.setPriority(5);
        }

        @Override
        public void run() {
            this.doRun();
        }

        public synchronized void doRun() {
            DeviceXMLReader.this.storeCachedDevices();
        }
    }

    public static class DeviceCache
    implements Serializable {
        private int dirtyCount = 0;
        private Object cacheLock = new Object();
        private Hashtable<String, DeviceCacheItem> cacheOfDeviceListsByFilename = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TraceInfoItem getDeviceTraceInfo(XmlDeviceInfoHandler xmlHandler) {
            TraceInfoItem traceInfo = null;
            Object object = this.cacheLock;
            synchronized (object) {
                DeviceCacheItem deviceInfo = this.getDeviceInfo(xmlHandler);
                if (deviceInfo != null) {
                    if (deviceInfo.traceInfoItem == null) {
                        deviceInfo.traceInfoItem = this.updateTraceInfo(xmlHandler);
                    }
                    traceInfo = deviceInfo.traceInfoItem;
                }
            }
            return traceInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Hashtable<String, MemoryManagementInfoItem> getMemoryManagementInfo(XmlDeviceInfoHandler xmlHandler) {
            Hashtable<String, MemoryManagementInfoItem> memoryManagementInfotems = null;
            Object object = this.cacheLock;
            synchronized (object) {
                DeviceCacheItem deviceInfo = this.getDeviceInfo(xmlHandler);
                if (deviceInfo != null) {
                    if (deviceInfo.memoryManagementInfoItems == null) {
                        deviceInfo.memoryManagementInfoItems = this.updateMemoryManagementInfo(xmlHandler);
                    }
                    memoryManagementInfotems = deviceInfo.memoryManagementInfoItems;
                }
            }
            return memoryManagementInfotems;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MemoryManagementInfoItem getMemoryManagementInfoItem(XmlDeviceInfoHandler xmlHandler, String path) {
            MemoryManagementInfoItem result = null;
            Object object = this.cacheLock;
            synchronized (object) {
                Hashtable<String, MemoryManagementInfoItem> memoryManagementInfoItems = cacheOfDevices.getMemoryManagementInfo(xmlHandler);
                if (memoryManagementInfoItems != null) {
                    result = memoryManagementInfoItems.get(path);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Hashtable<String, CoreInfoItem> getCoreInfo(XmlDeviceInfoHandler xmlHandler) {
            Hashtable<String, CoreInfoItem> coreInfotems = null;
            Object object = this.cacheLock;
            synchronized (object) {
                DeviceCacheItem deviceInfo = this.getDeviceInfo(xmlHandler);
                if (deviceInfo != null) {
                    if (deviceInfo.listOfCores == null) {
                        deviceInfo.listOfCores = this.updateCoreInfo(xmlHandler);
                    }
                    coreInfotems = deviceInfo.listOfCores;
                }
            }
            return coreInfotems;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoreInfoItem getCoreInfoItem(XmlDeviceInfoHandler xmlHandler, String corePath) {
            CoreInfoItem result = null;
            Object object = this.cacheLock;
            synchronized (object) {
                Hashtable<String, CoreInfoItem> coreInfoItems = cacheOfDevices.getCoreInfo(xmlHandler);
                if (coreInfoItems != null) {
                    result = coreInfoItems.get(corePath);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegisterInfo getRegisterInfo(XmlDeviceInfoHandler xmlHandler, String registerPath) {
            RegisterInfo registerInfo = null;
            Object object = this.cacheLock;
            synchronized (object) {
                DeviceCacheItem deviceInfo = this.getDeviceInfo(xmlHandler);
                if (deviceInfo != null) {
                    if (deviceInfo.registerListByPath == null) {
                        this.updateRegisterInfo(xmlHandler, deviceInfo);
                    }
                    if (deviceInfo.registerListByPath != null) {
                        registerInfo = deviceInfo.registerListByPath.get(registerPath);
                    }
                }
            }
            return registerInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DecoderInfo getDecoderInfo(XmlDeviceInfoHandler xmlHandler, String decoderPath) {
            DecoderInfo decoderInfo = null;
            Object object = this.cacheLock;
            synchronized (object) {
                DeviceCacheItem deviceInfo = this.getDeviceInfo(xmlHandler);
                if (deviceInfo != null) {
                    if (deviceInfo.decoderListByPath == null) {
                        deviceInfo.decoderListByPath = this.updateDecoderInfo(xmlHandler);
                    }
                    if (deviceInfo.decoderListByPath != null) {
                        decoderInfo = deviceInfo.decoderListByPath.get(decoderPath);
                    }
                }
            }
            return decoderInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AddressSpaceInfo getAddressSpaceInfo(XmlDeviceInfoHandler xmlHandler, String addressSpacePath) {
            AddressSpaceInfo addressSpaceInfo = null;
            Object object = this.cacheLock;
            synchronized (object) {
                DeviceCacheItem deviceInfo = this.getDeviceInfo(xmlHandler);
                if (deviceInfo != null) {
                    if (deviceInfo.addressSpaceByPath == null) {
                        deviceInfo.addressSpaceByPath = this.updateAddressSpaceInfo(xmlHandler);
                    }
                    if (deviceInfo.addressSpaceByPath != null) {
                        addressSpaceInfo = deviceInfo.addressSpaceByPath.get(addressSpacePath);
                    }
                }
            }
            return addressSpaceInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DeviceCacheItem getCachedDeviceInfo(String filePath) {
            DeviceCacheItem result = null;
            Object object = this.cacheLock;
            synchronized (object) {
                File file;
                result = this.cacheOfDeviceListsByFilename.get(filePath);
                if (result != null && (file = new File(filePath)).lastModified() != result.lastModified) {
                    this.cacheOfDeviceListsByFilename.remove(file.getPath());
                    result = null;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DeviceCacheItem getDeviceInfo(XmlDeviceInfoHandler xmlHandler) {
            DeviceCacheItem cachedDeviceInfo = null;
            Object object = this.cacheLock;
            synchronized (object) {
                cachedDeviceInfo = this.getCachedDeviceInfo(xmlHandler.getXmlFileName());
                if (cachedDeviceInfo == null && (cachedDeviceInfo = this.updateCachedDeviceInfo(xmlHandler)) != null) {
                    this.cacheOfDeviceListsByFilename.put(xmlHandler.getXmlFileName(), cachedDeviceInfo);
                }
            }
            return cachedDeviceInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized DeviceCacheItem updateCachedDeviceInfo(XmlDeviceInfoHandler xmlHandler) {
            DeviceCacheItem deviceInfo = null;
            MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
            if (myXpathNav != null && myXpathNav.getXpath() != null) {
                deviceInfo = new DeviceCacheItem(myXpathNav.xmlFile.lastModified());
                MyXPathNodeIterator nodeIterator = myXpathNav.select(DeviceXMLReader.XML_ROOT_TAG);
                nodeIterator.moveToFirst();
                deviceInfo.xmlFileVersion = nodeIterator.getCurrent().getChildElementValue("XMLFileVersion", "-1");
                Object object = this.cacheLock;
                synchronized (object) {
                    ++this.dirtyCount;
                }
            }
            return deviceInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized TraceInfoItem updateTraceInfo(XmlDeviceInfoHandler xmlHandler) {
            TraceInfoItem deviceInfo = null;
            MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
            if (myXpathNav != null && myXpathNav.getXpath() != null) {
                deviceInfo = new TraceInfoItem();
                this.readTraceSettingFromXmlFile(xmlHandler, deviceInfo);
                Object object = this.cacheLock;
                synchronized (object) {
                    ++this.dirtyCount;
                }
            }
            return deviceInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized Hashtable<String, CoreInfoItem> updateCoreInfo(XmlDeviceInfoHandler xmlHandler) {
            Hashtable<String, CoreInfoItem> coreInfoItems = null;
            MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
            if (myXpathNav != null && myXpathNav.getXpath() != null) {
                coreInfoItems = new Hashtable<String, CoreInfoItem>();
                this.readCoreInfoFromXmlFile(xmlHandler, coreInfoItems);
                Object object = this.cacheLock;
                synchronized (object) {
                    ++this.dirtyCount;
                }
            }
            return coreInfoItems;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized Hashtable<String, MemoryManagementInfoItem> updateMemoryManagementInfo(XmlDeviceInfoHandler xmlHandler) {
            Hashtable<String, MemoryManagementInfoItem> memoryManagementInfoItems = new Hashtable<String, MemoryManagementInfoItem>();
            MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
            if (myXpathNav != null && myXpathNav.getXpath() != null) {
                this.readMemoryManagementInfoFromXmlFile(xmlHandler, memoryManagementInfoItems);
                Object object = this.cacheLock;
                synchronized (object) {
                    ++this.dirtyCount;
                }
            }
            return memoryManagementInfoItems;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void updateRegisterInfo(XmlDeviceInfoHandler xmlHandler, DeviceCacheItem device) {
            MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
            Object object = this.cacheLock;
            synchronized (object) {
                if (device != null && myXpathNav != null && myXpathNav.getXpath() != null) {
                    if (device.registerListByPath == null) {
                        device.registerListByPath = new Hashtable();
                    }
                    if (device.decoderListByPath == null) {
                        device.decoderListByPath = new Hashtable();
                    }
                    this.readRegisterInfoFromXmlFile(xmlHandler, device.registerListByPath, device.decoderListByPath);
                    ++this.dirtyCount;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized Hashtable updateAddressSpaceInfo(XmlDeviceInfoHandler xmlHandler) {
            MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
            Hashtable<String, AddressSpaceInfo> table = new Hashtable<String, AddressSpaceInfo>();
            if (myXpathNav != null && myXpathNav.getXpath() != null) {
                this.readMemTypesFromXmlFile(xmlHandler, table);
                Object object = this.cacheLock;
                synchronized (object) {
                    ++this.dirtyCount;
                }
            }
            return table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized Hashtable updateDecoderInfo(XmlDeviceInfoHandler xmlHandler) {
            MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
            Hashtable<String, DecoderInfo> table = new Hashtable<String, DecoderInfo>();
            if (myXpathNav != null && myXpathNav.getXpath() != null) {
                this.readDecoderInfoFromXmlFile(xmlHandler, table);
                Object object = this.cacheLock;
                synchronized (object) {
                    ++this.dirtyCount;
                }
            }
            return table;
        }

        private synchronized void readTraceSettingFromXmlFile(XmlDeviceInfoHandler xmlHandler, TraceInfoItem deviceTraceInfo) {
            MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
            if (deviceTraceInfo != null && myXpathNav != null && myXpathNav.getXpath() != null) {
                MyXPathNodeIterator nodeIterator = myXpathNav.select(DeviceXMLReader.XML_ROOT_TAG);
                nodeIterator.moveToFirst();
                XmlElement currentNode = nodeIterator.getCurrent();
                TraceInfoItem item = deviceTraceInfo;
                item.fillInfo(xmlHandler, currentNode);
            }
        }

        private synchronized void readCoreInfoFromXmlFile(XmlDeviceInfoHandler xmlHandler, Hashtable<String, CoreInfoItem> coreInfoItems) {
            block4: {
                MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
                if (coreInfoItems != null && myXpathNav != null && myXpathNav.getXpath() != null) {
                    MyXPathNodeIterator nodeIterator = null;
                    XmlElement nodeAtDecoder = null;
                    String xpathQueryRoot = DeviceXMLReader.XML_ROOT_TAG;
                    String devicePath = xpathQueryRoot + "/Device";
                    String deviceCorePathPrefix = devicePath + "/Core[@index='";
                    String deviceCorePathSuffix = "']";
                    coreInfoItems.clear();
                    try {
                        nodeIterator = myXpathNav.select(devicePath);
                        nodeIterator.moveToFirst();
                        XmlElement currentNode = nodeIterator.getCurrent();
                        int numCoresInt = currentNode.getChildElementValue("NumCores", 0);
                        for (int index = 0; index < numCoresInt; ++index) {
                            String xmlPathToDeviceCoreNode = deviceCorePathPrefix + index + deviceCorePathSuffix;
                            nodeIterator = myXpathNav.select(xmlPathToDeviceCoreNode);
                            if (nodeIterator == null || !nodeIterator.hasNext()) continue;
                            nodeAtDecoder = nodeIterator.next();
                            CoreInfoItem coreInfoItem = new CoreInfoItem();
                            coreInfoItem.fillInfo(xmlHandler, nodeAtDecoder);
                            coreInfoItems.put(xmlPathToDeviceCoreNode, coreInfoItem);
                        }
                    }
                    catch (Exception e) {
                        if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block4;
                        MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + myXpathNav.xmlFileName + ": " + e.getMessage(), "XmlDeviceInfoHandler.UpdateTraceSettings", e, xmlHandler.getTargetInfo());
                    }
                }
            }
        }

        private synchronized void readMemoryManagementInfoFromXmlFile(XmlDeviceInfoHandler xmlHandler, Hashtable<String, MemoryManagementInfoItem> memoryManagementInfoItems) {
            block4: {
                MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
                if (memoryManagementInfoItems != null && myXpathNav != null && myXpathNav.getXpath() != null) {
                    MyXPathNodeIterator nodeIterator = null;
                    XmlElement nodeAtDecoder = null;
                    String xpathQueryRoot = DeviceXMLReader.XML_ROOT_TAG;
                    String devicePath = xpathQueryRoot + "/Device";
                    String deviceCorePathPrefix = devicePath + "/Core[@index='";
                    String deviceCorePathSuffix = "']";
                    memoryManagementInfoItems.clear();
                    try {
                        nodeIterator = myXpathNav.select(devicePath);
                        nodeIterator.moveToFirst();
                        XmlElement currentNode = nodeIterator.getCurrent();
                        int numCoresInt = currentNode.getChildElementValue("NumCores", 0);
                        for (int index = 0; index < numCoresInt; ++index) {
                            String xmlPathToDeviceCoreNode = deviceCorePathPrefix + index + deviceCorePathSuffix;
                            nodeIterator = myXpathNav.select(xmlPathToDeviceCoreNode);
                            if (nodeIterator == null || !nodeIterator.hasNext()) continue;
                            nodeAtDecoder = nodeIterator.next();
                            MemoryManagementInfoItem memoryManagementInfoItem = new MemoryManagementInfoItem();
                            memoryManagementInfoItem.fillInfo(xmlHandler, nodeAtDecoder);
                            memoryManagementInfoItems.put(xmlPathToDeviceCoreNode, memoryManagementInfoItem);
                        }
                    }
                    catch (Exception e) {
                        if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block4;
                        MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + myXpathNav.xmlFileName + ": " + e.getMessage(), "XmlDeviceInfoHandler.UpdateTraceSettings", e, xmlHandler.getTargetInfo());
                    }
                }
            }
        }

        public synchronized void readRegisterInfoFromXmlFile(XmlDeviceInfoHandler xmlHandler, Hashtable<String, RegisterInfo> registerInfoTable, Hashtable<String, DecoderInfo> decoderInfoTable) {
            block8: {
                MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
                if (registerInfoTable == null || decoderInfoTable == null) {
                    return;
                }
                MyXPathNodeIterator nodeIterator = null;
                XmlElement nodeAtReg = null;
                boolean done = false;
                String xpathQueryRoot = DeviceXMLReader.XML_ROOT_TAG;
                String devicePath = xpathQueryRoot + "/Device";
                String registerPathPrefix = devicePath + "/Core[@index='";
                String registerPathSuffix = "']/RegisterDefinitions/Register";
                registerInfoTable.clear();
                RegisterInfo registerInfo = null;
                try {
                    this.readDecoderInfoFromXmlFile(xmlHandler, decoderInfoTable);
                    nodeIterator = myXpathNav.select(devicePath);
                    nodeIterator.moveToFirst();
                    XmlElement currentNode = nodeIterator.getCurrent();
                    if (currentNode == null) {
                        String xmlPathToNode = xpathQueryRoot + "/RegisterDefinitions/Register";
                        nodeIterator = myXpathNav.select(xmlPathToNode);
                        registerInfo = new RegisterInfo();
                        registerInfoTable.put(xmlPathToNode, registerInfo);
                        while (!done && nodeIterator.hasNext()) {
                            nodeAtReg = nodeIterator.next();
                            RegisterInfoItem registerItem = new RegisterInfoItem();
                            registerItem.fillInfo(xmlHandler, nodeAtReg);
                            registerInfo.registerItems.add(registerItem);
                        }
                    } else {
                        int numCoresInt = currentNode.getChildElementValue("NumCores", 0);
                        for (int index = 0; index < numCoresInt; ++index) {
                            String xmlPathToNode = registerPathPrefix + index + registerPathSuffix;
                            nodeIterator = myXpathNav.select(xmlPathToNode);
                            registerInfo = new RegisterInfo();
                            registerInfoTable.put(xmlPathToNode, registerInfo);
                            while (!done && nodeIterator.hasNext()) {
                                nodeAtReg = nodeIterator.next();
                                RegisterInfoItem registerItem = new RegisterInfoItem();
                                registerItem.fillInfo(xmlHandler, nodeAtReg);
                                registerInfo.registerItems.add(registerItem);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block8;
                    MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + myXpathNav.xmlFileName + " : " + e.getMessage(), "XmlDeviceInfoHandler.readRegisterInfoFromXmlFile", e, xmlHandler.getTargetInfo());
                }
            }
        }

        public synchronized void readDecoderInfoFromXmlFile(XmlDeviceInfoHandler xmlHandler, Hashtable<String, DecoderInfo> decoderInfoTable) {
            block10: {
                MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
                if (decoderInfoTable == null) {
                    return;
                }
                MyXPathNodeIterator nodeIterator = null;
                XmlElement nodeAtDecoder = null;
                boolean done = false;
                String xpathQueryRoot = DeviceXMLReader.XML_ROOT_TAG;
                String devicePath = xpathQueryRoot + "/Device";
                String decoderPathPrefix = devicePath + "/Core[@index='";
                String decoderPathSuffix = "']/DecoderDefinitions/Decoder";
                DecoderInfo decoderInfo = null;
                decoderInfoTable.clear();
                try {
                    nodeIterator = myXpathNav.select(devicePath);
                    nodeIterator.moveToFirst();
                    XmlElement currentNode = nodeIterator.getCurrent();
                    if (currentNode == null) {
                        String xmlPathToNode = xpathQueryRoot + "/DecoderDefinitions/Decoder";
                        nodeIterator = myXpathNav.select(xmlPathToNode);
                        decoderInfo = new DecoderInfo();
                        decoderInfoTable.put(xmlPathToNode, decoderInfo);
                        while (!done && nodeIterator.hasNext()) {
                            nodeAtDecoder = nodeIterator.next();
                            if (nodeAtDecoder == null) {
                                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                                MemoryServerTrace.logError("nodeIterator.next returned null after .hasNext() returned true", "XmlDeviceInfoHandler.readDecoderInfoFromXmlFile", xmlHandler.getTargetInfo());
                                continue;
                            }
                            DecoderInfoItem decoderItem = new DecoderInfoItem();
                            decoderItem.fillInfo(xmlHandler, nodeAtDecoder);
                            decoderInfo.decoderItems.add(decoderItem);
                        }
                    } else {
                        int numCoresInt = currentNode.getChildElementValue("NumCores", 0);
                        for (int index = 0; index < numCoresInt; ++index) {
                            String xmlPathToNode = decoderPathPrefix + index + decoderPathSuffix;
                            nodeIterator = myXpathNav.select(xmlPathToNode);
                            decoderInfo = new DecoderInfo();
                            decoderInfoTable.put(xmlPathToNode, decoderInfo);
                            while (!done && nodeIterator.hasNext()) {
                                nodeAtDecoder = nodeIterator.next();
                                if (nodeAtDecoder == null) {
                                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                                    MemoryServerTrace.logError("nodeIterator.next returned null after .hasNext() returned true", "XmlDeviceInfoHandler.readDecoderInfoFromXmlFile", xmlHandler.getTargetInfo());
                                    continue;
                                }
                                DecoderInfoItem decoderItem = new DecoderInfoItem();
                                decoderItem.fillInfo(xmlHandler, nodeAtDecoder);
                                decoderInfo.decoderItems.add(decoderItem);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block10;
                    MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + myXpathNav.xmlFileName + ": " + e.getMessage(), "XmlDeviceInfoHandler.ReadDecoderInfoFromXmlFile", e, xmlHandler.getTargetInfo());
                }
            }
        }

        public synchronized void readMemTypesFromXmlFile(XmlDeviceInfoHandler xmlHandler, Hashtable<String, AddressSpaceInfo> addressSpaceInfoTable) {
            block8: {
                MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
                if (addressSpaceInfoTable == null) {
                    return;
                }
                MyXPathNodeIterator nodeIterator = null;
                XmlElement nodeAtDecoder = null;
                boolean done = false;
                String xpathQueryRoot = DeviceXMLReader.XML_ROOT_TAG;
                String devicePath = xpathQueryRoot + "/Device";
                String deviceCorePathPrefix = devicePath + "/Core[@index='";
                String deviceCorePathSuffix = "']";
                String addressSpacePrefix = "/AddressSpace[@page='";
                String addressSpaceSuffix = "']";
                AddressSpaceInfo addressSpaceInfo = null;
                addressSpaceInfoTable.clear();
                try {
                    nodeIterator = myXpathNav.select(devicePath);
                    nodeIterator.moveToFirst();
                    XmlElement currentNode = nodeIterator.getCurrent();
                    int numCoresInt = currentNode.getChildElementValue("NumCores", 0);
                    for (int index = 0; index < numCoresInt; ++index) {
                        String xmlPathToDeviceCoreNode = deviceCorePathPrefix + index + deviceCorePathSuffix;
                        nodeIterator = myXpathNav.select(xmlPathToDeviceCoreNode);
                        if (nodeIterator == null || !nodeIterator.hasNext()) continue;
                        nodeAtDecoder = nodeIterator.next();
                        int numAddressSpaceInt = nodeAtDecoder.getChildElementValue("NumAddressSpaces", 0);
                        for (int addressSpaceIndex = 0; addressSpaceIndex < numAddressSpaceInt; ++addressSpaceIndex) {
                            String xmlPathToAddressSpaceNode = xmlPathToDeviceCoreNode + addressSpacePrefix + addressSpaceIndex + addressSpaceSuffix;
                            MyXPathNodeIterator adrsSpaceNodeIterator = myXpathNav.selectChildNodesOf(xmlPathToAddressSpaceNode);
                            addressSpaceInfo = new AddressSpaceInfo();
                            addressSpaceInfoTable.put(xmlPathToAddressSpaceNode, addressSpaceInfo);
                            if (adrsSpaceNodeIterator == null || !adrsSpaceNodeIterator.hasNext()) continue;
                            try {
                                XmlElement memoryTypeNode = adrsSpaceNodeIterator.findFirstNodeWithName("MemoryType", false, true);
                                int memTypeIndex = 0;
                                while (memoryTypeNode != null) {
                                    MemoryTypeItem memType = new MemoryTypeItem();
                                    memType.fillInfo(xmlHandler, memTypeIndex, (short)addressSpaceIndex, memoryTypeNode);
                                    addressSpaceInfo.memoryTypeItems.add(memType);
                                    memoryTypeNode = adrsSpaceNodeIterator.findNextNodeWithName("MemoryType", false, true);
                                }
                                continue;
                            }
                            catch (Exception e) {
                                addressSpaceInfo.memoryTypeItems.clear();
                                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                                MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + myXpathNav.xmlFileName + ": " + e.getMessage(), "XmlDeviceInfoHandler.readMemTypesFromXmlFile", e, xmlHandler.getTargetInfo());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block8;
                    MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + myXpathNav.xmlFileName + ": " + e.getMessage(), "XmlDeviceInfoHandler.ReadDecoderInfoFromXmlFile", e, xmlHandler.getTargetInfo());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void storeCachedDevices(String deviceCacheFilename) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (this.cacheOfDeviceListsByFilename != null && this.dirtyCount > 0) {
                    try {
                        FileOutputStream fos = new FileOutputStream(deviceCacheFilename);
                        BufferedOutputStream buffer = new BufferedOutputStream(fos);
                        ObjectOutputStream out = new ObjectOutputStream(buffer);
                        out.writeObject(this.cacheOfDeviceListsByFilename);
                        out.close();
                        this.dirtyCount = 0;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void loadCachedDevices(String deviceCacheFilename, boolean doPurgeAfter) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (this.cacheOfDeviceListsByFilename == null) {
                    try {
                        FileInputStream fis = new FileInputStream(deviceCacheFilename);
                        BufferedInputStream buffer = new BufferedInputStream(fis);
                        ObjectInputStream in = new ObjectInputStream(buffer);
                        this.cacheOfDeviceListsByFilename = (Hashtable)in.readObject();
                        in.close();
                    }
                    catch (IOException ex) {
                        this.cacheOfDeviceListsByFilename = null;
                    }
                    catch (ClassNotFoundException ex) {
                        this.cacheOfDeviceListsByFilename = null;
                    }
                    if (this.cacheOfDeviceListsByFilename == null) {
                        this.cacheOfDeviceListsByFilename = new Hashtable();
                    }
                    this.dirtyCount = 0;
                    if (doPurgeAfter) {
                        Iterator<Map.Entry<String, DeviceCacheItem>> elements = this.cacheOfDeviceListsByFilename.entrySet().iterator();
                        while (elements.hasNext()) {
                            Map.Entry<String, DeviceCacheItem> element = elements.next();
                            DeviceCacheItem item = element.getValue();
                            if (item.lastModified != 0L && new File(element.getKey()).lastModified() == item.lastModified) continue;
                            elements.remove();
                            ++this.dirtyCount;
                        }
                    }
                }
            }
        }
    }

    public static class DeviceCacheItem
    implements Serializable {
        long lastModified = 0L;
        String xmlFileVersion = "-1";
        TraceInfoItem traceInfoItem = null;
        Hashtable<String, RegisterInfo> registerListByPath = null;
        Hashtable<String, DecoderInfo> decoderListByPath = null;
        Hashtable<String, AddressSpaceInfo> addressSpaceByPath = null;
        Hashtable<String, CoreInfoItem> listOfCores = null;
        Hashtable<String, MemoryManagementInfoItem> memoryManagementInfoItems = null;

        DeviceCacheItem(long lastModified) {
            this.lastModified = lastModified;
        }
    }

    public static class MemoryManagementInfoItem
    implements Serializable {
        public String canBeDisabled = "";
        public String mmuEnableRegName = "";
        public String mmuEnableDecoderName = "";
        public String strAttributesToolTip = "";
        public boolean areAllMmuVersionConfigsSupported = true;
        public String mmuVersionConfigRegName = "";
        public String mmuConfigNotSupportedDecoderName = "";
        public String mmuVersionStringDecoderName = "";
        public String isSystemReadAccessSupported = "";
        public String systemReadAccessRegName = "";
        public String systemReadAccessDecoderName = "";
        public String isReadOnlyAccessSupported = "";
        public String ReadOnlyAccessRegName = "";
        public String ReadOnlyAccessDecoderName = "";
        public String isDomainAccessPermissionSupported = "";
        public String DomainAccessPermissionRegName = "";
        public int numDomains = 0;
        public ArrayList<String> listOfDecodersForDomainAP = null;
        public String isProcessIdSupported = "";
        public String isProcessIdDecodedFromLogicalAdrs = "";
        public String processIdSupported_decoderName = "";
        public ArrayList<MemoryPageTableInfoItem> pageTableInfoItems = null;
        public ArrayList<MasterPageTableInfo> masterPageTableList = new ArrayList();

        void fillInfo(XmlDeviceInfoHandler xmlHandler, XmlElement nodeAtReg) {
            XmlHelper xmlHelper = new XmlHelper();
            MyXPathNodeIterator nodeIterator = nodeAtReg.select("MemoryManagementUnit", false);
            if (nodeIterator != null) {
                XmlElement memoryMgtNode = nodeIterator.moveToFirst();
                this.mmuEnableRegName = xmlHelper.getString(memoryMgtNode, "Control/ConfigReg", "", 0);
                this.mmuEnableDecoderName = xmlHelper.getString(memoryMgtNode, "Control/DecoderName", "", 0);
                this.strAttributesToolTip = xmlHelper.getString(memoryMgtNode, "Attributes/ToolTip", "", 0);
                this.areAllMmuVersionConfigsSupported = xmlHelper.getBoolean(memoryMgtNode, "MmuVersionConfig/AreAllVersionConfigsSupported", true, 0);
                this.mmuVersionConfigRegName = xmlHelper.getString(memoryMgtNode, "MmuVersionConfig/ConfigReg", "", 0);
                this.mmuConfigNotSupportedDecoderName = xmlHelper.getString(memoryMgtNode, "MmuVersionConfig/Decoder_CurrentVersionConfigNotSupported", "", 0);
                this.mmuVersionStringDecoderName = xmlHelper.getString(memoryMgtNode, "MmuVersionConfig/Decoder_VersionString", "", 0);
                this.canBeDisabled = xmlHelper.getString(memoryMgtNode, "Control/CanBeDisabled", "", 0);
                this.isSystemReadAccessSupported = xmlHelper.getString(memoryMgtNode, "SystemReadAccess/IsSupported", "", 0);
                this.systemReadAccessRegName = xmlHelper.getString(memoryMgtNode, "SystemReadAccess/ConfigReg", "", 0);
                this.systemReadAccessDecoderName = xmlHelper.getString(memoryMgtNode, "SystemReadAccess/DecoderName", "", 0);
                this.isReadOnlyAccessSupported = xmlHelper.getString(memoryMgtNode, "ReadOnlyAccess/IsSupported", "", 0);
                this.ReadOnlyAccessRegName = xmlHelper.getString(memoryMgtNode, "ReadOnlyAccess/ConfigReg", "", 0);
                this.ReadOnlyAccessDecoderName = xmlHelper.getString(memoryMgtNode, "ReadOnlyAccess/DecoderName", "", 0);
                this.isDomainAccessPermissionSupported = xmlHelper.getString(memoryMgtNode, "DomainAccessPermissions/IsSupported", "", 0);
                this.DomainAccessPermissionRegName = xmlHelper.getString(memoryMgtNode, "DomainAccessPermissions/ConfigReg", "", 0);
                this.numDomains = xmlHelper.getInt(memoryMgtNode, "DomainAccessPermissions/NumDomains", 0, 0);
                this.listOfDecodersForDomainAP = new ArrayList();
                if (this.DomainAccessPermissionRegName.length() > 0 && this.numDomains > 0) {
                    XmlElement domainAccessPermissionsNode = memoryMgtNode.select("DomainAccessPermissions", true).moveToFirst();
                    this.readListOfDecodersForThisElement(domainAccessPermissionsNode, this.listOfDecodersForDomainAP);
                }
                this.isProcessIdSupported = xmlHelper.getString(memoryMgtNode, "ProcessId/IsSupported", "", 0);
                this.isProcessIdDecodedFromLogicalAdrs = xmlHelper.getString(memoryMgtNode, "ProcessId/IsDecodedFromLogicalAdrs", "", 0);
                this.processIdSupported_decoderName = xmlHelper.getString(memoryMgtNode, "ProcessId/DecoderName", "", 0);
                this.readPageTableInfoFromXmlFile(xmlHandler, memoryMgtNode);
                MyXPathNodeIterator pageCtrlNodeIterator = memoryMgtNode.select("MasterPageTableControl/MasterPageTable", false);
                if (pageCtrlNodeIterator != null) {
                    XmlElement xmlPgCtrlNode = pageCtrlNodeIterator.moveToFirst();
                    while (xmlPgCtrlNode != null) {
                        MasterPageTableInfo masterPageTableInfo = new MasterPageTableInfo();
                        masterPageTableInfo.fillInfo(xmlHandler, xmlPgCtrlNode);
                        this.masterPageTableList.add(masterPageTableInfo);
                        xmlPgCtrlNode = pageCtrlNodeIterator.next();
                    }
                } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    String errMsg = "ERROR attempting to read MMU information from Memory Server XML file " + xmlHandler.getXmlFileName();
                    MemoryServerTrace.logError(errMsg + ": could not find /MemoryManagementUnit/MasterPageControl/MasterPageTable node", "com.ti.debug.mptv.form.MptvMmuHdlr xml constructor", xmlHandler.getTargetInfo());
                }
            }
        }

        private boolean readPageTableInfoFromXmlFile(XmlDeviceInfoHandler xmlHandler, XmlElement xmlMemMgtNode) {
            boolean result = false;
            MyXPathNodeIterator nodeIterator = null;
            MyXPathNodeIterator pageTableIterator = null;
            try {
                nodeIterator = xmlMemMgtNode.getIteratorForChildNodes();
                if (nodeIterator.hasNext()) {
                    pageTableIterator = nodeIterator.getIteratorForNodesWithName("PageTable", true);
                    this.pageTableInfoItems = new ArrayList();
                    while (pageTableIterator.hasNext()) {
                        XmlElement pageTableNode = pageTableIterator.next();
                        MemoryPageTableInfoItem memoryPageTableInfoItem = new MemoryPageTableInfoItem();
                        memoryPageTableInfoItem.fillInfo(xmlHandler, pageTableNode);
                        this.pageTableInfoItems.add(memoryPageTableInfoItem);
                    }
                }
            }
            catch (Exception e) {
                MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + xmlHandler.getTargetInfo().getXmlDeviceDescriptionFileName() + " : " + e.getMessage(), "MptvMmuHdlr.ReadPageTableInfoFromXmlFile", e, xmlHandler.getTargetInfo());
                result = false;
            }
            if (this.pageTableInfoItems.size() > 0) {
                result = true;
            }
            return result;
        }

        private boolean readListOfDecodersForThisElement(XmlElement node, ArrayList<String> listOfDecodersForElement) {
            boolean decoderFound = false;
            String decoderName = "";
            String xmlDecoderName = "";
            XmlElement xmlDecoderNode = null;
            MyXPathNodeIterator nodeIterator = null;
            nodeIterator = node.select("RegDecoder", true);
            while (nodeIterator.hasNext()) {
                xmlDecoderNode = nodeIterator.next();
                xmlDecoderName = xmlDecoderNode.getValue();
                decoderName = xmlDecoderName.trim().toLowerCase();
                listOfDecodersForElement.add(decoderName);
            }
            return decoderFound;
        }
    }

    public static class MasterPageTableInfo
    implements Serializable {
        public String name;
        public boolean isAlwaysEnabled = true;
        public RegDecoderInfo decoder_isEnabled = null;
        public boolean isPageTableIndexFixed = false;
        public int fixedPageTableIndex = 0;
        public RegDecoderInfo decoder_PageTableIndex = null;
        public boolean isMaxVirtualAdrsAlwaysEnabled = false;
        public boolean isMaxVirtualAdrsAlwaysDisabled = false;
        public RegDecoderInfo decoder_isMaxVirtualAdrsEnabled = null;
        public boolean isMaxVirtualAdrsFixed = false;
        public long fixedMaxVirtualAdrs = -1L;
        public RegDecoderInfo decoder_MaxVirtualAdrs = null;

        void fillInfo(XmlDeviceInfoHandler xmlHandler, XmlElement xmlPgCtrlNode) {
            XmlHelper xmlHelper = new XmlHelper();
            this.name = xmlHelper.getString(xmlPgCtrlNode, "Name", "none", 0);
            this.isAlwaysEnabled = xmlHelper.getBoolean(xmlPgCtrlNode, "IsEnabled/AlwaysEnabled", true, 0);
            this.decoder_isEnabled = null;
            if (!this.isAlwaysEnabled) {
                this.decoder_isEnabled = xmlHelper.getRegDecoder(xmlPgCtrlNode, "IsEnabled", 0);
            }
            this.isPageTableIndexFixed = xmlHelper.getBoolean(xmlPgCtrlNode, "PageTableIndex/IsFixed", false, 0);
            if (this.isPageTableIndexFixed) {
                this.fixedPageTableIndex = xmlHelper.getInt(xmlPgCtrlNode, "PageTableIndex/FixedValue", 0, 0);
                this.decoder_PageTableIndex = null;
            } else {
                this.fixedPageTableIndex = 0;
                this.decoder_PageTableIndex = xmlHelper.getRegDecoder(xmlPgCtrlNode, "PageTableIndex", 0);
            }
            this.isMaxVirtualAdrsAlwaysEnabled = xmlHelper.getBoolean(xmlPgCtrlNode, "IsMaxVirtualAdrsEnabled/AlwaysEnabled", false, 0);
            this.isMaxVirtualAdrsAlwaysDisabled = xmlHelper.getBoolean(xmlPgCtrlNode, "IsMaxVirtualAdrsEnabled/AlwaysDisabled", false, 0);
            this.decoder_isMaxVirtualAdrsEnabled = null;
            if (!this.isMaxVirtualAdrsAlwaysEnabled && !this.isMaxVirtualAdrsAlwaysDisabled) {
                this.decoder_isMaxVirtualAdrsEnabled = xmlHelper.getRegDecoder(xmlPgCtrlNode, "IsMaxVirtualAdrsEnabled", 0);
            }
            this.isMaxVirtualAdrsFixed = xmlHelper.getBoolean(xmlPgCtrlNode, "MaxVirtualAdrs/IsFixed", false, 0);
            if (this.isMaxVirtualAdrsFixed) {
                this.fixedMaxVirtualAdrs = xmlHelper.getLong(xmlPgCtrlNode, "MaxVirtualAdrs/FixedValue", -1L, 0);
                this.decoder_MaxVirtualAdrs = null;
            } else {
                this.fixedMaxVirtualAdrs = -1L;
                this.decoder_MaxVirtualAdrs = xmlHelper.getRegDecoder(xmlPgCtrlNode, "MaxVirtualAdrs", 0);
            }
        }
    }

    public static class MemoryPageTableInfoItem
    implements Serializable {
        public String name = "";
        public int level = 0;
        public long numEntries = 0L;
        public int numMausPerEntry = -1;
        public long numMausEachPteRepresents = -1L;
        public String decoder_IsEntryFaultPage = "";
        public String decoder_IsEntryPageTablePointer = "";
        public String decoder_GetPageTablePointer = "";
        public String decoder_GetIndexOfPageTableHandler = "";
        public String decoder_IsEntryPhysicalPagePointer = "";
        public String decoder_GetIndexOfPhysicalPageAdrsDecoder = "";
        public ArrayList<String> listOfDecoders_PhysicalPageAdrsDecoders = null;
        public String decoder_GetIndexOfPhysicalPageSizeDecoder = "";
        public ArrayList<String> listOfDecoders_PhysicalPageSizeDecoders = null;
        public boolean isTableAdrsAParentPageTableEntry = false;
        public boolean tableAdrs_IsFixed = false;
        public long tableAdrs_FixedValue = -1L;
        public RegDecoderInfo decoder_TableAdrs = null;
        public boolean isLogicalStartAdrsFixed = false;
        public long logicalStartAdrs = 0L;
        public boolean isLogicalStartAdrsFromParentPte = false;
        public RegDecoderInfo decoder_LogicalStartAdrsRegister = null;
        public String decoder_GetNumSubPages = "";
        public ArrayList<String> listOfDecoders_GetSubPageAccessPermission = null;
        public String decoder_GetListOfAttributeListsIndex = "";
        public String decoder_GetDomainId = "";
        public ArrayList<ArrayList> listOfAttributeLists = null;

        public void fillInfo(XmlDeviceInfoHandler xmlHandler, XmlElement pageTableNode) {
            String strXPathPrefix = pageTableNode.getStrXmlPathToNode();
            if (strXPathPrefix.length() > 0) {
                strXPathPrefix = strXPathPrefix + "/";
            }
            try {
                XmlHelper xmlHelper = new XmlHelper();
                this.name = xmlHelper.getString(pageTableNode, "Name", "none", 0);
                this.level = xmlHelper.getInt(pageTableNode, "Level", 0, 0);
                this.numEntries = xmlHelper.getLong(pageTableNode, "NumEntries", 0L, 0);
                this.numMausPerEntry = xmlHelper.getInt(pageTableNode, "NumMAUsPerEntry", -1, 0);
                this.numMausEachPteRepresents = xmlHelper.getLong(pageTableNode, "NumMAUsPerPageFrame", -1L, 0);
                this.decoder_IsEntryFaultPage = xmlHelper.getString(pageTableNode, "Decoder_IsEntryFaultPage", "", 0);
                this.decoder_IsEntryPageTablePointer = xmlHelper.getString(pageTableNode, "Decoder_IsEntryPageTablePointer", "", 0);
                this.decoder_GetPageTablePointer = xmlHelper.getString(pageTableNode, "PageTablePointer/Decoder_GetPageTablePointer", "", 0);
                this.decoder_GetIndexOfPageTableHandler = xmlHelper.getString(pageTableNode, "PageTablePointer/Decoder_GetIndexOfPageTableHandler", "", 0);
                this.decoder_IsEntryPhysicalPagePointer = xmlHelper.getString(pageTableNode, "Decoder_IsEntryPhysicalPagePointer", "", 0);
                this.decoder_GetIndexOfPhysicalPageAdrsDecoder = xmlHelper.getString(pageTableNode, "PhysicalPagePointer/Decoder_GetIndexOfPhysicalPageAdrsDecoder", "", 0);
                this.listOfDecoders_PhysicalPageAdrsDecoders = new ArrayList();
                this.getListOfDecodersFromXml(xmlHandler, this.listOfDecoders_PhysicalPageAdrsDecoders, "PhysicalPagePointer/DecoderList_PhysicalPageAdrsDecoder", pageTableNode);
                this.decoder_GetIndexOfPhysicalPageSizeDecoder = xmlHelper.getString(pageTableNode, "PhysicalPagePointer/Decoder_GetIndexOfPhysicalPageSizeDecoder", "", 0);
                this.listOfDecoders_PhysicalPageSizeDecoders = new ArrayList();
                this.getListOfDecodersFromXml(xmlHandler, this.listOfDecoders_PhysicalPageSizeDecoders, "PhysicalPagePointer/DecoderList_PhysicalPageSizeDecoder", pageTableNode);
                this.isTableAdrsAParentPageTableEntry = xmlHelper.getBoolean(pageTableNode, "TableAdrs/IsAParentPageTableEntry", false, 0);
                this.tableAdrs_IsFixed = xmlHelper.getBoolean(pageTableNode, "TableAdrs/IsFixed", false, 0);
                if (this.tableAdrs_IsFixed) {
                    this.tableAdrs_FixedValue = xmlHelper.getLong(pageTableNode, "TableAdrs/FixedValue", 0L, 0);
                    this.decoder_TableAdrs = null;
                } else {
                    this.tableAdrs_FixedValue = 0L;
                    this.decoder_TableAdrs = xmlHelper.getRegDecoder(pageTableNode, "TableAdrs", 0);
                }
                this.isLogicalStartAdrsFixed = xmlHelper.getBoolean(pageTableNode, "LogicalStartAdrs/IsFixed", false, 0);
                this.logicalStartAdrs = xmlHelper.getLong(pageTableNode, "LogicalStartAdrs/FixedValue", 0L, 0);
                this.isLogicalStartAdrsFromParentPte = xmlHelper.getBoolean(pageTableNode, "LogicalStartAdrs/IsAParentPageTableEntry", false, 0);
                this.decoder_LogicalStartAdrsRegister = xmlHelper.getRegDecoder(pageTableNode, "LogicalStartAdrs", 0);
                this.decoder_GetNumSubPages = xmlHelper.getString(pageTableNode, "PhysicalPagePointer/Decoder_GetNumSubPages", "", 0);
                this.listOfDecoders_GetSubPageAccessPermission = new ArrayList();
                this.getListOfDecodersFromXml(xmlHandler, this.listOfDecoders_GetSubPageAccessPermission, "PhysicalPagePointer/DecoderList_GetSubPageAccessPermission", pageTableNode);
                this.decoder_GetDomainId = xmlHelper.getString(pageTableNode, "PhysicalPagePointer/Decoder_GetDomainId", "", 0);
                this.listOfAttributeLists = new ArrayList();
                this.decoder_GetListOfAttributeListsIndex = xmlHelper.getString(pageTableNode, "PhysicalPagePointer/Attributes/Decoder_GetListOfAttributeListsIndex", "", 0);
                if (this.decoder_GetListOfAttributeListsIndex.length() > 0) {
                    this.getListOfDecoderLists(xmlHandler, this.listOfAttributeLists, "PhysicalPagePointer/Attributes", "DecoderList_GetAttributes", pageTableNode);
                }
            }
            catch (Exception ex) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException("Error attempting to read MMU information from Memory Server XML file " + xmlHandler.getXmlFileName(), "MMUPageTableViewerForm.CcsMmuHandler xml constructor", ex, xmlHandler.getTargetInfo());
                }
                return;
            }
        }

        private boolean getListOfDecodersFromXml(XmlDeviceInfoHandler xmlHandler, ArrayList<String> decoderList, String strXPath, XmlElement node) {
            String strDecoderName = "";
            MyXPathNodeIterator nodeIterator = null;
            boolean found = false;
            try {
                nodeIterator = node.select(strXPath + "/DecoderName", true);
                while (nodeIterator.moveNext()) {
                    strDecoderName = nodeIterator.getCurrent().getValue();
                    decoderList.add(strDecoderName);
                }
            }
            catch (Exception e) {
                MemoryServerTrace.logException("Failure reading xml list of decoders for MmuPageTableHandler (" + strXPath + ") : " + e.getMessage(), "MptvPageTableHdlr.getListOfDecodersFromXml", e, xmlHandler.getTargetInfo());
            }
            return found;
        }

        private boolean getListOfDecoderLists(XmlDeviceInfoHandler xmlHandler, ArrayList<ArrayList> list, String strXPath, String listName, XmlElement node) {
            MyXPathNodeIterator nodeIterator = null;
            MyXPathNodeIterator nestedNodeIterator = null;
            String strDecoderName = "";
            boolean found = false;
            ArrayList<String> decoderList = null;
            try {
                nodeIterator = node.select(strXPath + "/" + listName, true);
                while (nodeIterator.moveNext()) {
                    found = false;
                    nestedNodeIterator = nodeIterator.getCurrent().select("DecoderName", true);
                    while (nestedNodeIterator.moveNext()) {
                        strDecoderName = nestedNodeIterator.getCurrent().getValue();
                        if (strDecoderName == null || strDecoderName.length() <= 0) continue;
                        if (!found) {
                            decoderList = new ArrayList<String>();
                            list.add(decoderList);
                            found = true;
                        }
                        decoderList.add(strDecoderName);
                    }
                }
            }
            catch (Exception e) {
                MemoryServerTrace.logException("Failure reading xml list of decoders for MmuPageTableHandler (" + strXPath + ") : " + e.getMessage(), "MptvPageTableHdlr.getListOfDecoderLists", e, xmlHandler.getTargetInfo());
            }
            return found;
        }
    }

    public static class CoreInfoItem
    implements Serializable {
        public String name;
        public boolean isMemoryLevelVisibilitySupported = false;
        public boolean isGTI_GetMemWithStatSupported = false;
        public boolean isVirtualMemorySupported = false;
        public boolean isDeviceIdSupported = false;
        public int minNumMausPerMemoryRead = -1;
        public String deviceId_configReg = "";
        public String deviceId_decoderName = "";
        public String configReg = "";
        public String decoderName = "";
        public boolean useDriverMMUAPIs = false;
        public String canBeDisabled = "";
        public String mmuEnableRegName = "";
        public String mmuEnableDecoderName = "";
        public boolean memoryManagementUnitExist = false;
        public boolean useDriverMMUBypassAPIs = true;

        void fillInfo(XmlDeviceInfoHandler xmlHandler, XmlElement nodeAtReg) {
            XmlElement coreNumberNode;
            XmlHelper xmlHelper = new XmlHelper();
            this.name = xmlHelper.getString(nodeAtReg, "Name", "", 0);
            this.isMemoryLevelVisibilitySupported = nodeAtReg.getChildElementValue("IsMemoryColoringSupported", false);
            this.isGTI_GetMemWithStatSupported = nodeAtReg.getChildElementValue("IsGTI_GetMemWithStatSupported", false);
            this.isVirtualMemorySupported = nodeAtReg.getChildElementValue("IsVirtualMemorySupported", false);
            MyXPathNodeIterator iter = nodeAtReg.select("DeviceId", false);
            if (iter != null && iter.size() > 0) {
                coreNumberNode = iter.getCurrent();
                this.isDeviceIdSupported = coreNumberNode.getChildElementValue("IsDeviceIdSupported", false);
                this.deviceId_configReg = coreNumberNode.getChildElementValue("ConfigReg", "");
                this.deviceId_decoderName = coreNumberNode.getChildElementValue("DecoderName", "");
            }
            if ((iter = nodeAtReg.select("CoreNumber", false)) != null && iter.size() > 0) {
                coreNumberNode = iter.getCurrent();
                this.configReg = coreNumberNode.getChildElementValue("ConfigReg", "");
                this.decoderName = coreNumberNode.getChildElementValue("DecoderName", "");
            }
            this.minNumMausPerMemoryRead = nodeAtReg.getChildElementValue("MinNumMausPerMemoryRead", -1);
            MyXPathNodeIterator nodeIterator = nodeAtReg.select("MemoryManagementUnit", false);
            if (nodeIterator != null) {
                this.memoryManagementUnitExist = true;
                XmlElement memoryMgtNode = nodeIterator.moveToFirst();
                this.useDriverMMUAPIs = xmlHelper.getBoolean(memoryMgtNode, "UseDriverMMUAPIs", false, 0);
                this.useDriverMMUBypassAPIs = xmlHelper.getBoolean(memoryMgtNode, "UseDriverMMUBypassAPIs", true, 0);
                this.canBeDisabled = xmlHelper.getString(memoryMgtNode, "Control/CanBeDisabled", "", 0);
                this.mmuEnableRegName = xmlHelper.getString(memoryMgtNode, "Control/ConfigReg", "", 0);
                this.mmuEnableDecoderName = xmlHelper.getString(memoryMgtNode, "Control/DecoderName", "", 0);
            }
        }
    }

    public static class TraceInfoItem
    implements Serializable {
        long verboseTraceMinAdrs = -1L;
        long verboseTraceMaxAdrs = -1L;
        int ctrvTraceLevel = -1;
        int mptvTraceLevel = -1;
        boolean isTraceSentToOutputWindow = false;
        boolean isTraceSentToErrorLog = false;
        boolean isTimestampEnabled = false;
        boolean isTargetNameEnabled = false;
        String logFileName = null;
        int traceLevelInt = -1;
        boolean traceRequestLifecycle = false;

        public void fillInfo(XmlDeviceInfoHandler xmlHandler, XmlElement currentNode) {
            block4: {
                MyXPathNavigator myXpathNav = xmlHandler.getXpathNav();
                if (myXpathNav != null && myXpathNav.getXpath() != null && currentNode != null) {
                    try {
                        this.traceLevelInt = currentNode.getChildElementValue("TraceLevel", -1);
                        if (this.traceLevelInt != -1) {
                            this.traceRequestLifecycle = currentNode.getChildElementValue("TraceRequestLifecycle", false);
                            this.verboseTraceMinAdrs = currentNode.getChildElementValue("TraceVerboseMinAdrs", -1L);
                            this.verboseTraceMaxAdrs = currentNode.getChildElementValue("TraceVerboseMaxAdrs", -1L);
                        }
                        this.ctrvTraceLevel = currentNode.getChildElementValue("CtrvTraceLevel", -1);
                        this.mptvTraceLevel = currentNode.getChildElementValue("MptvTraceLevel", -1);
                        this.isTraceSentToOutputWindow = currentNode.getChildElementValue("SendTraceEventsToOutputWindow", false);
                        this.isTraceSentToErrorLog = currentNode.getChildElementValue("SendTraceEventsToErrorLog", false);
                        this.isTimestampEnabled = currentNode.getChildElementValue("LogEventTimestamps", false);
                        this.isTargetNameEnabled = currentNode.getChildElementValue("LogTargetName", false);
                        this.logFileName = currentNode.getChildElementValue("LogTraceEventsToFile", "");
                    }
                    catch (Exception e) {
                        if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block4;
                        MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + myXpathNav.xmlFileName + ": " + e.getMessage(), "XmlDeviceInfoHandler.UpdateTraceSettings", e, xmlHandler.getTargetInfo());
                    }
                }
            }
        }
    }

    public static class AddressSpaceInfo
    implements Serializable {
        public ArrayList<MemoryTypeItem> memoryTypeItems = new ArrayList();
    }

    public static class MemoryTypeItem
    implements Serializable {
        public int id;
        public short memoryPageNumber;
        public String name = "";
        public String levelName;
        public int hierarchyDepth = -1;
        public int gtiMemHierarchyReadEnableFlags = -1;
        public String isMemoryTypeDeterminedByAddress = "";
        public int memoryLevelEnableFlags = -1;
        public boolean isCache = false;
        public boolean canBeBypassed = false;
        public boolean isBypassedByDefault = true;
        public boolean isSimulatorSupportsConsistencyChecking = false;
        public boolean isProgramMemory = true;
        public boolean isDataMemory = true;
        public boolean isIOSpace = true;
        public boolean isExternalMemory = true;
        public boolean isSharedMemory = false;
        public boolean isReserved = false;
        public boolean isROM = false;
        public boolean isPaged = false;
        public boolean virtualMemorySupported = false;
        public boolean isVirtualWayConversionEnabled = false;
        public int cacheLineSize = -1;
        public boolean isDefaultPage = false;
        public String defaultDisplayAddressString = "SP";
        public boolean isCacheTagRamDecodingSupported = false;
        public int maxNumCacheLines = 0;
        public boolean isStartAddressFixed = false;
        public long fixedStartAddress;
        public boolean isLengthFixed = false;
        public long fixedLength;
        public boolean canBeProtected = false;
        public boolean hasMemoryAccessIDs = false;
        public boolean canBeSecured = false;
        public RegDecoderInfo decoder_NumCacheLines = null;
        public RegDecoderInfo decoder_CacheSize = null;
        public RegDecoderInfo decoder_IsCacheEnabled = null;
        public RegDecoderInfo decoder_StartAddress = null;
        public RegDecoderInfo decoder_Length = null;
        public CacheTagInfo cacheTagInfo = null;
        public AddressMappedAttributeInfo memoryProtectionHandler = null;
        public AddressMappedAttributeInfo memoryAccessIDHandler = null;
        public AddressMappedAttributeInfo memorySecurityHandler = null;

        public void fillInfo(XmlDeviceInfoHandler xmlHandler, int memId, short memoryPageNumber, XmlElement memoryTypeNode) {
            MyXPathNodeIterator securityNodeIterator;
            XmlElement mpNode;
            MyXPathNodeIterator mpNodeIterator;
            XmlHelper xmlHelper = new XmlHelper();
            this.id = memId;
            this.memoryPageNumber = memoryPageNumber;
            this.name = xmlHelper.getString(memoryTypeNode, "Name", "", 0);
            this.levelName = xmlHelper.getString(memoryTypeNode, "MemoryLevelName", "External", 0);
            this.hierarchyDepth = xmlHelper.getInt(memoryTypeNode, "HierarchyDepth", -1, 0);
            this.gtiMemHierarchyReadEnableFlags = xmlHelper.getInt(memoryTypeNode, "GTIMemHierarchyReadEnableFlags", -1, 0);
            this.isMemoryTypeDeterminedByAddress = xmlHelper.getString(memoryTypeNode, "IsMemoryTypeDeterminedByAddress", "", 0);
            this.memoryLevelEnableFlags = xmlHelper.getInt(memoryTypeNode, "MemLevelBitFlag", -1, 0);
            this.isCache = xmlHelper.getBoolean(memoryTypeNode, "IsCache", false, 0);
            this.canBeBypassed = xmlHelper.getBoolean(memoryTypeNode, "CanBeBypassed", false, 0);
            this.isBypassedByDefault = xmlHelper.getBoolean(memoryTypeNode, "IsBypassedByDefault", false, 0);
            this.isSimulatorSupportsConsistencyChecking = xmlHelper.getBoolean(memoryTypeNode, "SimulatorSupportsConsistencyChecking", false, 0);
            this.isProgramMemory = xmlHelper.getBoolean(memoryTypeNode, "IsProgram", true, 0);
            this.isDataMemory = xmlHelper.getBoolean(memoryTypeNode, "IsData", true, 0);
            this.isIOSpace = xmlHelper.getBoolean(memoryTypeNode, "IsIOSpace", true, 0);
            this.isExternalMemory = xmlHelper.getBoolean(memoryTypeNode, "IsExternal", true, 0);
            this.isSharedMemory = xmlHelper.getBoolean(memoryTypeNode, "IsShared", false, 0);
            this.isReserved = xmlHelper.getBoolean(memoryTypeNode, "IsReserved", false, 0);
            this.isROM = xmlHelper.getBoolean(memoryTypeNode, "IsROM", false, 0);
            this.isPaged = xmlHelper.getBoolean(memoryTypeNode, "IsPaged", false, 0);
            this.virtualMemorySupported = xmlHelper.getBoolean(memoryTypeNode, "IsVirtualMemorySupported", false, 0);
            this.cacheLineSize = xmlHelper.getInt(memoryTypeNode, "Linesize", -1, 0);
            this.isVirtualWayConversionEnabled = xmlHelper.getBoolean(memoryTypeNode, "IsVirtualWayConversionEnabled", false, 0);
            this.isDefaultPage = xmlHelper.getBoolean(memoryTypeNode, "IsDefaultPage", false, 0);
            this.defaultDisplayAddressString = xmlHelper.getString(memoryTypeNode, "DefaultDisplayAddressString", "SP", 0);
            this.isCacheTagRamDecodingSupported = xmlHelper.getBoolean(memoryTypeNode, "Cache/IsCacheTagRamDecodingSupported", false, 0);
            this.maxNumCacheLines = xmlHelper.getInt(memoryTypeNode, "Cache/MaxNumCacheLines", 0, 0);
            this.cacheTagInfo = new CacheTagInfo();
            this.cacheTagInfo.fillInfo(xmlHandler, memoryTypeNode);
            this.decoder_NumCacheLines = xmlHelper.getRegDecoder(memoryTypeNode, "Cache/NumCacheLines/", 0);
            this.decoder_CacheSize = xmlHelper.getRegDecoder(memoryTypeNode, "Cache/CacheSize/", 0);
            this.decoder_IsCacheEnabled = xmlHelper.getRegDecoder(memoryTypeNode, "Cache/IsCacheEnabled/", 0);
            this.isStartAddressFixed = xmlHelper.getBoolean(memoryTypeNode, "MappedMemory/PhysicalAddresses/StartAddress/IsFixed", false, 0);
            this.fixedStartAddress = xmlHelper.getLong(memoryTypeNode, "MappedMemory/PhysicalAddresses/StartAddress/FixedValue", 0L, 0);
            this.decoder_StartAddress = xmlHelper.getRegDecoder(memoryTypeNode, "MappedMemory/PhysicalAddresses/StartAddress/", 0);
            this.isLengthFixed = xmlHelper.getBoolean(memoryTypeNode, "MappedMemory/PhysicalAddresses/Length/IsFixed", false, 0);
            this.fixedLength = xmlHelper.getLong(memoryTypeNode, "MappedMemory/PhysicalAddresses/Length/FixedValue", 0L, 0);
            this.decoder_Length = xmlHelper.getRegDecoder(memoryTypeNode, "MappedMemory/PhysicalAddresses/Length/", 0);
            this.canBeProtected = xmlHelper.getBoolean(memoryTypeNode, "CanBeProtected", false, 0);
            if (this.canBeProtected && (mpNodeIterator = memoryTypeNode.select("MappedMemory/AddressMappedAttribute[@name='MemoryProtection']", true)) != null && mpNodeIterator.size() > 0) {
                mpNode = mpNodeIterator.get(0);
                this.memoryProtectionHandler = new AddressMappedAttributeInfo();
                this.memoryProtectionHandler.fillInfo(xmlHandler, this.name, "", mpNode);
            }
            this.hasMemoryAccessIDs = xmlHelper.getBoolean(memoryTypeNode, "HasMemoryAccessIDs", false, 0);
            if (this.hasMemoryAccessIDs && (mpNodeIterator = memoryTypeNode.select("MappedMemory/AddressMappedAttribute[@name='MemoryAccessIDs']", true)) != null && mpNodeIterator.size() > 0) {
                mpNode = mpNodeIterator.get(0);
                this.memoryAccessIDHandler = new AddressMappedAttributeInfo();
                this.memoryAccessIDHandler.fillInfo(xmlHandler, this.name, "", mpNode);
            }
            this.canBeSecured = xmlHelper.getBoolean(memoryTypeNode, "CanBeSecured", false, 0);
            if (this.canBeSecured && (securityNodeIterator = memoryTypeNode.select("MappedMemory/AddressMappedAttribute[@name='MemorySecurity']", true)) != null && securityNodeIterator.size() > 0) {
                XmlElement securityNode = securityNodeIterator.get(0);
                this.memorySecurityHandler = new AddressMappedAttributeInfo();
                this.memorySecurityHandler.fillInfo(xmlHandler, this.name, "", securityNode);
            }
        }
    }

    public static class RegDecoderInfo
    implements Serializable {
        public String regName = "";
        public String decoderName = "";
    }

    public static class AddressMappedAttributeInfo
    implements Serializable {
        public String name = "";
        public String description = "";
        public String registerName = "";
        public long pageSizeInMAUs = 1024L;
        public long globalAddressMask = 0L;
        public String globalAdrsSpaceIdRegisterName = "";
        public String globalAdrsSpaceIdDecoderName = "";
        public int numFlags = 0;
        public ArrayList<AddressMappedAttributeDescriptorInfo> attrDescList = new ArrayList();

        public void fillInfo(XmlDeviceInfoHandler xmlHandler, String memTypeName, String strXPathQueryRoot, XmlElement attrNode) {
            XmlHelper xmlHelper = new XmlHelper();
            this.name = xmlHelper.getString(attrNode, "Name", "", 0);
            this.description = xmlHelper.getString(attrNode, "Description", "", 0);
            this.registerName = xmlHelper.getString(attrNode, "ConfigReg", "", 0);
            this.pageSizeInMAUs = xmlHelper.getLong(attrNode, "PageSizeInMAUs", 1024L, 0);
            this.globalAddressMask = xmlHelper.getLong(attrNode, "GlobalAddressMask", 0L, 0);
            this.globalAdrsSpaceIdRegisterName = xmlHelper.getString(attrNode, "GlobalAddressSpaceIdBits/ConfigReg", "", 0);
            this.globalAdrsSpaceIdDecoderName = xmlHelper.getString(attrNode, "GlobalAddressSpaceIdBits/DecoderName", "", 0);
            this.numFlags = xmlHelper.getInt(attrNode, "NumFlags", 0, 0);
            AddressMappedAttributeDescriptorInfo attrDesc = null;
            if (this.numFlags > 0) {
                for (int flagNum = 0; flagNum < this.numFlags; ++flagNum) {
                    MyXPathNodeIterator attrNodeIterator = attrNode.select("Flag[@index='" + Integer.toString(flagNum) + "']", true);
                    if (attrNodeIterator == null) continue;
                    XmlElement attrFlagNode = attrNodeIterator.get(0);
                    attrDesc = new AddressMappedAttributeDescriptorInfo();
                    attrDesc.fillInfo(xmlHandler, attrFlagNode);
                    this.attrDescList.add(attrDesc);
                }
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo(this.toString(), "AddressMappedAttributeHandler constructor", xmlHandler.getTargetInfo());
            } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                MemoryServerTrace.logWarning("Did not find valid config register in xml path " + strXPathQueryRoot + " for memory type " + memTypeName, "AddressMappedAttributeHandler.fillInfo", xmlHandler.getTargetInfo());
            }
        }
    }

    public static class AddressMappedAttributeDescriptorInfo
    implements Serializable {
        public String description = "";
        public String propertyName = "";
        public boolean isDisplayBinaryData = false;
        public String decoder = "";

        public void fillInfo(XmlDeviceInfoHandler xmlHandler, XmlElement flagNode) {
            XmlHelper xmlHelper = new XmlHelper();
            this.description = xmlHelper.getString(flagNode, "Description", "", 1);
            this.propertyName = xmlHelper.getString(flagNode, "PropertyName", "", 1);
            this.isDisplayBinaryData = xmlHelper.getBoolean(flagNode, "IsDisplayBinaryData", false, 1);
            XmlElement node = flagNode.getIteratorForChildNodes().findFirstNodeWithName("DecoderName", true, true);
            if (node != null) {
                this.decoder = xmlHelper.getString(node, "DecoderName", "", 0);
            }
        }
    }

    public static class CacheTagInfo
    implements Serializable {
        public boolean isCacheDirtyBitAccessible = false;
        public int numWaysInCache = 0;
        public boolean isLruSupported = false;
        public String decoderName = "";

        public void fillInfo(XmlDeviceInfoHandler xmlHandler, XmlElement memoryTypeNode) {
            XmlHelper xmlHelper = new XmlHelper();
            MyXPathNodeIterator nodeIterator = memoryTypeNode.select("Cache", true);
            if (nodeIterator == null) {
                return;
            }
            XmlElement cacheInfoNode = nodeIterator.moveToFirst();
            MyXPathNodeIterator cacheInfoNodeIterator = null;
            if (cacheInfoNode != null) {
                cacheInfoNodeIterator = cacheInfoNode.getIteratorForChildNodes();
            }
            this.isCacheDirtyBitAccessible = false;
            this.numWaysInCache = 1;
            this.isLruSupported = false;
            if (cacheInfoNodeIterator != null) {
                XmlElement element = cacheInfoNodeIterator.findFirstNodeWithName("IsCacheDirtyBitAccessible", false, true);
                if (element != null) {
                    this.isCacheDirtyBitAccessible = element.getValueAsBoolean();
                }
                if ((element = cacheInfoNodeIterator.findFirstNodeWithName("NumWaysInCache", false, true)) != null) {
                    this.numWaysInCache = element.getValueAsInt();
                }
                if ((element = cacheInfoNodeIterator.findFirstNodeWithName("IsLruSupported", false, true)) != null) {
                    this.isLruSupported = element.getValueAsBoolean();
                }
            }
            if (this.isLruSupported) {
                this.decoderName = xmlHelper.getString(cacheInfoNode, "DecoderName", "", 1);
            }
        }
    }

    public static class DecoderInfo
    implements Serializable {
        public ArrayList<DecoderInfoItem> decoderItems = new ArrayList();
    }

    public static class DecoderInfoItem
    implements Serializable {
        public String name;
        public long xorWithRegValue = 0L;
        public long mask = -1L;
        public int shift = 0;
        public double multiplier = 1.0;
        public long addToProduct = 0L;
        public boolean isTrueIfResultIsZero = false;
        public boolean isAValueField = true;
        public boolean isALookupTable = false;
        public boolean isAStringTable = false;
        public boolean isADecoderTable = false;
        public ArrayList<Long> lookupTable = null;
        public ArrayList<String> stringTable = null;
        public ArrayList<String> decoderNameTable = null;
        public ArrayList<RegisterDecoder> decoderTable = null;
        public int numValues = 0;

        void fillInfo(XmlDeviceInfoHandler xmlHandler, XmlElement nodeAtDecoder) {
            XmlElement arrayItem;
            int numDecoders;
            int numStrings;
            XmlHelper xmlHelper = new XmlHelper();
            this.name = xmlHelper.getString(nodeAtDecoder, "DecoderName", "none", 0);
            this.xorWithRegValue = xmlHelper.getLong(nodeAtDecoder, "XorWithRegValue", 0L, 0);
            this.mask = xmlHelper.getLong(nodeAtDecoder, "BitfieldMask", -1L, 0);
            this.shift = xmlHelper.getInt(nodeAtDecoder, "BitfieldShift", 0, 0);
            this.multiplier = xmlHelper.getDouble(nodeAtDecoder, "Multiplier", 1.0, 0);
            this.addToProduct = xmlHelper.getLong(nodeAtDecoder, "AddToProduct", 0L, 0);
            this.isTrueIfResultIsZero = xmlHelper.getBoolean(nodeAtDecoder, "IsTrueIfResultIsZero", false, 0);
            this.isAValueField = true;
            this.numValues = xmlHelper.getInt(nodeAtDecoder, "LookupTable/NumIndexValues", 0, 0);
            if (this.numValues > 0) {
                this.isAValueField = false;
                this.isALookupTable = true;
            }
            if ((numStrings = xmlHelper.getInt(nodeAtDecoder, "StringTable/NumStrings", 0, 0)) > 0) {
                this.isAStringTable = true;
            }
            if ((numDecoders = xmlHelper.getInt(nodeAtDecoder, "DecoderTable/NumDecoders", 0, 0)) > 0) {
                this.isADecoderTable = true;
            }
            if (this.isALookupTable) {
                long lookupValue = 0L;
                this.lookupTable = new ArrayList();
                MyXPathNodeIterator lookupTableArrayIterator = xmlHelper.navTo(nodeAtDecoder, "LookupTable/Array");
                if (lookupTableArrayIterator != null) {
                    XmlElement arrayItem2 = null;
                    while (lookupTableArrayIterator.hasNext()) {
                        arrayItem2 = lookupTableArrayIterator.next();
                        lookupValue = arrayItem2.getValueAsLong();
                        this.lookupTable.add(lookupValue);
                    }
                }
            }
            if (this.isAStringTable) {
                this.stringTable = new ArrayList();
                String stringValue = "";
                MyXPathNodeIterator stringTableArrayIterator = xmlHelper.navTo(nodeAtDecoder, "StringTable/Array");
                if (stringTableArrayIterator != null) {
                    arrayItem = null;
                    while (stringTableArrayIterator.hasNext()) {
                        arrayItem = stringTableArrayIterator.next();
                        stringValue = arrayItem.getValue();
                        this.stringTable.add(stringValue);
                    }
                }
            }
            if (this.isADecoderTable) {
                String decoderName = "";
                this.decoderNameTable = new ArrayList();
                this.decoderTable = new ArrayList();
                MyXPathNodeIterator decoderArrayIterator = xmlHelper.navTo(nodeAtDecoder, "DecoderTable/Array");
                if (decoderArrayIterator != null) {
                    arrayItem = null;
                    while (decoderArrayIterator.hasNext()) {
                        arrayItem = decoderArrayIterator.next();
                        decoderName = arrayItem.getValue();
                        this.decoderNameTable.add(decoderName);
                    }
                }
            }
        }
    }

    public static class RegisterInfo
    implements Serializable {
        ArrayList<RegisterInfoItem> registerItems = new ArrayList();
    }

    public static class RegisterInfoItem
    implements Serializable {
        public String name;
        public String symbolName = "";
        public long lengthInMAUs = 1L;
        public int numMAUSperRegister = 4;
        public boolean isMemoryMapped = true;
        public long adrs;
        public long numRegistersInSet = 1L;
        public short memoryPageNumber = 0;
        public boolean isRegValueReadOnHalt = false;
        public boolean isRegValueReadOnlyIfMemAnalysisEnabled = false;
        public boolean isContextRestoreReqd = false;
        public int registerId = -1;
        public ArrayList<String> regDecoders = new ArrayList();

        void fillInfo(XmlDeviceInfoHandler xmlHandler, XmlElement nodeAtReg) {
            XmlHelper xmlHelper = new XmlHelper();
            this.name = xmlHelper.getString(nodeAtReg, "Name", "none", 0);
            this.symbolName = xmlHelper.getString(nodeAtReg, "SymbolName", "", 0);
            this.lengthInMAUs = xmlHelper.getLong(nodeAtReg, "LengthInMAUs", 1L, 0);
            this.adrs = xmlHelper.getLong(nodeAtReg, "Address", 0L, 1);
            this.memoryPageNumber = (short)xmlHelper.getLong(nodeAtReg, "MemoryPageNumber", 0L, 0);
            this.isMemoryMapped = xmlHelper.getBoolean(nodeAtReg, "IsMemoryMapped", true, 0);
            this.registerId = -1;
            this.isRegValueReadOnHalt = xmlHelper.getBoolean(nodeAtReg, "IsRegValueReadOnHalt", false, 0);
            this.isRegValueReadOnlyIfMemAnalysisEnabled = xmlHelper.getBoolean(nodeAtReg, "IsOnlyForMemAnalysis", false, 0);
            this.isContextRestoreReqd = xmlHelper.getBoolean(nodeAtReg, "IsRegValueContextRestoreReqd", false, 0);
            this.numRegistersInSet = xmlHelper.getLong(nodeAtReg, "NumRegistersInSet", 1L, 0);
            this.numMAUSperRegister = (int)(this.lengthInMAUs / this.numRegistersInSet);
            if (!this.isMemoryMapped) {
                this.numMAUSperRegister = 1;
            }
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) {
                MemoryServerTrace.logVerbose("RegisterHandler " + this.name + " created. ", "RegisterList xml constructor", xmlHandler.getTargetInfo());
            }
            try {
                xmlHelper.readListOfDecodersForThisRegister(nodeAtReg, this.name, this.regDecoders);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

