/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.xml;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNodeIterator;
import com.ti.debug.engine.framework.IDisposable;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MyXPathNavigator
implements IDisposable {
    public String xmlFileName = "";
    public File xmlFile = null;
    public XPathFactory factory = null;
    private XPath xpath = null;
    public Vector<Node> listOfNodes = null;
    private Document xmlDoc = null;
    public String strRootElementPath = "/CodeComposer/CcsMemoryServer";
    private boolean disposed = false;

    public MyXPathNavigator(String fileName, String strRootElementPath) {
        this.xmlFileName = fileName;
        this.strRootElementPath = strRootElementPath;
        this.listOfNodes = new Vector();
        this.xpath = null;
        this.xmlFile = new File(fileName);
        if (this.xmlFile.exists()) {
            XPathFactory factory = XPathFactory.newInstance();
            this.xpath = factory.newXPath();
        }
    }

    private void createDocument() {
        if (this.xmlFile.exists()) {
            try {
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setNamespaceAware(true);
                try {
                    domFactory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
                }
                catch (ParserConfigurationException e) {
                    // empty catch block
                }
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                this.xmlDoc = builder.parse(this.xmlFile.toURI().toString());
                XPathExpression expr = this.xpath.compile(this.strRootElementPath);
                Object result = expr.evaluate(this.xmlDoc, XPathConstants.NODESET);
                NodeList nodelist = (NodeList)result;
                this.setNodeList(nodelist);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Document getXmlDoc() {
        if (this.xmlDoc == null) {
            this.createDocument();
        }
        return this.xmlDoc;
    }

    public XPath getXpath() {
        return this.xpath;
    }

    private void setNodeList(NodeList nodes) {
        this.listOfNodes.clear();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            this.listOfNodes.add(nodes.item(i));
        }
    }

    private Vector<Node> getVector(NodeList nodes) {
        Vector<Node> result = new Vector<Node>();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            result.add(nodes.item(i));
        }
        return result;
    }

    public MyXPathNodeIterator select(String strXPath) {
        MyXPathNodeIterator result = null;
        try {
            XPathExpression expr = this.getXpath().compile(strXPath);
            Object nodeset = expr.evaluate(this.getXmlDoc(), XPathConstants.NODESET);
            result = new MyXPathNodeIterator(this.getVector((NodeList)nodeset));
        }
        catch (XPathExpressionException e) {
            MemoryServerTrace.logException("Exception parsing " + strXPath + " for file " + this.xmlFileName, "MyXPathNavigator.select", e, null);
            e.printStackTrace();
        }
        return result;
    }

    public MyXPathNodeIterator moveToRoot() {
        return this.select(this.strRootElementPath);
    }

    public String getTextStringValue(String strXPath) throws XPathExpressionException {
        Node node;
        String result = "";
        String strExpr = this.appendSlashIfNecessary(strXPath) + "text()";
        if (!strExpr.startsWith("//")) {
            strExpr = !strExpr.startsWith("/") ? "//" + strExpr : "/" + strExpr;
        }
        XPathExpression expr = this.getXpath().compile(strExpr);
        Object nodeset = expr.evaluate(this.getXmlDoc(), XPathConstants.NODESET);
        NodeList nodeList = (NodeList)nodeset;
        if (nodeset != null && (node = nodeList.item(0)) != null) {
            result = node.getTextContent();
        }
        return result;
    }

    public String appendSlashIfNecessary(String strPath) {
        String result = strPath;
        if (strPath.length() > 0 && !strPath.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    public String stripSlashIfNecessary(String strPath) {
        String result = strPath;
        if (strPath.length() >= 1 && strPath.endsWith("/")) {
            result = strPath.substring(0, strPath.length() - 1);
        }
        return result;
    }

    public MyXPathNodeIterator selectChildNodesOf(String strNavPath) {
        MyXPathNodeIterator result;
        block3: {
            result = null;
            MyXPathNodeIterator nodeIterator = null;
            try {
                nodeIterator = this.select(strNavPath);
                result = null;
                if (nodeIterator != null && nodeIterator.hasNext()) {
                    result = nodeIterator.getCurrent().getIteratorForChildNodes();
                }
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block3;
                MemoryServerTrace.logException("Exception searching for " + strNavPath, "XPathNavigator.selectChildNodesOf", ex, null);
            }
        }
        return result;
    }

    public void dispose() {
        this.dispose(true);
    }

    protected synchronized void dispose(boolean disposing) {
        if (!this.disposed && disposing) {
            this.listOfNodes.clear();
            this.xmlDoc = null;
            this.xmlFile = null;
        }
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void acquire() {
    }
}

