/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.xml;

import com.ti.ccstudio.debug.memoryserver.xml.XmlElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MyXPathNodeIterator
implements Iterator<XmlElement>,
Iterable<XmlElement> {
    private int currentIndex = -1;
    private Vector<Node> listOfNodes = null;

    public MyXPathNodeIterator(Vector<Node> nodeList) {
        this.listOfNodes = nodeList;
        this.currentIndex = -1;
    }

    public void config(Vector<XmlElement> nl, int startIndex) {
        if (nl == null) {
            this.listOfNodes = null;
        } else {
            this.listOfNodes.clear();
            this.listOfNodes.addAll(startIndex, nl);
        }
    }

    public XmlElement getCurrent() {
        XmlElement result = null;
        if (this.currentIndex < 0 && this.listOfNodes.size() > 0) {
            this.currentIndex = 0;
        }
        if (this.currentIndex >= 0 && this.listOfNodes.size() > 0) {
            result = this.get(this.currentIndex);
        }
        return result;
    }

    public Vector<Node> getListOfNodes() {
        return this.listOfNodes;
    }

    public XmlElement get(int index) {
        XmlElement result = null;
        if (this.listOfNodes == null || index < 0 || index >= this.listOfNodes.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        result = new XmlElement(this.listOfNodes.get(index));
        return result;
    }

    @Override
    public boolean hasNext() {
        boolean result = false;
        if (this.currentIndex + 1 < this.listOfNodes.size() && this.listOfNodes.size() > 0) {
            result = true;
        }
        return result;
    }

    public boolean moveNext() {
        boolean result = false;
        if (this.hasNext()) {
            ++this.currentIndex;
            result = true;
        }
        return result;
    }

    @Override
    public XmlElement next() {
        XmlElement result = null;
        if (this.hasNext()) {
            ++this.currentIndex;
            result = this.getCurrent();
        }
        return result;
    }

    public boolean hasPrevious() {
        boolean result = false;
        if (this.currentIndex > 0) {
            result = true;
        }
        return result;
    }

    public boolean movePrevious() {
        boolean result = false;
        if (this.hasPrevious()) {
            --this.currentIndex;
            result = true;
        }
        return result;
    }

    public XmlElement previous() {
        XmlElement result = null;
        if (this.currentIndex > 0) {
            --this.currentIndex;
            result = this.getCurrent();
        }
        return result;
    }

    public XmlElement moveToFirst() {
        this.currentIndex = 0;
        return this.getCurrent();
    }

    @Override
    public void remove() {
        if (this.currentIndex >= 0 && this.currentIndex < this.listOfNodes.size()) {
            this.listOfNodes.remove(this.currentIndex);
            if (this.currentIndex >= this.listOfNodes.size()) {
                this.currentIndex = this.listOfNodes.size() - 1;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private String stripSpaces(String str) {
        String result = str.replace(" ", "");
        return result;
    }

    private boolean doesNodeHaveNameAndAttributes(int index, String searchName, boolean ignoreCase, ArrayList<String> nameValuePairs) {
        boolean found = false;
        Node node = this.listOfNodes.get(index);
        String name = node.getNodeName();
        int numAttributes = 0;
        if (nameValuePairs != null) {
            numAttributes = nameValuePairs.size() >> 1;
        }
        if (ignoreCase) {
            found = name.equalsIgnoreCase(searchName);
        } else {
            boolean bl = found = name.compareTo(searchName) == 0;
        }
        if (found && numAttributes > 0) {
            if (!node.hasAttributes()) {
                found = false;
            } else {
                NamedNodeMap attrNodeMap = node.getAttributes();
                for (int nvIndex = 0; nvIndex < numAttributes && found; ++nvIndex) {
                    String attrName = nameValuePairs.get(nvIndex * 2);
                    String attrValue = nameValuePairs.get(nvIndex * 2 + 1);
                    Node attrNode = attrNodeMap.getNamedItem(attrName);
                    if (attrNode != null && attrNode.getNodeValue().equalsIgnoreCase(attrValue)) continue;
                    found = false;
                }
            }
        }
        return found;
    }

    private int getAttributeNameValuePairsFromPathSegment(String xmlElementPathSegment, ArrayList<String> nameValuePairs) {
        String workString = this.stripSpaces(xmlElementPathSegment);
        int startIndex = workString.indexOf("[@");
        int stopIndex = workString.indexOf("']");
        int equalsIndex = workString.indexOf("='");
        String name = "";
        String value = "";
        String attrDef = "";
        while (workString.length() > 0 && startIndex >= 0 && stopIndex > startIndex) {
            attrDef = workString.substring(startIndex, stopIndex);
            workString = workString.substring(stopIndex + 2, workString.length());
            equalsIndex = attrDef.indexOf("='");
            name = attrDef.substring(2, equalsIndex);
            value = attrDef.substring(equalsIndex + 2, attrDef.length());
            nameValuePairs.add(name);
            nameValuePairs.add(value);
            if (workString.length() <= 0) continue;
            startIndex = workString.indexOf("[@");
            stopIndex = workString.indexOf("']");
        }
        return nameValuePairs.size() >> 1;
    }

    public MyXPathNodeIterator getIteratorForNodesWithName(String nodeName, boolean ignoreCase) {
        MyXPathNodeIterator result = null;
        Vector<Node> nodeList = new Vector<Node>();
        String searchName = this.stripSpaces(nodeName);
        boolean found = false;
        ArrayList<String> nameValuePairs = new ArrayList<String>();
        int numAttributes = this.getAttributeNameValuePairsFromPathSegment(nodeName, nameValuePairs);
        if (numAttributes > 0) {
            searchName = searchName.substring(0, searchName.indexOf(91));
        }
        for (int index = 0; index < this.size(); ++index) {
            found = this.doesNodeHaveNameAndAttributes(index, searchName, ignoreCase, nameValuePairs);
            if (!found) continue;
            nodeList.add(this.listOfNodes.get(index));
        }
        if (nodeList.size() > 0) {
            result = new MyXPathNodeIterator(nodeList);
        }
        return result;
    }

    public XmlElement findFirstNodeWithName(String nodeName, boolean includeCurrentNodeInSearch, boolean ignoreCase) {
        this.reset();
        return this.findNextNodeWithName(nodeName, includeCurrentNodeInSearch, ignoreCase);
    }

    public XmlElement findNextNodeWithName(String nodeName, boolean includeCurrentNodeInSearch, boolean ignoreCase) {
        String searchName = this.stripSpaces(nodeName);
        XmlElement result = null;
        boolean found = false;
        ArrayList<String> nameValuePairs = new ArrayList<String>();
        int numAttributes = this.getAttributeNameValuePairsFromPathSegment(nodeName, nameValuePairs);
        if (numAttributes > 0) {
            searchName = searchName.substring(0, searchName.indexOf(91));
        }
        int startIndex = this.currentIndex;
        if (!includeCurrentNodeInSearch) {
            ++startIndex;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (startIndex < this.size()) {
            for (int index = startIndex; index < this.size(); ++index) {
                found = this.doesNodeHaveNameAndAttributes(index, searchName, ignoreCase, nameValuePairs);
                if (!found) continue;
                this.currentIndex = index;
                break;
            }
        }
        if (found) {
            result = this.getCurrent();
        }
        return result;
    }

    public int size() {
        return this.listOfNodes.size();
    }

    public void reset() {
        this.currentIndex = -1;
    }

    @Override
    public Iterator<XmlElement> iterator() {
        this.reset();
        return this;
    }
}

