/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.xml;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetDeviceInfo;
import com.ti.ccstudio.debug.memoryserver.memoryhierarchy.MemoryTypeDescriptor;
import com.ti.ccstudio.debug.memoryserver.target.RegisterDecoder;
import com.ti.ccstudio.debug.memoryserver.target.RegisterHandler;
import com.ti.ccstudio.debug.memoryserver.target.RegisterList;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.ccstudio.debug.memoryserver.xml.DeviceXMLReader;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNavigator;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNodeIterator;
import com.ti.ccstudio.debug.memoryserver.xml.XmlElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;

public class XmlDeviceInfoHandler
implements IDisposable {
    private ArrayList<String> listOfCores = null;
    protected TargetHandler target = null;
    protected ITargetDeviceInfo targetInfo = null;
    protected boolean isIndexFile = false;
    private boolean readyToUse = false;
    private String xmlFileName;
    private String pathToActiveDeviceCore = "";
    private MyXPathNavigator xpathNav = null;
    private boolean isMemoryLevelVisibilitySupported = false;
    private boolean isGTI_GetMemWithStatSupported = false;
    private boolean isVirtualMemorySupported = false;
    private boolean isDiagnosticTraceLevelInXmlFile = false;
    private boolean isSendTraceEventsToOutputWindowEnabledInXmlFile = false;
    private boolean isLogTraceEventsToErrorLogInXmlFile = false;
    private boolean isLogEventTimestamps = false;
    private boolean isLogTargetName = false;
    private boolean isDeviceIdSupported = false;
    private String xmlCoreName = "";
    private String xmlFileVersion = "";
    private volatile boolean disposed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDeviceInfoHandler(String xmlFileName, boolean isIndexFile, TargetHandler target) {
        this.setXmlFileName(xmlFileName);
        this.target = target;
        this.targetInfo = target.getInfo();
        this.isIndexFile = isIndexFile;
        this.listOfCores = new ArrayList();
        if (xmlFileName != null) {
            this.xpathNav = new MyXPathNavigator(xmlFileName, "/CodeComposer/CcsMemoryServer");
            File xmlFile = new File(xmlFileName);
            if (xmlFile.exists()) {
                if (isIndexFile) {
                    this.readyToUse = false;
                    if (this.xpathNav != null && this.xpathNav.getXpath() != null) {
                        this.readyToUse = true;
                        this.readTraceSettingFromXmlFile();
                        this.readXmlFileVersionString();
                    }
                } else {
                    try {
                        this.readyToUse = false;
                        if (this.xpathNav != null && this.xpathNav.getXpath() != null) {
                            this.readyToUse = true;
                            this.readTraceSettingFromXmlFile();
                            this.readXmlFileVersionString();
                            int activeCoreIndex = this.goToActiveDeviceCore();
                            if (activeCoreIndex < 0) {
                                this.readyToUse = false;
                            }
                        }
                    }
                    catch (Exception e) {
                        MemoryServerTrace.logException("Error reading xml file " + xmlFileName, "XmlDeviceInfoHandler constructor", e, this.targetInfo);
                        this.readyToUse = false;
                    }
                }
            }
        }
    }

    public ITargetDeviceInfo getTargetInfo() {
        return this.target.getInfo();
    }

    public boolean isReadyToUse() {
        return this.readyToUse;
    }

    public String getXmlFileName() {
        return this.xmlFileName;
    }

    public void setXmlFileName(String value) {
        this.xmlFileName = value;
    }

    public String getPathToActiveDeviceCore() {
        return this.pathToActiveDeviceCore;
    }

    public void setPathToActiveDeviceCore(String value) {
        this.pathToActiveDeviceCore = value;
    }

    public MyXPathNavigator getXpathNav() {
        return this.xpathNav;
    }

    public boolean isMemoryLevelVisibilitySupported() {
        return this.isMemoryLevelVisibilitySupported;
    }

    public void setIsMemoryLevelVisibilitySupported(boolean value) {
        this.isMemoryLevelVisibilitySupported = value;
    }

    public boolean isGTI_GetMemWithStatSupported() {
        return this.isGTI_GetMemWithStatSupported;
    }

    public void setIsGTI_GetMemWithStatSupported(boolean value) {
        this.isGTI_GetMemWithStatSupported = value;
    }

    public boolean isVirtualMemorySupported() {
        return this.isVirtualMemorySupported;
    }

    public void setIsVirtualMemorySupported(boolean value) {
        this.isVirtualMemorySupported = value;
    }

    public boolean isDiagnosticTraceLevelInXmlFile() {
        return this.isDiagnosticTraceLevelInXmlFile;
    }

    public void setIsDiagnosticTraceLevelInXmlFile(boolean value) {
        this.isDiagnosticTraceLevelInXmlFile = value;
    }

    public boolean isSendTraceEventsToOutputWindowEnabledInXmlFile() {
        return this.isSendTraceEventsToOutputWindowEnabledInXmlFile;
    }

    public void setIsSendTraceEventsToOutputWindowEnabledInXmlFile(boolean value) {
        this.isSendTraceEventsToOutputWindowEnabledInXmlFile = value;
    }

    public boolean isLogTraceEventsToErrorLogInXmlFile() {
        return this.isLogTraceEventsToErrorLogInXmlFile;
    }

    public void setIsSendTraceEventsToErrorLogInXmlFile(boolean value) {
        this.isLogTraceEventsToErrorLogInXmlFile = value;
    }

    public boolean isLogEventTimestamps() {
        return this.isLogEventTimestamps;
    }

    public void setIsLogEventTimestamps(boolean value) {
        this.isLogEventTimestamps = value;
    }

    public boolean isLogTargetName() {
        return this.isLogTargetName;
    }

    public void setIsLogTargetName(boolean value) {
        this.isLogTargetName = value;
    }

    public boolean isDeviceIdSupported() {
        return this.isDeviceIdSupported;
    }

    public void setIsDeviceIdSupported(boolean value) {
        this.isDeviceIdSupported = value;
    }

    public void setXmlCoreName(String value) {
        this.xmlCoreName = value;
    }

    public String getXmlCoreName() {
        return this.xmlCoreName;
    }

    public String getXmlFileVersion() {
        return this.xmlFileVersion;
    }

    public void setXmlFileVersion(String value) {
        this.xmlFileVersion = value;
    }

    private void readXmlFileVersionStringOld() {
        block3: {
            this.xmlFileVersion = "-1";
            if (this.readyToUse) {
                try {
                    MyXPathNodeIterator nodeIterator = this.getXpathNav().select("/CodeComposer/CcsMemoryServer");
                    nodeIterator.moveToFirst();
                    this.xmlFileVersion = nodeIterator.getCurrent().getChildElementValue("XMLFileVersion", "-1");
                }
                catch (Exception e) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block3;
                    MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + this.getXmlFileName() + ": " + e.getMessage(), "XmlDeviceInfoHandler.UpdateXmlFileVersionString", e, this.targetInfo);
                }
            }
        }
    }

    private void readXmlFileVersionString() {
        DeviceXMLReader.DeviceCacheItem deviceInfo = DeviceXMLReader.getInstance(this.target.getMemoryServerXmlPath()).getDeviceInfo(this);
        this.xmlFileVersion = "-1";
        if (deviceInfo == null) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logError("Failed to retrieve the version number from cache for file: " + this.getXpathNav().xmlFileName, "XmlDeviceInfoHandler.UpdateXmlFileVersionString", null);
            }
            return;
        }
        if (this.readyToUse) {
            this.xmlFileVersion = deviceInfo.xmlFileVersion;
        }
    }

    private void readTraceSettingFromXmlFileOld() {
        block14: {
            if (this.readyToUse) {
                MyXPathNodeIterator nodeIterator = this.getXpathNav().select("/CodeComposer/CcsMemoryServer");
                nodeIterator.moveToFirst();
                XmlElement currentNode = nodeIterator.getCurrent();
                try {
                    String logFileName;
                    boolean enableTargetName;
                    boolean enableTimestamps;
                    boolean sendToErrorLog;
                    boolean sendToOutputWindow;
                    int mptvTraceLevelInt;
                    int ctrvTraceLevelInt;
                    int traceLevelInt = currentNode.getChildElementValue("TraceLevel", -1);
                    if (traceLevelInt != -1) {
                        long maxAdrs;
                        long minAdrs;
                        this.setIsDiagnosticTraceLevelInXmlFile(true);
                        MemoryServerTrace.setMinTraceLevel(EnumTraceLevel.fromInt(traceLevelInt));
                        if (currentNode.getChildElementValue("TraceRequestLifecycle", false)) {
                            MemoryServerTrace.setMinTraceLevel(EnumTraceLevel.OBJECT_LIFECYCLE);
                        }
                        if ((minAdrs = currentNode.getChildElementValue("TraceVerboseMinAdrs", -1L)) >= 0L) {
                            MemoryServerTrace.verboseTraceMinAdrs = minAdrs;
                        }
                        if ((maxAdrs = currentNode.getChildElementValue("TraceVerboseMaxAdrs", -1L)) > 0L) {
                            MemoryServerTrace.verboseTraceMaxAdrs = maxAdrs;
                        }
                    }
                    if ((ctrvTraceLevelInt = currentNode.getChildElementValue("CtrvTraceLevel", -1)) != -1) {
                        MemoryServerTrace.CtrvTraceLevel = ctrvTraceLevelInt;
                    }
                    if ((mptvTraceLevelInt = currentNode.getChildElementValue("MptvTraceLevel", -1)) != -1) {
                        MemoryServerTrace.MptvTraceLevel = mptvTraceLevelInt;
                    }
                    if (sendToOutputWindow = currentNode.getChildElementValue("SendTraceEventsToOutputWindow", false)) {
                        this.setIsSendTraceEventsToOutputWindowEnabledInXmlFile(true);
                        MemoryServerTrace.IsTraceSentToOutputWindow = true;
                    }
                    if (sendToErrorLog = currentNode.getChildElementValue("SendTraceEventsToErrorLog", false)) {
                        this.setIsSendTraceEventsToErrorLogInXmlFile(true);
                        MemoryServerTrace.IsTraceSentToErrorLog = true;
                    }
                    if (enableTimestamps = currentNode.getChildElementValue("LogEventTimestamps", false)) {
                        this.setIsLogEventTimestamps(true);
                        MemoryServerTrace.IsTimestampEnabled = true;
                    }
                    if (enableTargetName = currentNode.getChildElementValue("LogTargetName", false)) {
                        this.setIsLogTargetName(true);
                        MemoryServerTrace.IsTargetNameEnabled = true;
                    }
                    if ((logFileName = currentNode.getChildElementValue("LogTraceEventsToFile", "")).length() > 0) {
                        MemoryServerTrace.LogFileName = logFileName;
                    }
                }
                catch (Exception e) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block14;
                    MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + this.getXmlFileName() + ": " + e.getMessage(), "XmlDeviceInfoHandler.UpdateTraceSettings", e, this.targetInfo);
                }
            }
        }
    }

    private void readTraceSettingFromXmlFile() {
        if (this.readyToUse) {
            String logFileName;
            boolean enableTargetName;
            boolean enableTimestamps;
            boolean sendToErrorLog;
            boolean sendToOutputWindow;
            int mptvTraceLevelInt;
            int ctrvTraceLevelInt;
            DeviceXMLReader.TraceInfoItem traceInfo = DeviceXMLReader.getInstance(this.target.getMemoryServerXmlPath()).getDeviceTraceInfo(this);
            if (traceInfo == null) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logError("Failed to retrieve trace info from cache for xml file: " + this.getXmlFileName(), "XmlDeviceInfoHandler.readTraceSettingFromXmlFile", null);
                }
                return;
            }
            int traceLevelInt = traceInfo.traceLevelInt;
            if (traceLevelInt != -1) {
                long maxAdrs;
                long minAdrs;
                this.setIsDiagnosticTraceLevelInXmlFile(true);
                MemoryServerTrace.setMinTraceLevel(EnumTraceLevel.fromInt(traceLevelInt));
                if (traceInfo.traceRequestLifecycle) {
                    MemoryServerTrace.setMinTraceLevel(EnumTraceLevel.OBJECT_LIFECYCLE);
                }
                if ((minAdrs = traceInfo.verboseTraceMinAdrs) >= 0L) {
                    MemoryServerTrace.verboseTraceMinAdrs = minAdrs;
                }
                if ((maxAdrs = traceInfo.verboseTraceMaxAdrs) > 0L) {
                    MemoryServerTrace.verboseTraceMaxAdrs = maxAdrs;
                }
            }
            if ((ctrvTraceLevelInt = traceInfo.ctrvTraceLevel) != -1) {
                MemoryServerTrace.CtrvTraceLevel = ctrvTraceLevelInt;
            }
            if ((mptvTraceLevelInt = traceInfo.mptvTraceLevel) != -1) {
                MemoryServerTrace.MptvTraceLevel = mptvTraceLevelInt;
            }
            if (sendToOutputWindow = traceInfo.isTraceSentToOutputWindow) {
                this.setIsSendTraceEventsToOutputWindowEnabledInXmlFile(true);
                MemoryServerTrace.IsTraceSentToOutputWindow = true;
            }
            if (sendToErrorLog = traceInfo.isTraceSentToErrorLog) {
                this.setIsSendTraceEventsToErrorLogInXmlFile(true);
                MemoryServerTrace.IsTraceSentToErrorLog = true;
            }
            if (enableTimestamps = traceInfo.isTimestampEnabled) {
                this.setIsLogEventTimestamps(true);
                MemoryServerTrace.IsTimestampEnabled = true;
            }
            if (enableTargetName = traceInfo.isTargetNameEnabled) {
                this.setIsLogTargetName(true);
                MemoryServerTrace.IsTargetNameEnabled = true;
            }
            if ((logFileName = traceInfo.logFileName).length() > 0) {
                MemoryServerTrace.LogFileName = logFileName;
            }
        }
    }

    private int goToActiveDeviceCoreOld() {
        int result;
        block12: {
            XmlElement nodeForActiveDeviceCore = null;
            MyXPathNodeIterator nodeIterator = null;
            long coreIndex = -1L;
            long activeCoreIndex = -1L;
            result = -1;
            if (this.readyToUse) {
                try {
                    String prefix = "/CodeComposer/CcsMemoryServer/Device/";
                    String xPathQuery = prefix + "NumCores";
                    this.listOfCores.clear();
                    if (this.getXpathNav() != null) {
                        nodeIterator = this.getXpathNav().select(xPathQuery);
                        if (nodeIterator.hasNext()) {
                            int numCores = nodeIterator.next().getValueAsInt();
                            String coreName = "";
                            nodeIterator = this.getXpathNav().select(prefix + "Core");
                            for (int i = 0; i < numCores; ++i) {
                                MyXPathNodeIterator coreNodeIterator;
                                XmlElement coreNameElement;
                                if (!nodeIterator.hasNext()) continue;
                                nodeForActiveDeviceCore = nodeIterator.next();
                                coreIndex = nodeForActiveDeviceCore.getAttributeAsInt("index");
                                if (!nodeForActiveDeviceCore.hasChildNodes() || (coreNameElement = (coreNodeIterator = nodeForActiveDeviceCore.getIteratorForChildNodes()).findNextNodeWithName("Name", false, true)) == null) continue;
                                coreName = coreNameElement.getValue();
                                this.listOfCores.add(coreName);
                                if (!this.targetInfo.getStrTargetProcessorId().equalsIgnoreCase(coreName) && !this.targetInfo.getStrTargetIsaXId().equalsIgnoreCase(coreName) && !this.targetInfo.getStrTargetIsaXXId().equalsIgnoreCase(coreName)) continue;
                                activeCoreIndex = coreIndex;
                                this.setPathToActiveDeviceCore(prefix + "Core[@index='" + coreIndex + "']");
                                this.setXmlCoreName(coreName);
                                break;
                            }
                            if (activeCoreIndex >= 0L) {
                                result = (int)activeCoreIndex;
                                boolean ok = this.initializeDeviceInfoPropertiesFromXmlFile(nodeForActiveDeviceCore);
                                if (!ok && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                                    MemoryServerTrace.logError("Could not initialize device info properties from xml file " + this.getXmlFileName(), "XmlDeviceInfoHandler.goToActiveDeviceCore", this.targetInfo);
                                }
                            } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                                MemoryServerTrace.logWarning("XML file " + this.getXmlFileName() + " does not define a core with ID = " + this.targetInfo.getStrTargetProcessorId() + " or " + this.targetInfo.getStrTargetIsaXXId(), "XmlDeviceInfoHandler.goToActiveDeviceCore", this.targetInfo);
                            }
                        }
                    } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                        MemoryServerTrace.logWarning("XML file " + this.getXmlFileName() + ":  XpathNav == null", "XmlDeviceInfoHandler.goToActiveDeviceCore", this.targetInfo);
                    }
                }
                catch (Exception e) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block12;
                    MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + this.getXmlFileName() + ": " + e.getMessage(), "XmlDeviceInfoHandler.goToActiveDeviceCore", e, this.targetInfo);
                }
            }
        }
        return result;
    }

    private int goToActiveDeviceCore() {
        int result;
        block11: {
            long activeCoreIndex = -1L;
            result = -1;
            String prefix = "/CodeComposer/CcsMemoryServer/Device/";
            if (this.readyToUse) {
                try {
                    Hashtable<String, DeviceXMLReader.CoreInfoItem> coreInfoItems = DeviceXMLReader.getInstance(this.target.getMemoryServerXmlPath()).getCoreInfo(this);
                    this.listOfCores.clear();
                    DeviceXMLReader.CoreInfoItem coreInfoItem = null;
                    if (coreInfoItems != null) {
                        for (int i = 0; i < coreInfoItems.size(); ++i) {
                            String pathToActiveDeviceCore = prefix + "Core[@index='" + i + "']";
                            coreInfoItem = coreInfoItems.get(pathToActiveDeviceCore);
                            String coreName = coreInfoItem.name;
                            this.listOfCores.add(coreName);
                            if (!this.targetInfo.getStrTargetProcessorId().equalsIgnoreCase(coreName) && !this.targetInfo.getStrTargetIsaXId().equalsIgnoreCase(coreName) && !this.targetInfo.getStrTargetIsaXXId().equalsIgnoreCase(coreName)) continue;
                            activeCoreIndex = i;
                            this.setPathToActiveDeviceCore(pathToActiveDeviceCore);
                            this.setXmlCoreName(coreName);
                            break;
                        }
                        if (activeCoreIndex >= 0L) {
                            result = (int)activeCoreIndex;
                            boolean ok = this.initializeDeviceInfoPropertiesFromXmlFile(coreInfoItem);
                            if (!ok && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                                MemoryServerTrace.logError("Could not initialize device info properties from xml file " + this.getXmlFileName(), "XmlDeviceInfoHandler.goToActiveDeviceCore", this.targetInfo);
                            }
                        } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                            MemoryServerTrace.logWarning("XML file " + this.getXmlFileName() + " does not define a core with ID = " + this.targetInfo.getStrTargetProcessorId() + " or " + this.targetInfo.getStrTargetIsaXXId(), "XmlDeviceInfoHandler.goToActiveDeviceCore", this.targetInfo);
                        }
                    } else if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                        MemoryServerTrace.logWarning("XML file " + this.getXmlFileName() + ":  XpathNav == null", "XmlDeviceInfoHandler.goToActiveDeviceCore", this.targetInfo);
                    }
                }
                catch (Exception e) {
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block11;
                    MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + this.getXmlFileName() + ": " + e.getMessage(), "XmlDeviceInfoHandler.goToActiveDeviceCore", e, this.targetInfo);
                }
            }
        }
        return result;
    }

    public boolean initializeDeviceInfoPropertiesFromXmlFile(XmlElement node) {
        boolean result = true;
        try {
            this.setIsMemoryLevelVisibilitySupported(node.getChildElementValue("IsMemoryColoringSupported", false));
            this.setIsGTI_GetMemWithStatSupported(node.getChildElementValue("IsGTI_GetMemWithStatSupported", false));
            this.setIsVirtualMemorySupported(node.getChildElementValue("IsVirtualMemorySupported", false));
            MyXPathNodeIterator iter = node.select("DeviceId/IsDeviceIdSupported", false);
            if (iter != null && iter.size() > 0) {
                XmlElement deviceIdSupportedNode = iter.get(0);
                this.setIsDeviceIdSupported(deviceIdSupportedNode.getValueAsBoolean());
            } else {
                this.setIsDeviceIdSupported(false);
            }
            this.targetInfo.setMinNumMausPerMemoryRead(node.getChildElementValue("MinNumMausPerMemoryRead", this.targetInfo.getMinNumMausPerMemoryRead()));
        }
        catch (Exception ex) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException("Failure reading xml device info from " + this.getXmlFileName(), "XmlDeviceInfoHandler.InitializeDeviceInfoPropertiesFromXmlFile", ex, this.targetInfo);
            }
            result = false;
        }
        return result;
    }

    public boolean initializeDeviceInfoPropertiesFromXmlFile(DeviceXMLReader.CoreInfoItem node) {
        boolean result = true;
        try {
            this.setIsMemoryLevelVisibilitySupported(node.isMemoryLevelVisibilitySupported);
            this.setIsGTI_GetMemWithStatSupported(node.isGTI_GetMemWithStatSupported);
            this.setIsVirtualMemorySupported(node.isVirtualMemorySupported);
            this.setIsDeviceIdSupported(node.isDeviceIdSupported);
            if (node.minNumMausPerMemoryRead >= 0) {
                this.targetInfo.setMinNumMausPerMemoryRead(node.minNumMausPerMemoryRead);
            }
        }
        catch (Exception ex) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException("Failure reading xml device info from " + this.getXmlFileName(), "XmlDeviceInfoHandler.InitializeDeviceInfoPropertiesFromXmlFile", ex, this.targetInfo);
            }
            result = false;
        }
        return result;
    }

    public boolean readMemTypesFromXmlFileOld(ArrayList<MemoryTypeDescriptor> listOfMemoryTypes, short memoryPageNumber, RegisterList listOfRegHandlers) {
        boolean result;
        block9: {
            result = false;
            if (this.readyToUse) {
                try {
                    MyXPathNodeIterator adrsSpaceNodeIterator = this.getXpathNav().selectChildNodesOf(this.getPathToActiveDeviceCore() + "/AddressSpace[@page='" + Short.toString(memoryPageNumber) + "']");
                    if (adrsSpaceNodeIterator != null && adrsSpaceNodeIterator.hasNext()) {
                        XmlElement memoryTypeNode = adrsSpaceNodeIterator.findFirstNodeWithName("MemoryType", false, true);
                        int memTypeIndex = 0;
                        while (memoryTypeNode != null) {
                            MemoryTypeDescriptor memType = new MemoryTypeDescriptor(memTypeIndex, memoryPageNumber, this.target, memoryTypeNode, listOfRegHandlers);
                            if (memType.isCache() || memType.getLengthInMAUs() > 0L) {
                                listOfMemoryTypes.add(memType);
                                ++memTypeIndex;
                            } else {
                                if (memType != null && !memType.isDisposed()) {
                                    memType.dispose();
                                }
                                memType = null;
                            }
                            memoryTypeNode = adrsSpaceNodeIterator.findNextNodeWithName("MemoryType", false, true);
                        }
                        result = true;
                    }
                }
                catch (Exception e) {
                    for (int i = 0; i < listOfMemoryTypes.size(); ++i) {
                        MemoryTypeDescriptor memType = listOfMemoryTypes.get(i);
                        if (memType == null || memType.isDisposed()) continue;
                        memType.dispose();
                    }
                    listOfMemoryTypes.clear();
                    this.readyToUse = false;
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block9;
                    MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + this.getXmlFileName() + ": " + e.getMessage(), "XmlDeviceInfoHandler.readMemTypesFromXmlFile", e, this.targetInfo);
                }
            }
        }
        return result;
    }

    public boolean readMemTypesFromXmlFile(ArrayList<MemoryTypeDescriptor> listOfMemoryTypes, short memoryPageNumber, RegisterList listOfRegHandlers) {
        boolean result;
        block8: {
            result = false;
            if (this.readyToUse) {
                try {
                    DeviceXMLReader.AddressSpaceInfo addressSpaceInfo = DeviceXMLReader.getInstance(this.target.getMemoryServerXmlPath()).getAddressSpaceInfo(this, this.getPathToActiveDeviceCore() + "/AddressSpace[@page='" + Short.toString(memoryPageNumber) + "']");
                    if (addressSpaceInfo != null) {
                        int memTypeIndex = 0;
                        for (int i = 0; i < addressSpaceInfo.memoryTypeItems.size(); ++i) {
                            MemoryTypeDescriptor memType = new MemoryTypeDescriptor(memTypeIndex, memoryPageNumber, this.target, addressSpaceInfo.memoryTypeItems.get(i), listOfRegHandlers);
                            if (memType.isCache() || memType.getLengthInMAUs() > 0L) {
                                listOfMemoryTypes.add(memType);
                                ++memTypeIndex;
                                continue;
                            }
                            if (memType != null && !memType.isDisposed()) {
                                memType.dispose();
                            }
                            memType = null;
                        }
                        result = true;
                    }
                }
                catch (Exception e) {
                    for (int i = 0; i < listOfMemoryTypes.size(); ++i) {
                        MemoryTypeDescriptor memType = listOfMemoryTypes.get(i);
                        if (memType == null || memType.isDisposed()) continue;
                        memType.dispose();
                    }
                    listOfMemoryTypes.clear();
                    this.readyToUse = false;
                    if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block8;
                    MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + this.getXmlFileName() + ": " + e.getMessage(), "XmlDeviceInfoHandler.readMemTypesFromXmlFile", e, this.targetInfo);
                }
            }
        }
        return result;
    }

    public boolean readRegisterInfoFromXmlFile(RegisterList listOfRegisterHandlers) {
        boolean result = false;
        if (this.readRegisterInfoFromXmlFile(listOfRegisterHandlers, false, "") != null) {
            result = true;
        }
        return result;
    }

    public RegisterHandler readRegisterInfoFromXmlFileOld(RegisterList listOfRegisterHandlers, boolean getOnlySpecifiedRegister, String nameOfSpecifiedRegister) {
        RegisterHandler result = null;
        MyXPathNodeIterator regIterator = null;
        MyXPathNodeIterator nodeIterator = null;
        RegisterHandler regHandler = null;
        XmlElement nodeAtReg = null;
        boolean createThisRegister = !getOnlySpecifiedRegister;
        boolean done = false;
        String xpathQueryRoot = this.getPathToActiveDeviceCore();
        if (xpathQueryRoot.length() == 0) {
            xpathQueryRoot = "/CodeComposer/CcsMemoryServer";
        }
        xpathQueryRoot = xpathQueryRoot + "/RegisterDefinitions/Register";
        String registerName = "";
        String specifiedName = nameOfSpecifiedRegister.toLowerCase();
        ArrayList<RegisterDecoder> listOfDecoders = null;
        if (listOfRegisterHandlers != null) {
            listOfDecoders = listOfRegisterHandlers.getListOfDecoders();
            listOfDecoders.clear();
        }
        if (this.readyToUse) {
            try {
                if (!getOnlySpecifiedRegister) {
                    this.readDecoderInfoFromXmlFile(listOfDecoders);
                }
                nodeIterator = this.getXpathNav().select(xpathQueryRoot);
                while (!done && nodeIterator.hasNext()) {
                    nodeAtReg = nodeIterator.next();
                    nodeAtReg.getStrXmlPathToNode();
                    if (getOnlySpecifiedRegister) {
                        regIterator = nodeAtReg.getIteratorForChildNodes();
                        XmlElement regInfoNode = regIterator.findNextNodeWithName("Name", false, false);
                        registerName = "";
                        if (regInfoNode != null && (registerName = regInfoNode.getValue().toLowerCase()).equals(specifiedName)) {
                            createThisRegister = true;
                            done = true;
                        }
                    }
                    if (!createThisRegister) continue;
                    regHandler = new RegisterHandler(xpathQueryRoot, this.getXpathNav(), nodeAtReg, listOfDecoders, this.target);
                    if (regHandler != null && listOfRegisterHandlers != null) {
                        listOfRegisterHandlers.add(regHandler);
                    }
                    if (result != null) continue;
                    result = regHandler;
                }
            }
            catch (Exception e) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + this.targetInfo.getXmlDeviceDescriptionFileName() + " : " + e.getMessage(), "XmlDeviceInfoHandler.readRegisterInfoFromXmlFile", e, this.targetInfo);
                }
                result = null;
            }
        }
        return result;
    }

    public RegisterHandler readRegisterInfoFromXmlFile(RegisterList listOfRegisterHandlers, boolean getOnlySpecifiedRegister, String nameOfSpecifiedRegister) {
        RegisterHandler result = null;
        RegisterHandler regHandler = null;
        boolean createThisRegister = !getOnlySpecifiedRegister;
        boolean done = false;
        String xpathQueryRoot = this.getPathToActiveDeviceCore();
        if (xpathQueryRoot.length() == 0) {
            xpathQueryRoot = "/CodeComposer/CcsMemoryServer";
        }
        xpathQueryRoot = xpathQueryRoot + "/RegisterDefinitions/Register";
        String registerName = "";
        String specifiedName = nameOfSpecifiedRegister.toLowerCase();
        ArrayList<RegisterDecoder> listOfDecoders = null;
        if (listOfRegisterHandlers != null) {
            listOfDecoders = listOfRegisterHandlers.getListOfDecoders();
            listOfDecoders.clear();
        }
        if (this.readyToUse) {
            DeviceXMLReader.RegisterInfo registerList = DeviceXMLReader.getInstance(this.target.getMemoryServerXmlPath()).getRegisterInfo(this, xpathQueryRoot);
            if (registerList == null) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logError("Failed to retrieve register info from cache for file: " + this.getXpathNav().xmlFileName, "XmlDeviceInfoHandler.readRegisterInfoFromXmlFile", null);
                }
                return null;
            }
            if (!getOnlySpecifiedRegister) {
                this.readDecoderInfoFromXmlFile(listOfDecoders);
            }
            for (int i = 0; !done && i < registerList.registerItems.size(); ++i) {
                DeviceXMLReader.RegisterInfoItem register = registerList.registerItems.get(i);
                if (getOnlySpecifiedRegister && (registerName = register.name) != null && registerName.equals(specifiedName)) {
                    createThisRegister = true;
                    done = true;
                }
                if (!createThisRegister) continue;
                regHandler = new RegisterHandler(xpathQueryRoot, this.getXpathNav(), register, listOfDecoders, this.target);
                if (regHandler != null && listOfRegisterHandlers != null) {
                    listOfRegisterHandlers.add(regHandler);
                }
                if (result != null) continue;
                result = regHandler;
            }
        }
        return result;
    }

    public boolean readDecoderInfoFromXmlFile(ArrayList<RegisterDecoder> listOfRegisterDecoders) {
        boolean result = false;
        if (this.readDecoderInfoFromXmlFile(listOfRegisterDecoders, false, "") != null) {
            result = true;
        }
        return result;
    }

    public RegisterDecoder readDecoderInfoFromXmlFileOld(ArrayList<RegisterDecoder> listOfRegisterDecoders, boolean getOnlySpecifiedDecoder, String nameOfSpecifiedDecoder) {
        RegisterDecoder result = null;
        MyXPathNodeIterator nodeIterator = null;
        MyXPathNodeIterator decoderIterator = null;
        RegisterDecoder regDecoder = null;
        XmlElement nodeAtDecoder = null;
        boolean createThisDecoder = !getOnlySpecifiedDecoder;
        boolean done = false;
        String decoderName = "";
        String specifiedName = nameOfSpecifiedDecoder.toLowerCase();
        String xpathQueryRoot = this.getPathToActiveDeviceCore();
        if (xpathQueryRoot.length() == 0) {
            xpathQueryRoot = "/CodeComposer/CcsMemoryServer";
        }
        xpathQueryRoot = xpathQueryRoot + "/DecoderDefinitions/Decoder";
        if (this.readyToUse) {
            try {
                nodeIterator = this.getXpathNav().select(xpathQueryRoot);
                while (!done && nodeIterator.hasNext()) {
                    nodeAtDecoder = nodeIterator.next();
                    if (nodeAtDecoder == null) {
                        if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
                        MemoryServerTrace.logError("nodeIterator.next returned null after .hasNext() returned true", "XmlDeviceInfoHandler.readDecoderInfoFromXmlFile", null);
                        continue;
                    }
                    String nodeName = nodeAtDecoder.getName();
                    if ((nodeName == null || !nodeName.equalsIgnoreCase("decoder")) && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                        MemoryServerTrace.logInfo("Unexpected XML node name (" + nodeName + ")", "XmlDeviceInfo.readDecoderInfoFromXmlFile", this.targetInfo);
                    }
                    if (getOnlySpecifiedDecoder) {
                        decoderIterator = nodeAtDecoder.getIteratorForChildNodes();
                        XmlElement decoderInfoNode = decoderIterator.findNextNodeWithName("DecoderName", false, false);
                        decoderName = "";
                        if (decoderInfoNode != null && (decoderName = decoderInfoNode.getValue().toLowerCase()).equals(specifiedName)) {
                            createThisDecoder = true;
                            done = true;
                        }
                    }
                    if (!createThisDecoder) continue;
                    regDecoder = new RegisterDecoder(null, "", this.getXpathNav(), nodeAtDecoder);
                    if (regDecoder != null && listOfRegisterDecoders != null) {
                        listOfRegisterDecoders.add(regDecoder);
                    }
                    if (result != null) continue;
                    result = regDecoder;
                }
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO) && result != null) {
                    String msg = "Read 1 decoder [" + result.getName() + "] from xml file ";
                    if (listOfRegisterDecoders != null) {
                        msg = "Read " + Integer.toString(listOfRegisterDecoders.size()) + " decoders from xml file ";
                    }
                    MemoryServerTrace.logInfo(msg + this.getXmlFileName() + " (Version " + this.xmlFileVersion + ", getOnlySpecifiedDecoder = " + Boolean.toString(getOnlySpecifiedDecoder) + ")", "XmlDeviceInfoHandler.readDecoderInfoFromXmlFile", this.targetInfo);
                }
            }
            catch (Exception e) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + this.getXmlFileName() + ": " + e.getMessage(), "XmlDeviceInfoHandler.ReadDecoderInfoFromXmlFile", e, this.targetInfo);
                }
                result = null;
            }
        }
        return result;
    }

    public RegisterDecoder readDecoderInfoFromXmlFile(ArrayList<RegisterDecoder> listOfRegisterDecoders, boolean getOnlySpecifiedDecoder, String nameOfSpecifiedDecoder) {
        RegisterDecoder result = null;
        RegisterDecoder regDecoder = null;
        boolean createThisDecoder = !getOnlySpecifiedDecoder;
        boolean done = false;
        String decoderName = "";
        String specifiedName = nameOfSpecifiedDecoder.toLowerCase();
        String xpathQueryRoot = this.getPathToActiveDeviceCore();
        if (xpathQueryRoot.length() == 0) {
            xpathQueryRoot = "/CodeComposer/CcsMemoryServer";
        }
        xpathQueryRoot = xpathQueryRoot + "/DecoderDefinitions/Decoder";
        if (this.readyToUse) {
            try {
                DeviceXMLReader.DecoderInfo decoderList = DeviceXMLReader.getInstance(this.target.getMemoryServerXmlPath()).getDecoderInfo(this, xpathQueryRoot);
                if (decoderList == null) {
                    if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                        MemoryServerTrace.logError("Failed to retrieve decoder info from cache for file: " + this.getXpathNav().xmlFileName, "XmlDeviceInfoHandler.ReadDecoderInfoFromXmlFile", null);
                    }
                    result = null;
                }
                for (int i = 0; !done && i < decoderList.decoderItems.size(); ++i) {
                    DeviceXMLReader.DecoderInfoItem decoder = decoderList.decoderItems.get(i);
                    if (getOnlySpecifiedDecoder && (decoderName = decoder.name) != null && decoderName.equals(specifiedName)) {
                        createThisDecoder = true;
                        done = true;
                    }
                    if (!createThisDecoder) continue;
                    regDecoder = new RegisterDecoder(null, "", this.getXpathNav(), decoder, decoderList);
                    if (regDecoder != null && listOfRegisterDecoders != null) {
                        listOfRegisterDecoders.add(regDecoder);
                    }
                    if (result != null) continue;
                    result = regDecoder;
                }
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO) && result != null) {
                    String msg = "Read 1 decoder [" + result.getName() + "] from xml file ";
                    if (listOfRegisterDecoders != null) {
                        msg = "Read " + Integer.toString(listOfRegisterDecoders.size()) + " decoders from xml file ";
                    }
                    MemoryServerTrace.logInfo(msg + this.getXmlFileName() + " (Version " + this.xmlFileVersion + ", getOnlySpecifiedDecoder = " + Boolean.toString(getOnlySpecifiedDecoder) + ")", "XmlDeviceInfoHandler.readDecoderInfoFromXmlFile", this.targetInfo);
                }
            }
            catch (Exception e) {
                if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                    MemoryServerTrace.logException("Failure reading xml Memory Hierarchy description file " + this.getXmlFileName() + ": " + e.getMessage(), "XmlDeviceInfoHandler.ReadDecoderInfoFromXmlFile", e, this.targetInfo);
                }
                result = null;
            }
        }
        return result;
    }

    @Override
    public void dispose() {
        this.dispose(true);
    }

    public synchronized void dispose(boolean disposing) {
        if (!this.disposed && disposing) {
            this.readyToUse = false;
            try {
                if (this.xpathNav != null) {
                    this.xpathNav.dispose();
                }
                this.xpathNav = null;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    public void acquire() {
    }
}

