/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.xml;

import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNodeIterator;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public class XmlElement
implements Node {
    private Node node = null;

    public XmlElement(Node node) {
        this.node = node;
    }

    private Vector<Node> getVector(NodeList nodes) {
        Vector<Node> result = new Vector<Node>();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            result.add(nodes.item(i));
        }
        return result;
    }

    public String getName() {
        String result = "";
        if (this.node != null) {
            result = this.node.getNodeName();
        }
        return result;
    }

    public String getValue() {
        String result = "";
        if (this.node != null) {
            result = this.node.getNodeType() == 3 ? this.node.getNodeValue() : this.node.getTextContent();
        }
        return result;
    }

    public boolean getValueAsBoolean() {
        String strXmlValue = this.getValue().trim();
        boolean result = false;
        if (strXmlValue.contains("1")) {
            result = true;
        } else if (strXmlValue.compareToIgnoreCase("true") == 0) {
            result = true;
        }
        return result;
    }

    public int getValueAsInt() {
        int result = 0;
        String strXmlValue = this.getValue().trim();
        if (strXmlValue.startsWith("0x")) {
            String strNoPrefix = strXmlValue.substring(2, strXmlValue.length());
            result = Integer.parseInt(strNoPrefix, 16);
        } else {
            result = Integer.parseInt(strXmlValue);
        }
        return result;
    }

    public long getValueAsLong() {
        long result = 0L;
        String strXmlValue = this.getValue().trim();
        if (strXmlValue.startsWith("0x")) {
            String strNoPrefix = strXmlValue.substring(2, strXmlValue.length());
            result = Long.parseLong(strNoPrefix, 16);
        } else {
            result = Long.parseLong(strXmlValue);
        }
        return result;
    }

    public double getValueAsDouble() {
        double result = 0.0;
        String strXmlValue = this.getValue().trim();
        result = Double.parseDouble(strXmlValue);
        return result;
    }

    @Override
    public boolean hasAttributes() {
        return this.node.hasAttributes();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.node.getAttributes();
    }

    public MyXPathNodeIterator getIteratorForAttributes() {
        MyXPathNodeIterator result = null;
        NamedNodeMap nodemap = this.node.getAttributes();
        Vector<Node> listOfAttributes = new Vector<Node>();
        for (int index = 0; index < nodemap.getLength(); ++index) {
            listOfAttributes.add(nodemap.item(index));
        }
        result = new MyXPathNodeIterator(listOfAttributes);
        return result;
    }

    public String getAttribute(String attributeName) {
        String result = "";
        if (this.node.hasAttributes()) {
            NamedNodeMap nodemap = this.node.getAttributes();
            Node attrNode = nodemap.getNamedItem(attributeName);
            result = attrNode.getNodeValue();
        }
        return result;
    }

    public int getAttributeAsInt(String attributeName) {
        int result = Integer.parseInt(this.getAttribute(attributeName));
        return result;
    }

    public XmlElement clone() {
        XmlElement result = new XmlElement(this.node.cloneNode(true));
        return result;
    }

    @Override
    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    public XmlElement getFirstChildNode() {
        return new XmlElement(this.node.getFirstChild());
    }

    public MyXPathNodeIterator getIteratorForSiblingNodesWithSameName() {
        MyXPathNodeIterator result = null;
        String nodeName = this.getName();
        Vector<Node> vNodeList = new Vector<Node>();
        for (Node node = this.node; node != null; node = node.getNextSibling()) {
            if (!node.getNodeName().equalsIgnoreCase(nodeName)) continue;
            vNodeList.add(node);
        }
        if (vNodeList.size() > 0) {
            result = new MyXPathNodeIterator(vNodeList);
        }
        return result;
    }

    public MyXPathNodeIterator getIteratorForSiblingNodesWithName(String nameOfNodesToInclude) {
        MyXPathNodeIterator result = null;
        Vector<Node> vNodeList = new Vector<Node>();
        Node node = this.node.getPreviousSibling();
        while (node != null) {
            if (!node.getNodeName().equalsIgnoreCase(nameOfNodesToInclude)) continue;
            vNodeList.add(0, node);
            node = node.getPreviousSibling();
        }
        for (node = this.node; node != null; node = node.getNextSibling()) {
            if (!node.getNodeName().equalsIgnoreCase(nameOfNodesToInclude)) continue;
            vNodeList.add(node);
        }
        if (vNodeList.size() > 0) {
            result = new MyXPathNodeIterator(vNodeList);
        }
        return result;
    }

    public MyXPathNodeIterator getIteratorForSiblingNodes(boolean includeThisNodeInList) {
        MyXPathNodeIterator result = null;
        Vector<Node> vNodeList = new Vector<Node>();
        Node node = this.node;
        if (includeThisNodeInList) {
            vNodeList.add(node);
        }
        while (node != null) {
            node = node.getPreviousSibling();
            vNodeList.add(0, node);
        }
        for (node = this.node.getNextSibling(); node != null; node = node.getNextSibling()) {
            vNodeList.add(node);
        }
        if (vNodeList.size() > 0) {
            result = new MyXPathNodeIterator(vNodeList);
        }
        return result;
    }

    public MyXPathNodeIterator getIteratorForChildNodes() {
        NodeList nodes;
        MyXPathNodeIterator result = null;
        if (this.node != null && (nodes = this.node.getChildNodes()) != null) {
            result = new MyXPathNodeIterator(this.getVector(nodes));
        }
        return result;
    }

    public MyXPathNodeIterator select(String strRelativePath, boolean ignoreCase) {
        MyXPathNodeIterator result = null;
        boolean nodeFound = true;
        Vector<Node> elementList = new Vector<Node>();
        MyXPathNodeIterator childNodeIterator = this.getIteratorForChildNodes();
        if (childNodeIterator != null) {
            XmlElement element = null;
            String strPathRemainingToParse = "";
            int slashIndex = strRelativePath.indexOf("/");
            String elementName = strRelativePath;
            if (slashIndex > 0) {
                elementName = strRelativePath.substring(0, strRelativePath.indexOf("/"));
                strPathRemainingToParse = strRelativePath.substring(slashIndex + 1, strRelativePath.length());
            }
            while (nodeFound & childNodeIterator.hasNext()) {
                element = childNodeIterator.findNextNodeWithName(elementName, false, ignoreCase);
                if (element != null) {
                    if (strPathRemainingToParse.length() > 0) {
                        MyXPathNodeIterator childElementIterator = element.select(strPathRemainingToParse, ignoreCase);
                        if (childElementIterator == null || childElementIterator.size() <= 0) continue;
                        elementList.addAll(childElementIterator.getListOfNodes());
                        continue;
                    }
                    elementList.add(element.node);
                    continue;
                }
                nodeFound = false;
            }
        }
        if (result == null && elementList.size() > 0) {
            result = new MyXPathNodeIterator(elementList);
        }
        return result;
    }

    public boolean getChildElementValue(String elementName, boolean defaultValue) {
        boolean result = defaultValue;
        MyXPathNodeIterator iter = this.getIteratorForChildNodes();
        XmlElement node = iter.findNextNodeWithName(elementName, false, true);
        if (node != null) {
            result = node.getValueAsBoolean();
        }
        return result;
    }

    public String getChildElementValue(String elementName, String defaultValue) {
        String result = defaultValue;
        MyXPathNodeIterator iter = this.getIteratorForChildNodes();
        XmlElement node = iter.findNextNodeWithName(elementName, false, true);
        if (node != null) {
            result = node.getValue();
        }
        return result;
    }

    public int getChildElementValue(String elementName, int defaultValue) {
        int result = defaultValue;
        MyXPathNodeIterator iter = this.getIteratorForChildNodes();
        XmlElement node = iter.findNextNodeWithName(elementName, false, true);
        if (node != null) {
            result = node.getValueAsInt();
        }
        return result;
    }

    public long getChildElementValue(String elementName, long defaultValue) {
        long result = defaultValue;
        MyXPathNodeIterator iter = this.getIteratorForChildNodes();
        XmlElement node = iter.findNextNodeWithName(elementName, false, true);
        if (node != null) {
            result = node.getValueAsLong();
        }
        return result;
    }

    @Override
    public XmlElement getParentNode() {
        XmlElement result = null;
        Node parentNode = this.node.getParentNode();
        if (parentNode != null) {
            result = new XmlElement(this.node.getParentNode());
        }
        return result;
    }

    public String getAttributesAsXPathString() {
        String result = "";
        if (this.hasAttributes()) {
            NamedNodeMap nodeMap = this.getAttributes();
            int numNodes = nodeMap.getLength();
            for (int index = 0; index < numNodes; ++index) {
                Node attributeNode = nodeMap.item(index);
                String attributeNodeName = attributeNode.getNodeName();
                if (attributeNodeName.equalsIgnoreCase("xml:base")) continue;
                result = result + "[@" + attributeNode.getNodeName() + "='" + attributeNode.getNodeValue() + "']";
            }
        }
        return result;
    }

    public String getStrXmlPathToNode() {
        String result = "";
        for (XmlElement element = this; element != null && !element.getName().equalsIgnoreCase("#document"); element = element.getParentNode()) {
            result = "/" + element.getName() + element.getAttributesAsXPathString() + result;
        }
        return result;
    }

    public String toString() {
        String result = "";
        result = this.getStrXmlPathToNode();
        return result;
    }

    @Override
    public Node appendChild(Node arg0) throws DOMException {
        return this.node.appendChild(arg0);
    }

    @Override
    public Node cloneNode(boolean arg0) {
        return this.node.cloneNode(arg0);
    }

    @Override
    public short compareDocumentPosition(Node arg0) throws DOMException {
        return this.node.compareDocumentPosition(arg0);
    }

    @Override
    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    @Override
    public NodeList getChildNodes() {
        return this.node.getChildNodes();
    }

    @Override
    public Object getFeature(String arg0, String arg1) {
        return this.node.getFeature(arg0, arg1);
    }

    @Override
    public Node getFirstChild() {
        return this.node.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        return this.node.getLastChild();
    }

    @Override
    public String getLocalName() {
        return this.node.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.node.getNamespaceURI();
    }

    @Override
    public Node getNextSibling() {
        return this.node.getNextSibling();
    }

    @Override
    public String getNodeName() {
        return this.node.getNodeName();
    }

    @Override
    public short getNodeType() {
        return this.node.getNodeType();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.node.getNodeValue();
    }

    @Override
    public Document getOwnerDocument() {
        return this.node.getOwnerDocument();
    }

    @Override
    public String getPrefix() {
        return this.node.getPrefix();
    }

    @Override
    public Node getPreviousSibling() {
        return this.node.getPreviousSibling();
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.node.getTextContent();
    }

    @Override
    public Object getUserData(String arg0) {
        return this.node.getUserData(arg0);
    }

    @Override
    public Node insertBefore(Node arg0, Node arg1) throws DOMException {
        return this.node.insertBefore(arg0, arg1);
    }

    @Override
    public boolean isDefaultNamespace(String arg0) {
        return this.node.isDefaultNamespace(arg0);
    }

    @Override
    public boolean isEqualNode(Node arg0) {
        return this.node.isEqualNode(arg0);
    }

    @Override
    public boolean isSameNode(Node arg0) {
        return this.node.isSameNode(arg0);
    }

    @Override
    public boolean isSupported(String arg0, String arg1) {
        return this.node.isSupported(arg0, arg1);
    }

    @Override
    public String lookupNamespaceURI(String arg0) {
        return this.node.lookupNamespaceURI(arg0);
    }

    @Override
    public String lookupPrefix(String arg0) {
        return this.node.lookupPrefix(arg0);
    }

    @Override
    public void normalize() {
        this.node.normalize();
    }

    @Override
    public Node removeChild(Node arg0) throws DOMException {
        return this.node.removeChild(arg0);
    }

    @Override
    public Node replaceChild(Node arg0, Node arg1) throws DOMException {
        return this.node.replaceChild(arg0, arg1);
    }

    @Override
    public void setNodeValue(String arg0) throws DOMException {
        this.node.setNodeValue(arg0);
    }

    @Override
    public void setPrefix(String arg0) throws DOMException {
        this.node.setPrefix(arg0);
    }

    @Override
    public void setTextContent(String arg0) throws DOMException {
        this.node.setTextContent(arg0);
    }

    @Override
    public Object setUserData(String arg0, Object arg1, UserDataHandler arg2) {
        return this.node.setUserData(arg0, arg1, arg2);
    }
}

