/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.xml;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTargetType;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.eventhandlers.IGetRegisterContextValuesCompleteEventHandler;
import com.ti.ccstudio.debug.memoryserver.events.internal.XmlFileDiscoveryCompleteEvent;
import com.ti.ccstudio.debug.memoryserver.interfaces.IDisposable;
import com.ti.ccstudio.debug.memoryserver.interfaces.ITargetHandler;
import com.ti.ccstudio.debug.memoryserver.requestdescriptors.RequestDescriptorQueue;
import com.ti.ccstudio.debug.memoryserver.target.CoreNumberHdlr;
import com.ti.ccstudio.debug.memoryserver.target.RegisterDecoder;
import com.ti.ccstudio.debug.memoryserver.target.RegisterHandler;
import com.ti.ccstudio.debug.memoryserver.target.RegisterList;
import com.ti.ccstudio.debug.memoryserver.target.TargetHandler;
import com.ti.ccstudio.debug.memoryserver.xml.DeviceIdHdlr;
import com.ti.ccstudio.debug.memoryserver.xml.XmlDeviceInfoHandler;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.EventObject;

public class XmlFileDiscoveryHandler
implements IGetRegisterContextValuesCompleteEventHandler,
IDisposable {
    private TargetHandler targetHdlr = null;
    private String memoryServerXmlDirectoryPath = "";
    private ArrayList<String> listOfPossibleXmlFileNames = null;
    private String indexFileName = "";
    private RegisterList listOfDeviceIdRegisterHdlrs = null;
    private ArrayList<DeviceIdHdlr> listOfDeviceIdHdlrs = null;
    private XmlDeviceInfoHandler xmlDeviceInfoHdlr = null;
    private CoreNumberHdlr coreNumberHdlr = null;
    private boolean isTargetDiscoveryProcessComplete = false;
    private FilenameFilter filter_GetXmlFiles = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            boolean result;
            boolean bl = result = !name.startsWith(".");
            if (result) {
                result = name.toLowerCase().endsWith("xml");
            }
            return result;
        }
    };
    public XmlFileDiscoveryCompleteEvent onXmlFileDiscoveryComplete = new XmlFileDiscoveryCompleteEvent(this);
    private volatile boolean disposed = false;

    public XmlFileDiscoveryHandler(String xmlFileDirectoryPath, TargetHandler targetHdlr, RequestDescriptorQueue targetAccessRequestQueueObj, RequestDescriptorQueue cExprEvalRequestQueueObj, RequestDescriptorQueue targetRegisterRequestQueueObj) {
        this.targetHdlr = targetHdlr;
        this.isTargetDiscoveryProcessComplete = false;
        this.setMemoryServerXmlDirectoryPath(xmlFileDirectoryPath);
        this.listOfPossibleXmlFileNames = new ArrayList();
        this.listOfDeviceIdHdlrs = new ArrayList();
        this.listOfDeviceIdRegisterHdlrs = new RegisterList(targetHdlr, targetAccessRequestQueueObj, cExprEvalRequestQueueObj, targetRegisterRequestQueueObj, false);
        this.listOfDeviceIdRegisterHdlrs.setName("XmlFileDiscovery.listOfDeviceIdRegisterHdlrs");
        this.listOfDeviceIdRegisterHdlrs.onGetRegisterContextValuesComplete.addListener(this);
    }

    public ITargetHandler getTargetHdlr() {
        return this.targetHdlr;
    }

    public String getMemoryServerXmlDirectoryPath() {
        return this.memoryServerXmlDirectoryPath;
    }

    public void setMemoryServerXmlDirectoryPath(String value) {
        this.memoryServerXmlDirectoryPath = value.replace("%20", " ");
    }

    public ArrayList<String> getListOfPossibleXmlFileNames() {
        return this.listOfPossibleXmlFileNames;
    }

    public String getIndexFileName() {
        return this.indexFileName;
    }

    public boolean isIndexFileAvailable() {
        boolean result = false;
        if (this.indexFileName != null && this.indexFileName.length() > 0) {
            result = true;
        }
        return result;
    }

    public RegisterList getListOfDeviceIdRegisterHdlrs() {
        return this.listOfDeviceIdRegisterHdlrs;
    }

    public void setListOfDeviceIdRegisterHdlrs(RegisterList value) {
        this.listOfDeviceIdRegisterHdlrs = value;
    }

    public ArrayList<DeviceIdHdlr> getListOfDeviceIdHdlrs() {
        return this.listOfDeviceIdHdlrs;
    }

    public XmlDeviceInfoHandler getXmlDeviceInfoHdlr() {
        return this.xmlDeviceInfoHdlr;
    }

    public CoreNumberHdlr getCoreNumberHdlr() {
        return this.coreNumberHdlr;
    }

    public boolean isTargetDiscoveryProcessComplete() {
        return this.isTargetDiscoveryProcessComplete;
    }

    public void setIsTargetDiscoveryComplete(boolean value) {
        this.isTargetDiscoveryProcessComplete = value;
    }

    public int getListOfXmlFiles() {
        boolean exists = new File(this.memoryServerXmlDirectoryPath).exists();
        if (exists && this.targetHdlr.getInfo().getTargetTypeId() != EnumTargetType.NON_DEBUGGABLE_DEVICE && !this.targetHdlr.info.isNoMemoryDevice()) {
            if (this.targetHdlr.getInfo().getTargetTypeId() == EnumTargetType.SIMULATOR) {
                this.getListOfXmlFiles(true, false);
            }
            if (this.targetHdlr.getInfo().getTargetTypeId() == EnumTargetType.EMULATOR || !this.isIndexFileAvailable()) {
                this.getListOfXmlFiles(false, true);
            }
        }
        if (this.listOfPossibleXmlFileNames.size() == 0) {
            this.isTargetDiscoveryProcessComplete = true;
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS) && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                MemoryServerTrace.logWarning("Valid DeviceID not found.  targetHdlr.getInfo().getTargetTypeId() = " + (Object)((Object)this.targetHdlr.getInfo().getTargetTypeId()) + ", IsNoMemoryDevice = " + this.targetHdlr.info.isNoMemoryDevice() + ", Using file: " + this.targetHdlr.getInfo().getXmlDeviceDescriptionFileName(), "XmlFileDiscoveryHandler.getListOfXmlFiles", this.targetHdlr.getInfo());
            }
            this.onXmlFileDiscoveryComplete.raise();
        }
        return this.listOfPossibleXmlFileNames.size();
    }

    public int getListOfXmlFiles(boolean includeSimFiles, boolean includeNonSimFiles) {
        String strProcessorFamily = this.targetHdlr.getInfo().getStrTargetIsaXXId().toLowerCase().trim();
        while (strProcessorFamily.length() > 0 && strProcessorFamily.endsWith("x")) {
            strProcessorFamily = strProcessorFamily.substring(0, strProcessorFamily.length() - 1);
        }
        String lowerCaseFileName = "";
        boolean hasSimSuffix = false;
        boolean isIndexFile = false;
        File dir = new File(this.memoryServerXmlDirectoryPath);
        if (dir != null) {
            String[] xmlFiles;
            for (String fileName : xmlFiles = dir.list(this.filter_GetXmlFiles)) {
                lowerCaseFileName = fileName.toLowerCase();
                if (lowerCaseFileName.indexOf(strProcessorFamily) < 0) continue;
                hasSimSuffix = lowerCaseFileName.indexOf("sim") >= 0;
                boolean bl = isIndexFile = lowerCaseFileName.indexOf("index") >= 0;
                if ((!includeSimFiles || !hasSimSuffix) && (!includeNonSimFiles || hasSimSuffix)) continue;
                if (isIndexFile) {
                    this.indexFileName = fileName;
                    continue;
                }
                this.listOfPossibleXmlFileNames.add(fileName);
            }
        }
        for (int i = 0; i < this.listOfPossibleXmlFileNames.size(); ++i) {
            String fileName = this.listOfPossibleXmlFileNames.get(i);
            if (!fileName.contains("index")) continue;
            this.indexFileName = fileName;
            this.listOfPossibleXmlFileNames.remove(i);
            break;
        }
        return this.listOfPossibleXmlFileNames.size();
    }

    public void getDeviceIdRegisterHdlrs() {
        this.listOfDeviceIdRegisterHdlrs.clear();
        this.listOfDeviceIdHdlrs.clear();
        if (this.isIndexFileAvailable()) {
            this.xmlDeviceInfoHdlr = new XmlDeviceInfoHandler(this.memoryServerXmlDirectoryPath + this.indexFileName, true, this.targetHdlr);
            this.xmlDeviceInfoHdlr.readRegisterInfoFromXmlFile(this.listOfDeviceIdRegisterHdlrs);
            for (int rIndex = 0; rIndex < this.listOfDeviceIdRegisterHdlrs.size(); ++rIndex) {
                RegisterHandler regHdlr = this.listOfDeviceIdRegisterHdlrs.get(rIndex);
                for (int dIndex = 0; dIndex < regHdlr.getListOfDecoders().size(); ++dIndex) {
                    RegisterDecoder regDecoder = regHdlr.getListOfDecoders().get(dIndex);
                    DeviceIdHdlr deviceIdHdlr = new DeviceIdHdlr(regHdlr, regDecoder);
                    this.listOfDeviceIdHdlrs.add(deviceIdHdlr);
                }
            }
        } else {
            for (String fileName : this.listOfPossibleXmlFileNames) {
                DeviceIdHdlr deviceIdHdlr;
                this.xmlDeviceInfoHdlr = new XmlDeviceInfoHandler(this.memoryServerXmlDirectoryPath + fileName, false, this.targetHdlr);
                if (!this.xmlDeviceInfoHdlr.isDeviceIdSupported() || (deviceIdHdlr = new DeviceIdHdlr(this.xmlDeviceInfoHdlr)).getDeviceIdRegHdlr() == null) continue;
                this.listOfDeviceIdHdlrs.add(deviceIdHdlr);
                this.listOfDeviceIdRegisterHdlrs.getListOfDecoders().add(deviceIdHdlr.getDeviceIdDecoder());
                this.listOfDeviceIdRegisterHdlrs.add(deviceIdHdlr.getDeviceIdRegHdlr());
            }
        }
    }

    public void readDeviceIds() {
        if (this.listOfDeviceIdRegisterHdlrs.size() > 0) {
            this.listOfDeviceIdRegisterHdlrs.getRegisterContextValues(true, true, false);
        } else {
            this.handleGetRegisterContextValuesCompleteEvent(null);
        }
    }

    @Override
    public void handleGetRegisterContextValuesCompleteEvent(EventObject e) {
        boolean xmlFileFound = false;
        for (DeviceIdHdlr deviceIdHdlr : this.listOfDeviceIdHdlrs) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
                MemoryServerTrace.logInfo("Checking possible XML file for this target (Reg: " + deviceIdHdlr.getDeviceIdRegHdlr().getName() + " at 0x" + Long.toHexString(deviceIdHdlr.getDeviceIdRegHdlr().getAdrs()) + "=0x" + Long.toHexString(deviceIdHdlr.getDeviceIdRegHdlr().getContextSaveValue()) + ", file=" + deviceIdHdlr.getXmlFileName(), "XmlFileDiscoveryHandler.handleGetRegisterContextValuesCompleteEvent", this.targetHdlr.getInfo());
            }
            if (deviceIdHdlr == null || !deviceIdHdlr.isDeviceIdValidForThisTarget()) continue;
            xmlFileFound = true;
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
                MemoryServerTrace.logWarning("Valid Device ID found for this target.  Using MemoryServerXML file: " + deviceIdHdlr.getXmlFileName(), "XmlFileDiscoveryHandler.ListOfDeviceIdRegisterHdlrs_OnGetRegisterContextValuesComplete", this.targetHdlr.getInfo());
            }
            String fullXmlFileName = this.targetHdlr.getMemoryServerXmlPath() + deviceIdHdlr.getXmlFileName();
            if (this.targetHdlr.getInfo().getXmlDeviceDescriptionFileName().equals(fullXmlFileName)) break;
            this.targetHdlr.getInfo().setXmlDeviceDescriptionFileName(fullXmlFileName);
            break;
        }
        this.isTargetDiscoveryProcessComplete = true;
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS) && !xmlFileFound && MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.WARNINGS)) {
            MemoryServerTrace.logWarning("Valid DeviceID not found.  Using MemoryServerXML file: " + this.targetHdlr.getInfo().getXmlDeviceDescriptionFileName(), "XmlFileDiscoveryHandler.ListOfDeviceIdRegisterHdlrs_OnGetRegisterContextValuesComplete", this.targetHdlr.getInfo());
        }
        this.onXmlFileDiscoveryComplete.raise();
    }

    protected DeviceIdHdlr findDeviceIdHdlr(RegisterHandler regHdlrToLookFor) {
        DeviceIdHdlr foundDeviceIdHdlr = null;
        for (DeviceIdHdlr deviceIdHdlr : this.listOfDeviceIdHdlrs) {
            if (deviceIdHdlr.getDeviceIdRegHdlr() != regHdlrToLookFor) continue;
            foundDeviceIdHdlr = deviceIdHdlr;
            break;
        }
        return foundDeviceIdHdlr;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void dispose() {
        this.dispose(true);
    }

    public synchronized void dispose(boolean disposing) {
        if (!this.disposed) {
            if (disposing) {
                if (this.listOfDeviceIdRegisterHdlrs != null) {
                    this.listOfDeviceIdRegisterHdlrs.onGetRegisterContextValuesComplete.removeListener(this);
                    if (!this.listOfDeviceIdRegisterHdlrs.isDisposed()) {
                        this.listOfDeviceIdRegisterHdlrs.dispose();
                    }
                }
                this.listOfDeviceIdRegisterHdlrs = null;
                if (this.listOfDeviceIdHdlrs != null) {
                    for (DeviceIdHdlr devIdHdlr : this.listOfDeviceIdHdlrs) {
                        if (devIdHdlr.isDisposed()) continue;
                        devIdHdlr.dispose();
                    }
                    this.listOfDeviceIdHdlrs.clear();
                    this.listOfDeviceIdHdlrs = null;
                }
            }
            this.disposed = true;
        }
    }
}

