/*
 * Decompiled with CFR 0.152.
 */
package com.ti.ccstudio.debug.memoryserver.xml;

import com.ti.ccstudio.debug.memoryserver.MemoryServerTrace;
import com.ti.ccstudio.debug.memoryserver.enums.EnumTraceLevel;
import com.ti.ccstudio.debug.memoryserver.target.RegisterDecoder;
import com.ti.ccstudio.debug.memoryserver.target.RegisterHandler;
import com.ti.ccstudio.debug.memoryserver.target.RegisterList;
import com.ti.ccstudio.debug.memoryserver.xml.DeviceXMLReader;
import com.ti.ccstudio.debug.memoryserver.xml.MyXPathNodeIterator;
import com.ti.ccstudio.debug.memoryserver.xml.XmlElement;
import java.awt.Color;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class XmlHelper {
    private boolean allValuesReadWithoutError = true;

    public boolean allValuesReadWithoutError() {
        return this.allValuesReadWithoutError;
    }

    private String stripSlashIfNecessary(String strPath) {
        String result = strPath;
        if (strPath.length() >= 1 && strPath.endsWith("/")) {
            result = strPath.substring(0, strPath.length() - 1);
        }
        return result;
    }

    public String getString(XmlElement parentNode, String xmlElementName, String defaultValue, int maxSearchDepth) {
        String result = defaultValue;
        int depth = 0;
        if (parentNode != null) {
            String parentNodeName = parentNode.getName();
            if (parentNodeName.equalsIgnoreCase(xmlElementName)) {
                result = parentNode.getValue();
            } else {
                depth = 0;
                XmlElement foundNode = this.findNode(parentNode, xmlElementName, depth, maxSearchDepth);
                if (foundNode != null) {
                    result = foundNode.getValue();
                }
            }
        }
        return result;
    }

    private XmlElement findNode(XmlElement parentNode, String xmlElementName, int currentSearchDepth, int maxSearchDepth) {
        boolean found = false;
        XmlElement result = null;
        XmlElement childNode = null;
        int numElements = 0;
        MyXPathNodeIterator iterator = parentNode.select(xmlElementName, false);
        if (iterator != null && (numElements = iterator.size()) > 0) {
            found = true;
            result = iterator.get(0);
        }
        if (!found && currentSearchDepth < maxSearchDepth) {
            for (int index = 0; index < numElements; ++index) {
                childNode = iterator.get(index);
                result = this.findNode(childNode, xmlElementName, currentSearchDepth + 1, maxSearchDepth);
            }
        }
        return result;
    }

    public String getString(Node node, String defaultValue) {
        String result = defaultValue;
        try {
            result = node.getNodeValue();
        }
        catch (Exception ex) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException("Error reading xmlElement", "XmlHelper.GetString", ex, null);
            }
            result = defaultValue;
            this.allValuesReadWithoutError = false;
        }
        return result;
    }

    public boolean getBoolean(MyXPathNodeIterator nodeIterator, String xmlElementName, boolean defaultValue) {
        boolean result = defaultValue;
        XmlElement node = null;
        try {
            node = nodeIterator.findFirstNodeWithName(xmlElementName, true, true);
            if (node != null) {
                result = node.getValueAsBoolean();
            }
        }
        catch (Exception ex) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException("Error reading xml file: xmlElementName = " + xmlElementName, "XmlHelper.getBoolean", ex, null);
            }
            result = defaultValue;
            this.allValuesReadWithoutError = false;
        }
        return result;
    }

    public boolean getBoolean(XmlElement node, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            if (node != null) {
                result = node.getValueAsBoolean();
            }
        }
        catch (Exception ex) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException("Error reading xmlElement", "XmlHelper.GetBool", ex, null);
            }
            result = defaultValue;
            this.allValuesReadWithoutError = false;
        }
        return result;
    }

    public boolean getBoolean(XmlElement parentNode, String xmlElementName, boolean defaultValue, int maxSearchDepth) {
        boolean result = defaultValue;
        int depth = 0;
        if (parentNode.getName().equalsIgnoreCase(xmlElementName)) {
            result = parentNode.getValueAsBoolean();
        } else {
            depth = 1;
            XmlElement foundNode = this.findNode(parentNode, xmlElementName, depth, maxSearchDepth);
            if (foundNode != null) {
                result = foundNode.getValueAsBoolean();
            }
        }
        return result;
    }

    public double getDouble(MyXPathNodeIterator nodeIterator, String xmlElementName, double defaultValue) {
        double result = defaultValue;
        XmlElement node = null;
        try {
            node = nodeIterator.findFirstNodeWithName(xmlElementName, true, true);
            if (node != null) {
                result = node.getValueAsDouble();
            }
        }
        catch (Exception ex) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException("Error reading xml file: xmlElementName " + xmlElementName, "XmlHelper.GetDouble", ex, null);
            }
            result = defaultValue;
            this.allValuesReadWithoutError = false;
        }
        return result;
    }

    public double getDouble(XmlElement node, double defaultValue) {
        double result = defaultValue;
        try {
            if (node != null) {
                result = node.getValueAsDouble();
            }
        }
        catch (Exception ex) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException("Error reading xmlElement", "XmlHelper.GetDouble", ex, null);
            }
            result = defaultValue;
            this.allValuesReadWithoutError = false;
        }
        return result;
    }

    public double getDouble(XmlElement parentNode, String xmlElementName, double defaultValue, int maxSearchDepth) {
        double result = defaultValue;
        int depth = 0;
        if (parentNode.getName().equalsIgnoreCase(xmlElementName)) {
            result = parentNode.getValueAsDouble();
        } else {
            depth = 1;
            XmlElement foundNode = this.findNode(parentNode, xmlElementName, depth, maxSearchDepth);
            if (foundNode != null) {
                result = foundNode.getValueAsDouble();
            }
        }
        return result;
    }

    public long getLongFromString(String value, long defaultValue) {
        long result = defaultValue;
        String strValue = value;
        if (value.length() > 0) {
            int index = strValue.toLowerCase().indexOf("0x", 0);
            if (index >= 0) {
                strValue = strValue.substring(index + 2, strValue.length() - 2);
                result = Long.parseLong(strValue, 16);
            } else {
                result = Long.parseLong(strValue);
            }
        }
        return result;
    }

    public long getLong(MyXPathNodeIterator nodeIterator, String xmlElementName, long defaultValue) {
        long result = defaultValue;
        XmlElement node = null;
        try {
            node = nodeIterator.findFirstNodeWithName(xmlElementName, true, true);
            if (node != null) {
                result = node.getValueAsLong();
            }
        }
        catch (Exception ex) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException("Error reading xml file: xmlElementName = " + xmlElementName, "XmlHelper.getLong", ex, null);
            }
            result = defaultValue;
            this.allValuesReadWithoutError = false;
        }
        return result;
    }

    public long getLong(XmlElement node, long defaultValue) {
        long result = defaultValue;
        try {
            if (node != null) {
                result = node.getValueAsLong();
            }
        }
        catch (Exception ex) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException("Error reading xmlElement", "XmlHelper.getLong", ex, null);
            }
            result = defaultValue;
            this.allValuesReadWithoutError = false;
        }
        return result;
    }

    public long getLong(XmlElement parentNode, String xmlElementName, long defaultValue, int maxSearchDepth) {
        long result = defaultValue;
        int depth = 0;
        if (parentNode.getName().equalsIgnoreCase(xmlElementName)) {
            result = parentNode.getValueAsLong();
        } else {
            depth = 1;
            XmlElement foundNode = this.findNode(parentNode, xmlElementName, depth, maxSearchDepth);
            if (foundNode != null) {
                result = foundNode.getValueAsLong();
            }
        }
        return result;
    }

    public int getInt(MyXPathNodeIterator nodeIterator, String xmlElementName, int defaultValue) {
        int result = defaultValue;
        XmlElement node = null;
        try {
            node = nodeIterator.findFirstNodeWithName(xmlElementName, true, true);
            if (node != null) {
                result = node.getValueAsInt();
            }
        }
        catch (Exception ex) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException("Error reading xml file: xmlElementName = " + xmlElementName, "XmlHelper.getLong", ex, null);
            }
            result = defaultValue;
            this.allValuesReadWithoutError = false;
        }
        return result;
    }

    public int getInt(XmlElement node, int defaultValue) {
        int result = defaultValue;
        try {
            if (node != null) {
                result = node.getValueAsInt();
            }
        }
        catch (Exception ex) {
            if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) {
                MemoryServerTrace.logException("Error reading xmlElement", "XmlHelper.getInt", ex, null);
            }
            result = defaultValue;
            this.allValuesReadWithoutError = false;
        }
        return result;
    }

    public int getInt(XmlElement parentNode, String xmlElementName, int defaultValue, int maxSearchDepth) {
        int result = defaultValue;
        int depth = 0;
        if (parentNode.getName().equalsIgnoreCase(xmlElementName)) {
            result = parentNode.getValueAsInt();
        } else {
            depth = 1;
            XmlElement foundNode = this.findNode(parentNode, xmlElementName, depth, maxSearchDepth);
            if (foundNode != null) {
                result = foundNode.getValueAsInt();
            }
        }
        return result;
    }

    public int getUShort(XmlElement node, short defaultValue) {
        return (int)this.getLong(node, defaultValue);
    }

    public static void listElements(MyXPathNodeIterator iterator, String indent) {
        for (int i = 0; i < iterator.size(); ++i) {
            XmlElement node = iterator.get(i);
            XmlHelper.listElement(node, indent);
        }
    }

    private static void listElement(XmlElement node, String indent) {
        System.out.println(indent + "*Element, name:" + node.getName() + ", text:" + node.getValue().trim());
        XmlHelper.listAttributes(node, indent + " ");
        MyXPathNodeIterator childNodeIterator = node.getIteratorForChildNodes();
        XmlHelper.listElements(childNodeIterator, indent + " ");
    }

    public static void listAttributes(XmlElement node, String indent) {
        MyXPathNodeIterator attributeIterator = null;
        if (node != null && node.hasAttributes()) {
            attributeIterator = node.getIteratorForAttributes();
            for (int i = 0; i < attributeIterator.size(); ++i) {
                XmlElement attributeNode = attributeIterator.get(i);
                System.out.println(indent + "*Attribute, name:" + attributeNode.getName() + ", value:" + attributeNode.getValue());
            }
        }
    }

    public MyXPathNodeIterator navTo(XmlElement rootNode, String strRelativePath) {
        MyXPathNodeIterator result;
        block3: {
            result = null;
            boolean found = false;
            MyXPathNodeIterator nodeIterator = null;
            XmlElement node = null;
            try {
                nodeIterator = rootNode.select(strRelativePath, true);
                while (nodeIterator.hasNext() && !found) {
                    node = nodeIterator.next();
                    if (node == null) continue;
                    found = true;
                    result = node.getIteratorForSiblingNodesWithSameName();
                }
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block3;
                MemoryServerTrace.logException("Exception searching for " + strRelativePath + " from node " + rootNode.getName(), "XmlDeviceInfoHandler.navTo", ex, null);
            }
        }
        return result;
    }

    public RegisterDecoder getRegDecoder(XmlElement nodeToSearchFrom, String strRelativeSearchPath, RegisterList listOfRegHandlers, int maxSearchDepth) {
        RegisterDecoder result = null;
        String strXmlPath2 = this.stripSlashIfNecessary(strRelativeSearchPath);
        String regName = this.getString(nodeToSearchFrom, strXmlPath2 + "/ConfigReg", "", maxSearchDepth);
        RegisterHandler regHandler = listOfRegHandlers.getRegisterHandler(regName);
        if (regHandler != null) {
            String decoderName = this.getString(nodeToSearchFrom, strXmlPath2 + "/DecoderName", "", maxSearchDepth);
            result = regHandler.getDecoder(decoderName);
        }
        return result;
    }

    public DeviceXMLReader.RegDecoderInfo getRegDecoder(XmlElement nodeToSearchFrom, String strRelativeSearchPath, int maxSearchDepth) {
        DeviceXMLReader.RegDecoderInfo result = new DeviceXMLReader.RegDecoderInfo();
        String strXmlPath2 = this.stripSlashIfNecessary(strRelativeSearchPath);
        result.regName = this.getString(nodeToSearchFrom, strXmlPath2 + "/ConfigReg", "", maxSearchDepth);
        result.decoderName = this.getString(nodeToSearchFrom, strXmlPath2 + "/DecoderName", "", maxSearchDepth);
        return result;
    }

    public RegisterDecoder getRegDecoder(MyXPathNodeIterator nodeIterator, RegisterHandler regHandler) {
        RegisterDecoder result;
        block3: {
            String decoderName = "";
            result = null;
            try {
                XmlElement node = nodeIterator.findFirstNodeWithName("DecoderName", true, true);
                if (node != null) {
                    decoderName = this.getString(node, "DecoderName", "", 0);
                    result = regHandler.getDecoder(decoderName);
                }
            }
            catch (Exception ex) {
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) break block3;
                MemoryServerTrace.logException(ex.getMessage(), "XmlHelper.getRegDecoder", ex, null);
            }
        }
        return result;
    }

    public boolean readListOfDecodersForThisRegister(XmlElement nodeAtReg, RegisterHandler regHdlr, ArrayList<RegisterDecoder> listOfDecodersForDevice) {
        boolean decoderFound = false;
        String decoderName = "";
        String xmlDecoderName = "";
        int numDecodersListedForRegHdlr = 0;
        MyXPathNodeIterator nodeIterator = null;
        nodeIterator = nodeAtReg.getIteratorForChildNodes();
        while (nodeIterator.hasNext()) {
            XmlElement node = nodeIterator.next();
            if (!node.getName().equalsIgnoreCase("RegDecoder")) continue;
            ++numDecodersListedForRegHdlr;
            xmlDecoderName = node.getValue();
            decoderName = xmlDecoderName.trim().toLowerCase();
            decoderFound = false;
            for (RegisterDecoder deviceDecoder : listOfDecodersForDevice) {
                if (!deviceDecoder.getName().trim().toLowerCase().equals(decoderName)) continue;
                decoderFound = true;
                regHdlr.getListOfDecoders().add(new RegisterDecoder(regHdlr, deviceDecoder));
                if (!MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.VERBOSE)) break;
                MemoryServerTrace.logVerbose("RegisterDecoder " + xmlDecoderName + " added to register " + regHdlr.getName(), "XmlHelper.readListOfDecodersForThisRegister", null);
                break;
            }
            if (decoderFound || !MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.ERRORS)) continue;
            MemoryServerTrace.logError("Error reading xml file for register " + regHdlr.getName() + ": could not find decoder " + xmlDecoderName, "XmlHelper.readListOfDecodersForThisRegister", null);
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo(Integer.toString(numDecodersListedForRegHdlr) + " found in xml file for register " + regHdlr.getName(), "XmlHelper.readListOfDecodersForThisRegister", null);
        }
        return decoderFound;
    }

    public boolean readListOfDecodersForThisRegister(XmlElement nodeAtReg, String registerName, ArrayList<String> listOfDecodersForDevice) {
        boolean decoderFound = false;
        String decoderName = "";
        String xmlDecoderName = "";
        int numDecodersListedForRegHdlr = 0;
        MyXPathNodeIterator nodeIterator = null;
        nodeIterator = nodeAtReg.getIteratorForChildNodes();
        while (nodeIterator.hasNext()) {
            XmlElement node = nodeIterator.next();
            if (!node.getName().equalsIgnoreCase("RegDecoder")) continue;
            ++numDecodersListedForRegHdlr;
            xmlDecoderName = node.getValue();
            decoderName = xmlDecoderName.trim().toLowerCase();
            listOfDecodersForDevice.add(decoderName);
            decoderFound = false;
        }
        if (MemoryServerTrace.IsTraceOptionEnabled(EnumTraceLevel.INFO)) {
            MemoryServerTrace.logInfo(Integer.toString(numDecodersListedForRegHdlr) + " found in xml file for register " + registerName, "XmlHelper.readListOfDecodersForThisRegister", null);
        }
        return decoderFound;
    }

    public Color getColor(XmlElement parentNode, String xmlElementName, Color defaultBackColor, int maxSearchDepth) {
        String strColorName = this.getString(parentNode, xmlElementName, defaultBackColor.toString(), maxSearchDepth);
        Color result = Color.getColor(strColorName);
        if (result == null) {
            result = Color.white;
        }
        return result;
    }
}

